/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.TxnLogRecord;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.TxnManagerTransaction;
import com.sun.jini.mahalo.log.CannotRecoverException;
import java.util.logging.Level;
import java.util.logging.Logger;

class ParticipantModRecord
implements TxnLogRecord {
    static final long serialVersionUID = 5542043673924560855L;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private ParticipantHandle part;
    private int result;

    ParticipantModRecord(ParticipantHandle part, int result) {
        if (part == null) {
            throw new IllegalArgumentException("ParticipantModRecord: recover: non-null ParticipantHandle recover attempted");
        }
        this.part = part;
        this.result = result;
    }

    ParticipantHandle getPart() {
        return this.part;
    }

    int getResult() {
        return this.result;
    }

    @Override
    public void recover(TxnManagerTransaction tmt) throws CannotRecoverException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(ParticipantModRecord.class.getName(), "recover", tmt);
        }
        if (tmt == null) {
            throw new NullPointerException("ParticipantModRecord: recover: non-null transaction must be specified");
        }
        tmt.modifyParticipant(this.getPart(), this.getResult());
        if (this.getResult() == 6) {
            tmt.modifyTxnState(6);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(ParticipantModRecord.class.getName(), "recover");
        }
    }
}

