/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.PrepareAndCommitRecord;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class PrepareAndCommitJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle handle;
    int maxtries = 5;
    private volatile RemoteException reCaught = null;
    private volatile boolean notifyClient = false;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    public PrepareAndCommitJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle handle) {
        super(pool, wm);
        if (log == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareAndCommitJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handle == null) {
            throw new IllegalArgumentException("PrepareAndCommitJob: PrepareJob: must have participants");
        }
        this.handle = handle;
    }

    @Override
    Object doWork(TaskManager.Task who, Object param) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "doWork", new Object[]{who, param});
        }
        ParticipantHandle handle = (ParticipantHandle)param;
        TransactionParticipant par = null;
        int vote = handle.getPrepState();
        switch (vote) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", vote);
                }
                return vote;
            }
        }
        if (par == null) {
            par = handle.getPreParedParticipant();
        }
        try {
            if (this.attempt(who) > this.maxtries) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", 6);
                }
                return 6;
            }
        }
        catch (JobException je) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
            }
            return null;
        }
        if (par == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
            }
            return null;
        }
        Integer response = null;
        try {
            vote = par.prepareAndCommit(this.tr.mgr, this.tr.id);
            response = vote;
        }
        catch (UnknownTransactionException ute) {
            if (this.reCaught != null) {
                this.notifyClient = true;
            }
            vote = 6;
            response = vote;
        }
        catch (RemoteException re) {
            this.reCaught = re;
            if (operationsLogger.isLoggable(Levels.HANDLED)) {
                operationsLogger.log(Levels.HANDLED, "Ignoring remote exception from participant.", re);
            }
        }
        catch (RuntimeException rte) {
            vote = 6;
            response = vote;
        }
        if (response != null) {
            block24: {
                handle.setPrepState(vote);
                try {
                    this.log.write(new PrepareAndCommitRecord(handle, vote));
                }
                catch (LogException le) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block24;
                    persistenceLogger.log(Level.WARNING, "Problem writing PrepareAndCommitRecord.", le);
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", response);
            }
            return response;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "doWork", null);
        }
        return null;
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[]{new ParticipantTask(this.getPool(), this.getMgr(), this, this.handle)};
        return tmp;
    }

    @Override
    Object computeResult() throws JobException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareAndCommitJob.class.getName(), "computeResult");
        }
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int prepstate = 4;
        prepstate = (Integer)this.results[0];
        Integer result = prepstate;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareAndCommitJob.class.getName(), "computeResult", result);
        }
        return result;
    }

    Exception getAlternateException() {
        if (this.notifyClient) {
            return this.reCaught;
        }
        return null;
    }
}

