/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.mahalo.Job;
import com.sun.jini.mahalo.JobException;
import com.sun.jini.mahalo.JobNotStartedException;
import com.sun.jini.mahalo.ParticipantHandle;
import com.sun.jini.mahalo.ParticipantTask;
import com.sun.jini.mahalo.PrepareRecord;
import com.sun.jini.mahalo.ResultNotReadyException;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.mahalo.log.ClientLog;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionParticipant;

public class PrepareJob
extends Job
implements TransactionConstants {
    ServerTransaction tr;
    ClientLog log;
    ParticipantHandle[] handles;
    int maxtries = 5;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger persistenceLogger = TxnManagerImpl.persistenceLogger;

    public PrepareJob(Transaction tr, TaskManager pool, WakeupManager wm, ClientLog log, ParticipantHandle[] handles) {
        super(pool, wm);
        if (log == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: log is null");
        }
        this.log = log;
        if (!(tr instanceof ServerTransaction)) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must be a ServerTransaction");
        }
        this.tr = (ServerTransaction)tr;
        if (handles == null) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        if (handles.length == 0) {
            throw new IllegalArgumentException("PrepareJob: PrepareJob: must have participants");
        }
        this.handles = handles;
    }

    @Override
    Object doWork(TaskManager.Task who, Object param) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareJob.class.getName(), "doWork", new Object[]{who, param});
        }
        ParticipantHandle handle = (ParticipantHandle)param;
        TransactionParticipant par = null;
        int vote = handle.getPrepState();
        switch (vote) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareJob.class.getName(), "doWork", vote);
                }
                return vote;
            }
        }
        if (par == null) {
            par = handle.getPreParedParticipant();
        }
        try {
            if (this.attempt(who) > this.maxtries) {
                if (operationsLogger.isLoggable(Level.FINER)) {
                    operationsLogger.exiting(PrepareJob.class.getName(), "doWork", 6);
                }
                return 6;
            }
        }
        catch (JobException je) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
            }
            return null;
        }
        if (par == null) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
            }
            return null;
        }
        Integer response = null;
        try {
            vote = par.prepare(this.tr.mgr, this.tr.id);
            response = vote;
        }
        catch (TransactionException bte) {
            vote = 6;
            response = vote;
        }
        catch (RemoteException re) {
        }
        catch (RuntimeException rte) {
            vote = 6;
            response = vote;
        }
        if (response != null) {
            block22: {
                handle.setPrepState(vote);
                try {
                    this.log.write(new PrepareRecord(handle, vote));
                }
                catch (LogException le) {
                    if (!persistenceLogger.isLoggable(Level.WARNING)) break block22;
                    persistenceLogger.log(Level.WARNING, "Problem writing PrepareRecord.", le);
                }
            }
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(PrepareJob.class.getName(), "doWork", response);
            }
            return response;
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareJob.class.getName(), "doWork", null);
        }
        return null;
    }

    @Override
    TaskManager.Task[] createTasks() {
        TaskManager.Task[] tmp = new TaskManager.Task[this.handles.length];
        for (int i = 0; i < this.handles.length; ++i) {
            tmp[i] = new ParticipantTask(this.getPool(), this.getMgr(), this, this.handles[i]);
        }
        return tmp;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    Object computeResult() throws JobException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(PrepareJob.class.getName(), "computeResult");
        }
        try {
            if (!this.isCompleted(0L)) {
                throw new ResultNotReadyException("Cannot compute result since there are jobs pending");
            }
        }
        catch (JobNotStartedException jnse) {
            throw new ResultNotReadyException("Cannot compute result since jobs were not created");
        }
        int prepstate = 4;
        int tmp = 0;
        block7: for (int i = 0; i < this.results.length; ++i) {
            tmp = (Integer)this.results[i];
            switch (tmp) {
                case 4: {
                    break;
                }
                case 6: {
                    prepstate = 6;
                    break block7;
                }
                case 3: {
                    if (prepstate != 4) break;
                    prepstate = 3;
                }
            }
        }
        Integer result = prepstate;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(PrepareJob.class.getName(), "computeResult", result);
        }
        return result;
    }
}

