/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.logging.Levels;
import com.sun.jini.mahalo.TxnManagerImpl;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;

public class SettlerTask
extends RetryTask
implements TransactionConstants {
    private long tid;
    private int attempt;
    private int maxtries = Integer.MAX_VALUE;
    private TransactionManager txnmgr;
    private static final Logger operationsLogger = TxnManagerImpl.operationsLogger;
    private static final Logger transactionsLogger = TxnManagerImpl.transactionsLogger;

    public SettlerTask(TaskManager manager, WakeupManager wm, TransactionManager txnmgr, long tid) {
        super(manager, wm);
        if (txnmgr == null) {
            throw new IllegalArgumentException("SettlerTask: SettlerTask: txnmgr must be non-null");
        }
        this.txnmgr = txnmgr;
        this.tid = tid;
    }

    @Override
    public boolean runAfter(List list, int max) {
        return false;
    }

    @Override
    public boolean tryOnce() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(SettlerTask.class.getName(), "tryOnce");
        }
        try {
            if (this.attempt >= this.maxtries) {
                return true;
            }
            ++this.attempt;
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Attempting to settle transaction id: {0}", this.tid);
            }
            int state = this.txnmgr.getState(this.tid);
            switch (state) {
                case 2: 
                case 5: {
                    this.txnmgr.commit(this.tid, Long.MAX_VALUE);
                    break;
                }
                case 6: {
                    this.txnmgr.abort(this.tid, Long.MAX_VALUE);
                    break;
                }
                default: {
                    if (transactionsLogger.isLoggable(Level.WARNING)) {
                        transactionsLogger.log(Level.WARNING, "Attempting to settle transaction in an invalid state: {0}", state);
                    }
                    break;
                }
            }
        }
        catch (NoSuchObjectException nsoe) {
            if (transactionsLogger.isLoggable(Level.WARNING)) {
                transactionsLogger.log(Level.WARNING, "Unable to settle recovered transaction", nsoe);
            }
        }
        catch (TransactionException te) {
            if (transactionsLogger.isLoggable(Levels.HANDLED)) {
                transactionsLogger.log(Levels.HANDLED, "Unable to settle recovered transaction", te);
            }
        }
        catch (RemoteException re) {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(SettlerTask.class.getName(), "tryOnce", false);
            }
            return false;
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Transaction id {0} was settled", this.tid);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(SettlerTask.class.getName(), "tryOnce", Boolean.TRUE);
        }
        return true;
    }
}

