/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mahalo;

import com.sun.jini.config.Config;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.mahalo.JoinStateManager;
import com.sun.jini.mahalo.LeaseExpirationMgr;
import com.sun.jini.mahalo.ProxyVerifier;
import com.sun.jini.mahalo.SettlerTask;
import com.sun.jini.mahalo.TxnLogRecord;
import com.sun.jini.mahalo.TxnManager;
import com.sun.jini.mahalo.TxnManagerTransaction;
import com.sun.jini.mahalo.TxnMgrAdminProxy;
import com.sun.jini.mahalo.TxnMgrProxy;
import com.sun.jini.mahalo.TxnSettler;
import com.sun.jini.mahalo.log.LogException;
import com.sun.jini.mahalo.log.LogManager;
import com.sun.jini.mahalo.log.LogRecord;
import com.sun.jini.mahalo.log.LogRecovery;
import com.sun.jini.mahalo.log.MultiLogManager;
import com.sun.jini.mahalo.log.MultiLogManagerAdmin;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.system.FileSystem;
import com.sun.jini.thread.InterruptedStatusThread;
import com.sun.jini.thread.ReadyState;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.File;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.transaction.CannotAbortException;
import net.jini.core.transaction.CannotCommitException;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.TimeoutExpiredException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.CrashCountException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

class TxnManagerImpl
implements TxnManager,
LeaseExpirationMgr.Expirer,
LogRecovery,
TxnSettler,
TimeConstants,
LocalLandlord,
ServerProxyTrust,
ProxyAccessor {
    static final Logger startupLogger = Logger.getLogger("com.sun.jini.mahalo.startup");
    static final Logger initLogger = Logger.getLogger("com.sun.jini.mahalo.init");
    static final Logger destroyLogger = Logger.getLogger("com.sun.jini.mahalo.destroy");
    static final Logger operationsLogger = Logger.getLogger("com.sun.jini.mahalo.operations");
    static final Logger transactionsLogger = Logger.getLogger("com.sun.jini.mahalo.transactions");
    static final Logger participantLogger = Logger.getLogger("com.sun.jini.mahalo.participant");
    static final Logger persistenceLogger = Logger.getLogger("com.sun.jini.mahalo.persistence");
    private LogManager logmgr;
    private transient int settlerthreads = 150;
    private transient long settlertimeout = 15000L;
    private transient float settlerload = 1.0f;
    private transient int taskthreads = 50;
    private transient long tasktimeout = 15000L;
    private transient float taskload = 1.0f;
    private transient TaskManager settlerpool;
    private WakeupManager settlerWakeupMgr;
    private transient TaskManager taskpool;
    private WakeupManager taskWakeupMgr;
    private transient Map txns;
    private transient Vector unsettledtxns;
    private transient InterruptedStatusThread settleThread;
    private String persistenceDirectory = null;
    private ActivationID activationID;
    private boolean activationPrepared;
    private ActivationSystem activationSystem;
    private ProxyPreparer participantPreparer;
    protected Exporter exporter;
    protected LoginContext loginContext;
    private static transient SecureRandom idGen = new SecureRandom();
    private static final transient byte[] idGenBuf = new byte[8];
    private LeaseExpirationMgr expMgr;
    private LeasePeriodPolicy txnLeasePeriodPolicy = null;
    private LeaseFactory leaseFactory = null;
    private JoinStateManager joinStateManager;
    private Uuid topUuid = null;
    private TxnMgrProxy txnMgrProxy;
    private TxnMgrAdminProxy txnMgrAdminProxy;
    private TxnManager serverStub = null;
    private LifeCycle lifeCycle = null;
    private final ReadyState readyState = new ReadyState();
    private boolean persistent = true;
    private static final long MAX_UNEXPORT_DELAY = 120000L;

    TxnManagerImpl(String[] args, LifeCycle lc, boolean persistent) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{Arrays.asList(args), lc, persistent});
        }
        this.lifeCycle = lc;
        this.persistent = persistent;
        try {
            this.init(args);
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
    }

    TxnManagerImpl(ActivationID activationID, MarshalledObject data) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "TxnManagerImpl", new Object[]{activationID, data});
        }
        this.activationID = activationID;
        try {
            this.init((String[])data.get());
        }
        catch (Throwable e) {
            this.cleanup();
            this.initFailed(e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "TxnManagerImpl");
        }
    }

    private void init(String[] configArgs) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "init", configArgs);
        }
        Configuration config = ConfigurationProvider.getInstance(configArgs, this.getClass().getClassLoader());
        this.loginContext = (LoginContext)config.getEntry("com.sun.jini.mahalo", "loginContext", LoginContext.class, null);
        if (this.loginContext != null) {
            this.doInitWithLogin(config, this.loginContext);
        } else {
            this.doInit(config);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "init");
        }
    }

    private void doInitWithLogin(final Configuration config, LoginContext loginContext) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInitWithLogin", new Object[]{config, loginContext});
        }
        loginContext.login();
        try {
            Subject.doAsPrivileged(loginContext.getSubject(), new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    TxnManagerImpl.this.doInit(config);
                    return null;
                }
            }, null);
        }
        catch (PrivilegedActionException e) {
            block6: {
                try {
                    loginContext.logout();
                }
                catch (LoginException le) {
                    if (!initLogger.isLoggable(Levels.HANDLED)) break block6;
                    initLogger.log(Levels.HANDLED, "Trouble logging out", le);
                }
            }
            throw e.getException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInitWithLogin");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doInit(Configuration config) throws Exception {
        Object activationIdPreparer;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "doInit", config);
        }
        if (this.activationID != null) {
            ProxyPreparer activationSystemPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "activationSystemPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationSystemPreparer: {0}", activationSystemPreparer);
            }
            this.activationSystem = (ActivationSystem)activationSystemPreparer.prepareProxy(ActivationGroup.getSystem());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activation system is: {0}", this.activationSystem);
            }
            activationIdPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "activationIdPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "activationIdPreparer: {0}", activationIdPreparer);
            }
            this.activationID = (ActivationID)activationIdPreparer.prepareProxy(this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Prepared activationID is: {0}", this.activationID);
            }
            this.activationPrepared = true;
            this.exporter = (Exporter)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "serverExporter", Exporter.class, new ActivationExporter(this.activationID, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, true)), this.activationID);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Activatable service exporter is: {0}", this.exporter);
            }
        } else {
            this.exporter = (Exporter)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "serverExporter", Exporter.class, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, true));
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Non-activatable service exporter is: {0}", this.exporter);
            }
        }
        ProxyPreparer recoveredParticipantPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "recoveredParticipantPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Recovered participant preparer is: {0}", recoveredParticipantPreparer);
        }
        this.participantPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "participantPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "Participant preparer is: {0}", this.participantPreparer);
        }
        this.txnLeasePeriodPolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "leasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(10800000L, 3600000L));
        if (initLogger.isLoggable(Level.CONFIG)) {
            initLogger.log(Level.CONFIG, "leasePeriodPolicy is: {0}", this.txnLeasePeriodPolicy);
        }
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "persistenceDirectory", String.class);
            if (initLogger.isLoggable(Level.CONFIG)) {
                initLogger.log(Level.CONFIG, "Persistence directory is: {0}", this.persistenceDirectory);
            }
        } else {
            this.persistenceDirectory = null;
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Creating JoinStateManager");
        }
        this.joinStateManager = new JoinStateManager(this.persistenceDirectory);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Recovering join state ...");
        }
        this.joinStateManager.recover();
        if (this.joinStateManager.getServiceUuid() == null) {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Generating service Uuid");
            }
            this.topUuid = UuidFactory.generate();
            this.joinStateManager.setServiceUuid(this.topUuid);
        } else {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering service Uuid");
            }
            this.topUuid = this.joinStateManager.getServiceUuid();
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Uuid is: {0}", this.topUuid);
        }
        if (this.persistent) {
            FileSystem.ensureDir(this.persistenceDirectory);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Exporting server");
        }
        this.serverStub = (TxnManager)this.exporter.export(this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Server stub: {0}", this.serverStub);
        }
        this.txnMgrProxy = TxnMgrProxy.create(this.serverStub, this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service proxy is: {0}", this.txnMgrProxy);
        }
        this.txnMgrAdminProxy = TxnMgrAdminProxy.create(this.serverStub, this.topUuid);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Service admin proxy is: {0}", this.txnMgrAdminProxy);
        }
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up data structures");
        }
        this.txns = Collections.synchronizedMap(new HashMap());
        this.settlerWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.taskWakeupMgr = new WakeupManager(new WakeupManager.ThreadDesc(null, true));
        this.settlerpool = (TaskManager)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "settlerPool", TaskManager.class, new TaskManager(this.settlerthreads, this.settlertimeout, this.settlerload));
        this.taskpool = (TaskManager)Config.getNonNullEntry(config, "com.sun.jini.mahalo", "taskPool", TaskManager.class, new TaskManager(this.taskthreads, this.tasktimeout, this.taskload));
        this.unsettledtxns = new Vector();
        this.leaseFactory = new LeaseFactory(this.serverStub, this.topUuid);
        this.expMgr = new LeaseExpirationMgr(this);
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Setting up log manager");
        }
        this.logmgr = this.persistent ? new MultiLogManager(this, this.persistenceDirectory) : new MultiLogManager();
        try {
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Recovering state");
            }
            this.logmgr.recover();
            activationIdPreparer = this.txns;
            synchronized (activationIdPreparer) {
                for (TxnManagerTransaction txn : this.txns.values()) {
                    if (initLogger.isLoggable(Level.FINEST)) {
                        initLogger.log(Level.FINEST, "Restoring transient state for txn id: {0}", ((ServerTransaction)txn.getTransaction()).id);
                    }
                    try {
                        txn.restoreTransientState(recoveredParticipantPreparer);
                    }
                    catch (RemoteException re) {
                        if (!persistenceLogger.isLoggable(Level.WARNING)) continue;
                        persistenceLogger.log(Level.WARNING, "Cannot restore the TransactionParticipant", re);
                    }
                }
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Settling incomplete transactions");
            }
            this.settleThread = new InterruptedStatusThread("settleThread"){

                @Override
                public void run() {
                    try {
                        TxnManagerImpl.this.settleTxns();
                    }
                    catch (InterruptedException ie) {
                        if (transactionsLogger.isLoggable(Level.FINEST)) {
                            transactionsLogger.log(Level.FINEST, "settleThread interrupted -- exiting");
                        }
                        return;
                    }
                }
            };
            this.settleThread.start();
        }
        catch (LogException le) {
            RemoteException re = new RemoteException("Problem recovering state");
            initLogger.throwing(TxnManagerImpl.class.getName(), "doInit", re);
            throw re;
        }
        TxnManagerImpl.nextID();
        if (initLogger.isLoggable(Level.FINEST)) {
            initLogger.log(Level.FINEST, "Starting JoinStateManager");
        }
        this.joinStateManager.startManager(config, this.txnMgrProxy, new ServiceID(this.topUuid.getMostSignificantBits(), this.topUuid.getLeastSignificantBits()), TxnManagerImpl.attributesFor());
        if (startupLogger.isLoggable(Level.INFO)) {
            startupLogger.log(Level.INFO, "Mahalo started: {0}", this);
        }
        this.readyState.ready();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "doInit");
        }
    }

    @Override
    public TransactionManager.Created create(long lease) throws LeaseDeniedException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "create", lease);
        }
        this.readyState.check();
        TxnManagerTransaction txntr = null;
        long tid = TxnManagerImpl.nextID();
        Uuid uuid = this.createLeaseUuid(tid);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Transaction ID is: {0}", tid);
        }
        txntr = new TxnManagerTransaction(this.txnMgrProxy, this.logmgr, tid, this.taskpool, this.taskWakeupMgr, this, uuid);
        LandlordLease txnmgrlease = null;
        try {
            LeasePeriodPolicy.Result r = this.txnLeasePeriodPolicy.grant(txntr, lease);
            txntr.setExpiration(r.expiration);
            txnmgrlease = this.leaseFactory.newLease(uuid, r.expiration);
            this.expMgr.register(txntr);
        }
        catch (LeaseDeniedException lde) {
            throw new AssertionError((Object)("Transaction lease was denied" + lde));
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Created new TxnManagerTransaction ID is: {0}", tid);
        }
        Transaction tr = txntr.getTransaction();
        ServerTransaction str = null;
        try {
            str = this.serverTransaction(tr);
            this.txns.put(str.id, txntr);
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "recorded new TxnManagerTransaction", txntr);
            }
        }
        catch (Exception e) {
            if (transactionsLogger.isLoggable(Level.FINEST)) {
                transactionsLogger.log(Level.FINEST, "Problem creating transaction", e);
            }
            RuntimeException wrap = new RuntimeException("Unable to create transaction", e);
            transactionsLogger.throwing(TxnManagerImpl.class.getName(), "create", wrap);
            throw wrap;
        }
        TransactionManager.Created tmp = new TransactionManager.Created(str.id, txnmgrlease);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "create", tmp);
        }
        return tmp;
    }

    @Override
    public void join(long id, TransactionParticipant part, long crashCount) throws UnknownTransactionException, CannotJoinException, CrashCountException, RemoteException {
        TxnManagerTransaction txntr;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "join", new Object[]{id, part, crashCount});
        }
        this.readyState.check();
        TransactionParticipant preparedTarget = null;
        preparedTarget = (TransactionParticipant)this.participantPreparer.prepareProxy(part);
        if (participantLogger.isLoggable(Level.FINEST)) {
            participantLogger.log(Level.FINEST, "prepared participant: {0}", preparedTarget);
        }
        if ((txntr = (TxnManagerTransaction)this.txns.get(id)) == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        txntr.join(preparedTarget, crashCount);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "join");
        }
    }

    @Override
    public int getState(long id) throws UnknownTransactionException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getState", new Object[]{id});
        }
        this.readyState.check();
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(id);
        if (txntr == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        int state = txntr.getState();
        if (state == 1 && !TxnManagerImpl.ensureCurrent(txntr)) {
            throw new UnknownTransactionException("unknown transaction");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getState", state);
        }
        return state;
    }

    @Override
    public void commit(long id) throws UnknownTransactionException, CannotCommitException, RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit", id);
        }
        this.readyState.check();
        try {
            this.commit(id, 0L);
        }
        catch (TimeoutExpiredException timeoutExpiredException) {
            // empty catch block
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "commit");
        }
    }

    @Override
    public void commit(long id, long waitFor) throws UnknownTransactionException, CannotCommitException, TimeoutExpiredException, RemoteException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "commit", new Object[]{id, waitFor});
        }
        this.readyState.check();
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(id);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txntr);
        }
        if (txntr == null) {
            throw new UnknownTransactionException("Unknown transaction");
        }
        txntr.commit(waitFor);
        this.txns.remove(id);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Committed transaction id {0}", id);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "commit");
        }
    }

    @Override
    public void abort(long id) throws UnknownTransactionException, CannotAbortException {
        this.abort(id, true);
    }

    private void abort(long id, boolean doExpiryCheck) throws UnknownTransactionException, CannotAbortException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{id});
        }
        this.readyState.check();
        try {
            this.abort(id, 0L, doExpiryCheck);
        }
        catch (TimeoutExpiredException tee) {
            // empty catch block
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    @Override
    public void abort(long id, long waitFor) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException {
        this.abort(id, waitFor, true);
    }

    private void abort(long id, long waitFor, boolean doExpiryCheck) throws UnknownTransactionException, CannotAbortException, TimeoutExpiredException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "abort", new Object[]{id, waitFor});
        }
        this.readyState.check();
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(id);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Retrieved TxnManagerTransaction: {0}", txntr);
        }
        if (txntr != null) {
            if (txntr.getState() == 5) {
                if (doExpiryCheck && !TxnManagerImpl.ensureCurrent(txntr)) {
                    throw new TimeoutExpiredException("Cannot abort, transaction probably expired", true);
                }
                throw new CannotAbortException("Already committed");
            }
        } else {
            throw new UnknownTransactionException("No such transaction [" + id + "]");
        }
        txntr.abort(waitFor);
        this.txns.remove(id);
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "aborted transaction id {0}", id);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "abort");
        }
    }

    @Override
    public void recover(long cookie, LogRecord rec) throws LogException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "recover", new Object[]{cookie, rec});
        }
        TxnManagerTransaction tmt = this.enterTMT(cookie);
        TxnLogRecord trec = (TxnLogRecord)rec;
        trec.recover(tmt);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "recover");
        }
    }

    @Override
    public synchronized void noteUnsettledTxn(long tid) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "noteUnsettledTxn", new Object[]{tid});
        }
        this.unsettledtxns.add(tid);
        this.notifyAll();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "noteUnsettledTxn");
        }
    }

    private synchronized void settleTxns() throws InterruptedException {
        Object log = null;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "settleTxns");
        }
        if (transactionsLogger.isLoggable(Level.FINEST)) {
            transactionsLogger.log(Level.FINEST, "Settling {0} transactions.", this.unsettledtxns.size());
        }
        int numtxns = 0;
        Long first = null;
        long tid = 0L;
        while (true) {
            if ((numtxns = this.unsettledtxns.size()) == 0) {
                if (transactionsLogger.isLoggable(Level.FINEST)) {
                    transactionsLogger.log(Level.FINEST, "Settler waiting");
                }
                this.wait();
                if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
                transactionsLogger.log(Level.FINEST, "Settler notified");
                continue;
            }
            first = null;
            first = (Long)this.unsettledtxns.firstElement();
            tid = first;
            SettlerTask task = new SettlerTask(this.settlerpool, this.settlerWakeupMgr, this, tid);
            this.settlerpool.add(task);
            this.unsettledtxns.remove(first);
            if (this.settleThread.hasBeenInterrupted()) {
                throw new InterruptedException("settleTxns interrupted");
            }
            if (!transactionsLogger.isLoggable(Level.FINEST)) continue;
            transactionsLogger.log(Level.FINEST, "Added SettlerTask for tid {0}", tid);
        }
    }

    @Override
    public Transaction getTransaction(long id) throws UnknownTransactionException {
        this.readyState.check();
        if (id == -1L) {
            return null;
        }
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(id);
        if (txntr == null) {
            throw new UnknownTransactionException("unknown transaction");
        }
        Transaction tn = txntr.getTransaction();
        ServerTransaction tr = this.serverTransaction(tn);
        if (tr == null) {
            throw new UnknownTransactionException("TxnManagerImpl: getTransaction: unable to find transaction(" + id + ")");
        }
        if (!tr.mgr.equals(this)) {
            throw new UnknownTransactionException("wrong manager (" + tr.mgr + " instead of " + this + ")");
        }
        return tr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Uuid uuid, long extension) throws UnknownLeaseException, LeaseDeniedException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renew", new Object[]{uuid, extension});
        }
        this.readyState.check();
        this.verifyLeaseUuid(uuid);
        Long tid = this.getLeaseTid(uuid);
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(tid);
        if (txntr == null) {
            throw new UnknownLeaseException();
        }
        TxnManagerTransaction txnManagerTransaction = txntr;
        synchronized (txnManagerTransaction) {
            if (!TxnManagerImpl.ensureCurrent(txntr)) {
                throw new UnknownLeaseException("Lease already expired");
            }
            long oldExpiration = txntr.getExpiration();
            LeasePeriodPolicy.Result r = this.txnLeasePeriodPolicy.renew(txntr, extension);
            txntr.setExpiration(r.expiration);
            this.expMgr.renewed(txntr);
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "renew", new Object[]{r.duration});
            }
            return r.duration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Uuid uuid) throws UnknownLeaseException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancel", new Object[]{uuid});
        }
        this.readyState.check();
        this.verifyLeaseUuid(uuid);
        Long tid = this.getLeaseTid(uuid);
        TxnManagerTransaction txntr = (TxnManagerTransaction)this.txns.get(tid);
        if (txntr == null) {
            throw new UnknownLeaseException();
        }
        int state = txntr.getState();
        if (state == 1 && txntr.getExpiration() == 0L || state != 1) {
            throw new UnknownLeaseException("unknown transaction");
        }
        if (state == 1) {
            try {
                TxnManagerTransaction txnManagerTransaction = txntr;
                synchronized (txnManagerTransaction) {
                    if (txntr.getExpiration() == 0L) {
                        throw new TimeoutExpiredException("Transaction already expired", true);
                    }
                    txntr.setExpiration(0L);
                }
                this.abort((long)tid, false);
            }
            catch (TransactionException e) {
                throw new UnknownLeaseException("When canceling abort threw:" + e.getClass().getName() + ":" + e.getLocalizedMessage());
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancel");
        }
    }

    @Override
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extensions) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "renewAll");
        }
        this.readyState.check();
        Landlord.RenewResults results = LandlordUtil.renewAll(this, cookies, extensions);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "renewAll");
        }
        return results;
    }

    @Override
    public Map cancelAll(Uuid[] cookies) {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "cancelAll");
        }
        this.readyState.check();
        Map results = LandlordUtil.cancelAll(this, cookies);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cancelAll");
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static long nextID() {
        long id;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "nextID");
        }
        SecureRandom secureRandom = idGen;
        synchronized (secureRandom) {
            do {
                id = 0L;
                idGen.nextBytes(idGenBuf);
                for (int i = 0; i < 8; ++i) {
                    id = id << 8 | (long)(idGenBuf[i] & 0xFF);
                }
            } while (id == 0L);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "nextID", id);
        }
        return id;
    }

    private ServerTransaction serverTransaction(Transaction baseTr) throws UnknownTransactionException {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "serverTransaction", baseTr);
        }
        try {
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(TxnManagerImpl.class.getName(), "serverTransaction", baseTr);
            }
            return (ServerTransaction)baseTr;
        }
        catch (ClassCastException e) {
            throw new UnknownTransactionException("unexpected transaction type");
        }
    }

    @Override
    public TransactionManager manager() {
        this.readyState.check();
        return this.txnMgrProxy;
    }

    private TxnManagerTransaction enterTMT(long cookie) {
        TxnManagerTransaction tmt;
        Long key = cookie;
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "enterTMT", key);
        }
        if ((tmt = (TxnManagerTransaction)this.txns.get(key)) == null) {
            Uuid uuid = this.createLeaseUuid(cookie);
            tmt = new TxnManagerTransaction(this.txnMgrProxy, this.logmgr, cookie, this.taskpool, this.taskWakeupMgr, this, uuid);
            this.noteUnsettledTxn(cookie);
        }
        this.txns.put(key, tmt);
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "enterTMT", tmt);
        }
        return tmt;
    }

    @Override
    public void destroy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "destroy");
        }
        this.readyState.check();
        new DestroyThread().start();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "destroy");
        }
    }

    @Override
    public Object getAdmin() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getAdmin");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getAdmin", this.txnMgrAdminProxy);
        }
        return this.txnMgrAdminProxy;
    }

    @Override
    public Entry[] getLookupAttributes() {
        this.readyState.check();
        return this.joinStateManager.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) {
        this.readyState.check();
        this.joinStateManager.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        this.readyState.check();
        this.joinStateManager.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() {
        this.readyState.check();
        return this.joinStateManager.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) {
        this.readyState.check();
        this.joinStateManager.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() {
        this.readyState.check();
        return this.joinStateManager.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.readyState.check();
        this.joinStateManager.setLookupLocators(locators);
    }

    private static Entry[] attributesFor() {
        ServiceInfo info = new ServiceInfo("Transaction Manager", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.0", "", "");
        BasicServiceType type = new BasicServiceType("Transaction Manager");
        return new Entry[]{info, type};
    }

    @Override
    public Object getProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getProxy");
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxy", this.serverStub);
        }
        return this.serverStub;
    }

    @Override
    public Object getServiceProxy() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "getServiceProxy");
        }
        this.readyState.check();
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getServiceProxy", this.txnMgrProxy);
        }
        return this.txnMgrProxy;
    }

    protected void initFailed(Throwable e) throws Exception {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.entering(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (initLogger.isLoggable(Level.SEVERE)) {
            initLogger.log(Level.SEVERE, "Mahalo failed to initialize", e);
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "initFailed");
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        IllegalStateException ise = new IllegalStateException(e.getMessage());
        ise.initCause(e);
        throw ise;
    }

    private void cleanup() {
        block32: {
            block31: {
                block30: {
                    block29: {
                        block28: {
                            if (operationsLogger.isLoggable(Level.FINER)) {
                                operationsLogger.entering(TxnManagerImpl.class.getName(), "cleanup");
                            }
                            if (this.serverStub != null) {
                                try {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Unexporting service");
                                    }
                                    this.exporter.unexport(true);
                                }
                                catch (Throwable t) {
                                    if (!initLogger.isLoggable(Levels.HANDLED)) break block28;
                                    initLogger.log(Levels.HANDLED, "Trouble unexporting service", t);
                                }
                            }
                        }
                        if (this.settlerpool != null) {
                            if (initLogger.isLoggable(Level.FINEST)) {
                                initLogger.log(Level.FINEST, "Terminating settlerpool.");
                            }
                            try {
                                this.settlerpool.terminate();
                                if (this.settlerWakeupMgr != null) {
                                    if (initLogger.isLoggable(Level.FINEST)) {
                                        initLogger.log(Level.FINEST, "Terminating settlerWakeupMgr.");
                                    }
                                    this.settlerWakeupMgr.stop();
                                    this.settlerWakeupMgr.cancelAll();
                                }
                            }
                            catch (Throwable t) {
                                if (!initLogger.isLoggable(Levels.HANDLED)) break block29;
                                initLogger.log(Levels.HANDLED, "Trouble terminating settlerpool", t);
                            }
                        }
                    }
                    if (this.taskpool != null) {
                        if (initLogger.isLoggable(Level.FINEST)) {
                            initLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        try {
                            this.taskpool.terminate();
                            if (this.taskWakeupMgr != null) {
                                if (initLogger.isLoggable(Level.FINEST)) {
                                    initLogger.log(Level.FINEST, "Terminating taskWakeupMgr.");
                                }
                                this.taskWakeupMgr.stop();
                                this.taskWakeupMgr.cancelAll();
                            }
                        }
                        catch (Throwable t) {
                            if (!initLogger.isLoggable(Levels.HANDLED)) break block30;
                            initLogger.log(Levels.HANDLED, "Trouble terminating taskpool", t);
                        }
                    }
                }
                if (this.settleThread != null) {
                    if (initLogger.isLoggable(Level.FINEST)) {
                        initLogger.log(Level.FINEST, "Interrupting settleThread.");
                    }
                    try {
                        this.settleThread.interrupt();
                    }
                    catch (Throwable t) {
                        if (!initLogger.isLoggable(Levels.HANDLED)) break block31;
                        initLogger.log(Levels.HANDLED, "Trouble terminating settleThread", t);
                    }
                }
            }
            if (this.expMgr != null) {
                if (initLogger.isLoggable(Level.FINEST)) {
                    initLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                }
                this.expMgr.terminate();
            }
            if (initLogger.isLoggable(Level.FINEST)) {
                initLogger.log(Level.FINEST, "Destroying JoinStateManager.");
            }
            try {
                if (this.joinStateManager != null) {
                    this.joinStateManager.stop();
                }
            }
            catch (Exception t) {
                if (!initLogger.isLoggable(Levels.HANDLED)) break block32;
                initLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", t);
            }
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "cleanup");
        }
    }

    @Override
    public TrustVerifier getProxyVerifier() {
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        this.readyState.check();
        if (!(this.txnMgrProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException();
        }
        if (operationsLogger.isLoggable(Level.FINER)) {
            operationsLogger.exiting(TxnManagerImpl.class.getName(), "getProxyVerifier");
        }
        return new ProxyVerifier(this.serverStub, this.topUuid);
    }

    private static boolean ensureCurrent(LeasedResource resource) {
        return resource.getExpiration() > System.currentTimeMillis();
    }

    private Uuid createLeaseUuid(long txnId) {
        return UuidFactory.create(this.topUuid.getLeastSignificantBits(), txnId);
    }

    private void verifyLeaseUuid(Uuid uuid) throws UnknownLeaseException {
        if (uuid.getMostSignificantBits() != this.topUuid.getLeastSignificantBits()) {
            throw new UnknownLeaseException();
        }
    }

    private Long getLeaseTid(Uuid uuid) {
        return uuid.getLeastSignificantBits();
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            block49: {
                block48: {
                    block47: {
                        block46: {
                            block45: {
                                long endTime;
                                block44: {
                                    if (operationsLogger.isLoggable(Level.FINER)) {
                                        operationsLogger.entering(DestroyThread.class.getName(), "run");
                                    }
                                    Object failed = null;
                                    if (TxnManagerImpl.this.activationPrepared) {
                                        try {
                                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                                destroyLogger.log(Level.FINEST, "Unregistering object.");
                                            }
                                            if (TxnManagerImpl.this.activationID != null) {
                                                TxnManagerImpl.this.activationSystem.unregisterObject(TxnManagerImpl.this.activationID);
                                            }
                                        }
                                        catch (RemoteException e) {
                                            if (destroyLogger.isLoggable(Level.WARNING)) {
                                                destroyLogger.log(Level.WARNING, "Trouble unregistering object -- aborting.", e);
                                            }
                                            return;
                                        }
                                        catch (ActivationException e) {
                                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block44;
                                            destroyLogger.log(Levels.HANDLED, "Trouble unregistering object -- ignoring.", e);
                                        }
                                    }
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Attempting unforced unexport.");
                                }
                                if ((endTime = System.currentTimeMillis() + 120000L) < 0L) {
                                    endTime = Long.MAX_VALUE;
                                }
                                boolean unexported = false;
                                while (!unexported && System.currentTimeMillis() < endTime) {
                                    unexported = TxnManagerImpl.this.exporter.unexport(false);
                                    if (!unexported) {
                                        if (destroyLogger.isLoggable(Level.FINEST)) {
                                            destroyLogger.log(Level.FINEST, "Waiting for in-progress calls to complete");
                                        }
                                        try {
                                            DestroyThread.sleep(1000L);
                                            continue;
                                        }
                                        catch (InterruptedException ie) {
                                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break;
                                            destroyLogger.log(Levels.HANDLED, "problem unexporting nicely", ie);
                                            break;
                                        }
                                    }
                                    if (!destroyLogger.isLoggable(Level.FINEST)) continue;
                                    destroyLogger.log(Level.FINEST, "Unexport completed");
                                }
                                if (!unexported) {
                                    if (destroyLogger.isLoggable(Level.FINEST)) {
                                        destroyLogger.log(Level.FINEST, "Attempting forced unexport.");
                                    }
                                    unexported = TxnManagerImpl.this.exporter.unexport(true);
                                }
                                if (destroyLogger.isLoggable(Level.FINEST)) {
                                    destroyLogger.log(Level.FINEST, "Destroying JoinStateManager.");
                                }
                                try {
                                    TxnManagerImpl.this.joinStateManager.destroy();
                                }
                                catch (Exception t) {
                                    if (!destroyLogger.isLoggable(Levels.HANDLED)) break block45;
                                    destroyLogger.log(Levels.HANDLED, "Problem destroying JoinStateManager", t);
                                }
                            }
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Terminating lease expiration manager.");
                            }
                            TxnManagerImpl.this.expMgr.terminate();
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Interrupting settleThread.");
                            }
                            TxnManagerImpl.this.settleThread.interrupt();
                            try {
                                TxnManagerImpl.this.settleThread.join();
                            }
                            catch (InterruptedException ie) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block46;
                                destroyLogger.log(Levels.HANDLED, "Problem stopping settleThread", ie);
                            }
                        }
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating settlerpool.");
                        }
                        TxnManagerImpl.this.settlerpool.terminate();
                        TxnManagerImpl.this.settlerWakeupMgr.stop();
                        TxnManagerImpl.this.settlerWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Terminating taskpool.");
                        }
                        TxnManagerImpl.this.taskpool.terminate();
                        TxnManagerImpl.this.taskWakeupMgr.stop();
                        TxnManagerImpl.this.taskWakeupMgr.cancelAll();
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Destroying transaction logs.");
                        }
                        MultiLogManagerAdmin logadmin = (MultiLogManagerAdmin)TxnManagerImpl.this.logmgr.getAdmin();
                        logadmin.destroy();
                        if (TxnManagerImpl.this.persistent) {
                            if (destroyLogger.isLoggable(Level.FINEST)) {
                                destroyLogger.log(Level.FINEST, "Destroying persistence directory.");
                            }
                            try {
                                FileSystem.destroy(new File(TxnManagerImpl.this.persistenceDirectory), true);
                            }
                            catch (IOException e) {
                                if (!destroyLogger.isLoggable(Levels.HANDLED)) break block47;
                                destroyLogger.log(Levels.HANDLED, "Problem destroying persistence directory", e);
                            }
                        }
                    }
                    if (TxnManagerImpl.this.activationID != null) {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Calling Activatable.inactive.");
                        }
                        try {
                            Activatable.inactive((ActivationID)TxnManagerImpl.this.activationID);
                        }
                        catch (RemoteException e) {
                            if (destroyLogger.isLoggable(Levels.HANDLED)) {
                                destroyLogger.log(Levels.HANDLED, "Problem inactivating service", e);
                            }
                        }
                        catch (ActivationException e) {
                            if (!destroyLogger.isLoggable(Levels.HANDLED)) break block48;
                            destroyLogger.log(Levels.HANDLED, "Problem inactivating service", e);
                        }
                    }
                }
                if (TxnManagerImpl.this.lifeCycle != null) {
                    if (destroyLogger.isLoggable(Level.FINEST)) {
                        destroyLogger.log(Level.FINEST, "Unregistering with LifeCycle.");
                    }
                    TxnManagerImpl.this.lifeCycle.unregister(TxnManagerImpl.this);
                }
                if (TxnManagerImpl.this.loginContext != null) {
                    try {
                        if (destroyLogger.isLoggable(Level.FINEST)) {
                            destroyLogger.log(Level.FINEST, "Logging out");
                        }
                        TxnManagerImpl.this.loginContext.logout();
                    }
                    catch (Exception e) {
                        if (!destroyLogger.isLoggable(Levels.HANDLED)) break block49;
                        destroyLogger.log(Levels.HANDLED, "Exception while logging out", e);
                    }
                }
            }
            TxnManagerImpl.this.readyState.shutdown();
            if (operationsLogger.isLoggable(Level.FINER)) {
                operationsLogger.exiting(DestroyThread.class.getName(), "run");
            }
        }
    }
}

