/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEvent;

class EventID
implements Serializable {
    private static final long serialVersionUID = 1L;
    private transient Object source = null;
    private long id = 0L;

    public EventID(Object source, long id) {
        this.init(source, id);
    }

    public EventID(RemoteEvent evt) {
        if (evt == null) {
            throw new IllegalArgumentException("RemoteEvent argument must be non-null");
        }
        this.init(evt.getSource(), evt.getID());
    }

    private void init(Object source, long id) {
        if (source == null) {
            throw new IllegalArgumentException("Source argument must be non-null");
        }
        this.source = source;
        this.id = id;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        if (o.getClass() != this.getClass()) {
            return false;
        }
        EventID eid = (EventID)o;
        return this.source.equals(eid.source) && this.id == eid.id;
    }

    public int hashCode() {
        return (int)this.id;
    }

    public String toString() {
        return this.getClass().getName() + "[source=" + this.source + "]" + "[id=" + this.id + "]";
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeObject(new MarshalledObject<Object>(this.source));
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        block2: {
            stream.defaultReadObject();
            MarshalledObject mo = (MarshalledObject)stream.readObject();
            try {
                this.source = mo.get();
            }
            catch (Throwable e) {
                if (!(e instanceof Error) || e instanceof LinkageError || e instanceof OutOfMemoryError || e instanceof StackOverflowError) break block2;
                throw (Error)e;
            }
        }
    }
}

