/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.MailboxBackEnd;
import com.sun.jini.mercury.ProxyUtil;
import com.sun.jini.proxy.ConstrainableProxyUtil;
import com.sun.jini.proxy.ThrowThis;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.event.UnknownEventException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class ListenerProxy
implements RemoteEventListener,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final MailboxBackEnd server;
    final Uuid registrationID;

    static ListenerProxy create(Uuid id, MailboxBackEnd server) {
        if (server instanceof RemoteMethodControl) {
            return new ConstrainableListenerProxy(server, id, null);
        }
        return new ListenerProxy(server, id);
    }

    private ListenerProxy(MailboxBackEnd ref, Uuid regID) {
        if (ref == null || regID == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.server = ref;
        this.registrationID = regID;
    }

    @Override
    public void notify(RemoteEvent theEvent) throws UnknownEventException, RemoteException {
        try {
            this.server.notify(this.registrationID, theEvent);
        }
        catch (ThrowThis tt) {
            tt.throwRemoteException();
        }
    }

    @Override
    public final Uuid getReferentUuid() {
        return this.registrationID;
    }

    public int hashCode() {
        return this.registrationID.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare(this, o);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("ListenerProxy.readObject failure - server field is null");
        }
        if (this.registrationID == null) {
            throw new InvalidObjectException("ListenerProxy.readObject failure - registrationID field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize ListenerProxy instance");
    }

    static final class ConstrainableListenerProxy
    extends ListenerProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 2L;
        private static final Method[] methodMap1 = new Method[]{ProxyUtil.getMethod(RemoteEventListener.class, "notify", new Class[]{RemoteEvent.class}), ProxyUtil.getMethod(MailboxBackEnd.class, "notify", new Class[]{Uuid.class, RemoteEvent.class})};
        private MethodConstraints methodConstraints;

        private ConstrainableListenerProxy(MailboxBackEnd server, Uuid id, MethodConstraints methodConstraints) {
            super(ConstrainableListenerProxy.constrainServer(server, methodConstraints), id);
            this.methodConstraints = methodConstraints;
        }

        private static MailboxBackEnd constrainServer(MailboxBackEnd server, MethodConstraints methodConstraints) {
            return (MailboxBackEnd)((Object)((RemoteMethodControl)((Object)server)).setConstraints(ConstrainableProxyUtil.translateConstraints(methodConstraints, methodMap1)));
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableListenerProxy(this.server, this.registrationID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return this.methodConstraints;
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.server);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            ConstrainableProxyUtil.verifyConsistentConstraints(this.methodConstraints, this.server, methodMap1);
        }
    }
}

