/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.MailboxBackEnd;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.admin.Administrable;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.event.MailboxPullRegistration;
import net.jini.event.MailboxRegistration;
import net.jini.event.PullEventMailbox;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.security.proxytrust.ProxyTrustIterator;
import net.jini.security.proxytrust.SingletonProxyTrustIterator;

class MailboxProxy
implements PullEventMailbox,
Administrable,
Serializable,
ReferentUuid {
    private static final long serialVersionUID = 2L;
    final MailboxBackEnd mailbox;
    final Uuid proxyID;

    static MailboxProxy create(MailboxBackEnd mailbox, Uuid id) {
        if (mailbox instanceof RemoteMethodControl) {
            return new ConstrainableMailboxProxy(mailbox, id, null);
        }
        return new MailboxProxy(mailbox, id);
    }

    private MailboxProxy(MailboxBackEnd mailbox, Uuid proxyID) {
        if (mailbox == null || proxyID == null) {
            throw new IllegalArgumentException("Cannot accept null arguments");
        }
        this.mailbox = mailbox;
        this.proxyID = proxyID;
    }

    @Override
    public MailboxRegistration register(long duration) throws RemoteException, LeaseDeniedException {
        if (duration < 1L && duration != -1L) {
            throw new IllegalArgumentException("Duration values must be positive");
        }
        return this.mailbox.register(duration);
    }

    @Override
    public MailboxPullRegistration pullRegister(long duration) throws RemoteException, LeaseDeniedException {
        if (duration < 1L && duration != -1L) {
            throw new IllegalArgumentException("Duration values must be positive");
        }
        return this.mailbox.pullRegister(duration);
    }

    @Override
    public Object getAdmin() throws RemoteException {
        return this.mailbox.getAdmin();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.proxyID;
    }

    public int hashCode() {
        return this.proxyID.hashCode();
    }

    public boolean equals(Object o) {
        return ReferentUuids.compare(this, o);
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.mailbox == null) {
            throw new InvalidObjectException("MailboxProxy.readObject failure - mailbox field is null");
        }
        if (this.proxyID == null) {
            throw new InvalidObjectException("MailboxProxy.proxyID failure - proxyID field is null");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data found when attempting to deserialize MailboxProxy instance");
    }

    static final class ConstrainableMailboxProxy
    extends MailboxProxy
    implements RemoteMethodControl {
        private static final long serialVersionUID = 1L;

        private ConstrainableMailboxProxy(MailboxBackEnd mailbox, Uuid uuid, MethodConstraints methodConstraints) {
            super(ConstrainableMailboxProxy.constrainServer(mailbox, methodConstraints), uuid);
        }

        private static MailboxBackEnd constrainServer(MailboxBackEnd mailbox, MethodConstraints methodConstraints) {
            return (MailboxBackEnd)((Object)((RemoteMethodControl)((Object)mailbox)).setConstraints(methodConstraints));
        }

        @Override
        public RemoteMethodControl setConstraints(MethodConstraints constraints) {
            return new ConstrainableMailboxProxy(this.mailbox, this.proxyID, constraints);
        }

        @Override
        public MethodConstraints getConstraints() {
            return ((RemoteMethodControl)((Object)this.mailbox)).getConstraints();
        }

        private ProxyTrustIterator getProxyTrustIterator() {
            return new SingletonProxyTrustIterator(this.mailbox);
        }

        @Override
        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            if (!(this.mailbox instanceof RemoteMethodControl)) {
                throw new InvalidObjectException("MailboxAdminProxy.readObject failure - mailbox does not implement constrainable functionality ");
            }
        }
    }
}

