/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.logging.Levels;
import com.sun.jini.mercury.ControlLog;
import com.sun.jini.mercury.EventLog;
import com.sun.jini.mercury.EventReader;
import com.sun.jini.mercury.EventWriter;
import com.sun.jini.mercury.InternalMailboxException;
import com.sun.jini.mercury.LogInputStream;
import com.sun.jini.mercury.LogOutputStream;
import com.sun.jini.mercury.LogStream;
import com.sun.jini.mercury.MailboxImpl;
import com.sun.jini.mercury.RemoteEventData;
import com.sun.jini.mercury.RemoteEventDataCursor;
import com.sun.jini.mercury.StreamPool;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.id.Uuid;

class PersistentEventLog
implements EventLog {
    private static final Logger persistenceLogger = MailboxImpl.persistenceLogger;
    private static final int CTLBLOCK_LEN = 32;
    private static final String CTLFILE_SUFFIX = "ctl";
    private static final String LOGFILE_SUFFIX = "log";
    private static final long DEFAULT_EVENTS_PER_LOGFILE = 10L;
    private static final long eventsPerLogFile = 10L;
    static final int DEFAULT_STREAM_POOL_SIZE = 10;
    private static final int maxPoolSize = 10;
    private static final StreamPool streamPool = new StreamPool(10);
    private Uuid uuid = null;
    private long wcount = 0L;
    private long rcount = 0L;
    private long wpos = 0L;
    private long rpos = 0L;
    private long nextReadPos = 0L;
    private EventReader eventReader;
    private EventWriter eventWriter;
    private File logDir;
    private File controlFile;
    private byte[] ctlbuf = new byte[32];
    private boolean initialized = false;
    private boolean closed = false;
    private static final boolean debugState = false;

    PersistentEventLog(Uuid uuid, File logDir) {
        if (logDir == null || uuid == null) {
            throw new IllegalArgumentException("Arguments cannot be null");
        }
        this.uuid = uuid;
        this.logDir = logDir;
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "PersistentEventLog for: {0}", uuid);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void init() throws IOException {
        if (this.initialized) {
            throw new InternalMailboxException("Trying to re-initialize control data for: " + this.uuid);
        }
        if (!this.logDir.exists()) {
            this.logDir.mkdirs();
        }
        if (!this.logDir.isDirectory()) {
            throw new FileNotFoundException(this.logDir.toString() + " is not a directory");
        }
        this.controlFile = this.getControlFile();
        if (this.controlFile.isFile()) {
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "EventLog::init() recovering data for ", this.uuid);
            }
            this.readControlFile();
        } else if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "default initialization for ", this.uuid);
        }
        this.eventReader = new EventReader();
        this.eventWriter = new EventWriter();
        this.printControlData(persistenceLogger, "After EventLog::init");
        this.initialized = true;
    }

    @Override
    public void add(RemoteEvent event) throws IOException {
        this.stateCheck();
        long logNum = PersistentEventLog.getLogNum(this.wcount);
        File log = this.getLogFile(logNum);
        LogOutputStream out = null;
        try {
            out = streamPool.getLogOutputStream(log, this.wpos);
            this.eventWriter.write(event, out);
            this.wpos = out.getOffset();
            ++this.wcount;
        }
        catch (IOException ioe) {
            if (ioe instanceof InterruptedIOException) {
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "EventLog::add() interrupted ");
                }
            } else {
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "EventLog::add() received IOException ... skipping to next write log");
                }
                this.nextWriteLog();
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Exception: ", ioe);
            }
            throw (IOException)ioe.fillInStackTrace();
        }
        finally {
            if (out != null) {
                if (PersistentEventLog.getLogNum(this.wcount) == logNum) {
                    streamPool.releaseLogStream(out);
                } else {
                    streamPool.removeLogStream(out);
                    this.wpos = 0L;
                }
            }
            this.writeControlFile();
        }
        this.printControlData(persistenceLogger, "EventLog::add");
    }

    @Override
    public RemoteEvent next() throws IOException, ClassNotFoundException {
        boolean IOExceptionCaught = false;
        this.stateCheck();
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long logNum = PersistentEventLog.getLogNum(this.rcount);
        File log = this.getLogFile(logNum);
        LogInputStream in = null;
        RemoteEvent evt = null;
        try {
            in = streamPool.getLogInputStream(log, this.rpos);
            evt = this.eventReader.read(in);
            this.nextReadPos = in.getOffset();
        }
        catch (IOException ie) {
            if (ie instanceof InterruptedIOException) {
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "EventLog::next() interrupted ");
                }
            } else {
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "EventLog::next() received IOException ... skipping to next read log");
                }
                this.nextReadLog();
                IOExceptionCaught = true;
            }
            if (persistenceLogger.isLoggable(Level.FINEST)) {
                persistenceLogger.log(Level.FINEST, "Exception: ", ie);
            }
            throw (IOException)ie.fillInStackTrace();
        }
        catch (ClassNotFoundException cnfe) {
            this.nextReadPos = in.getOffset();
            throw (ClassNotFoundException)cnfe.fillInStackTrace();
        }
        finally {
            if (IOExceptionCaught) {
                this.eventReader = new EventReader();
                if (in != null) {
                    streamPool.removeLogStream(in);
                }
                if (!log.delete() && persistenceLogger.isLoggable(Levels.HANDLED)) {
                    persistenceLogger.log(Levels.HANDLED, "Had trouble deleting {0}", log);
                }
            } else if (in != null) {
                streamPool.releaseLogStream(in);
            }
            this.writeControlFile();
        }
        this.printControlData(persistenceLogger, "After Event::next");
        return evt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RemoteEventData[] readAhead(int maxEvents) throws IOException, ClassNotFoundException {
        boolean IOExceptionCaught = false;
        this.stateCheck();
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        long readCount = this.rcount;
        long readPosition = this.rpos;
        long logNum = PersistentEventLog.getLogNum(readCount);
        File log = this.getLogFile(logNum);
        RemoteEvent evt = null;
        ArrayList<RemoteEventData> rData = new ArrayList<RemoteEventData>();
        boolean i = false;
        LogInputStream in = null;
        boolean done = false;
        this.printControlData(persistenceLogger, "Before read::readAhead");
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "EventLog::readAhead() maxEvents = {0}", new Object[]{maxEvents});
        }
        while (readCount < this.wcount && rData.size() < maxEvents && !done) {
            if (logNum != PersistentEventLog.getLogNum(readCount)) {
                logNum = PersistentEventLog.getLogNum(readCount);
                log = this.getLogFile(logNum);
                readPosition = 0L;
            }
            try {
                in = streamPool.getLogInputStream(log, readPosition);
                evt = this.eventReader.read(in);
                readPosition = in.getOffset();
                rData.add(new RemoteEventData(evt, new RemoteEventDataCursor(++readCount, readPosition)));
            }
            catch (IOException ie) {
                if (ie instanceof InterruptedIOException) {
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "EventLog::readAhead() interrupted ");
                    }
                    done = true;
                } else {
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "EventLog::readAhead() received IOException ... skipping to next read log");
                    }
                    readCount = this.nextReadAheadLog(readCount);
                    readPosition = 0L;
                    IOExceptionCaught = true;
                    if (persistenceLogger.isLoggable(Level.FINEST)) {
                        persistenceLogger.log(Level.FINEST, "EventLog::readAhead() new readCount is {0}", readCount);
                    }
                }
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                persistenceLogger.log(Levels.HANDLED, "Exception: ", ie);
            }
            catch (ClassNotFoundException cnfe) {
                readPosition = in.getOffset();
                rData.add(new RemoteEventData(null, new RemoteEventDataCursor(++readCount, readPosition)));
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                persistenceLogger.log(Levels.HANDLED, "Exception: ", cnfe);
            }
            finally {
                if (IOExceptionCaught) {
                    this.eventReader = new EventReader();
                    if (in != null) {
                        streamPool.removeLogStream(in);
                        in = null;
                    }
                    continue;
                }
                if (in == null) continue;
                streamPool.releaseLogStream(in);
            }
        }
        this.printControlData(persistenceLogger, "After Event::readAhead");
        return rData.toArray(new RemoteEventData[0]);
    }

    @Override
    public boolean isEmpty() throws IOException {
        this.stateCheck();
        return this.rcount >= this.wcount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove() throws IOException {
        this.stateCheck();
        long logNum = PersistentEventLog.getLogNum(this.rcount);
        if (this.rcount < this.wcount) {
            ++this.rcount;
        } else {
            throw new NoSuchElementException();
        }
        this.rpos = this.nextReadPos;
        if (PersistentEventLog.getLogNum(this.rcount) != logNum) {
            File log = this.getLogFile(logNum);
            LogInputStream in = null;
            try {
                in = streamPool.getLogInputStream(log, this.rpos);
                streamPool.removeLogStream(in);
            }
            finally {
                if (!log.delete() && persistenceLogger.isLoggable(Levels.HANDLED)) {
                    persistenceLogger.log(Levels.HANDLED, "Had trouble deleting {0}", log);
                }
                this.nextReadPos = 0L;
                this.rpos = 0L;
            }
        }
        this.writeControlFile();
        this.assertInvariants();
        this.printControlData(persistenceLogger, "After Event::remove");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveAhead(Object cookie) throws IOException {
        this.stateCheck();
        this.printControlData(persistenceLogger, "Before Event::moveAhead");
        long readCount = 0L;
        long readPosition = 0L;
        RemoteEventDataCursor cursor = (RemoteEventDataCursor)cookie;
        if (cursor != null) {
            readCount = cursor.getReadCount();
            readPosition = cursor.getReadPosition();
        } else {
            readCount = this.rcount;
            readPosition = this.rpos;
        }
        if (readCount > this.wcount) {
            throw new NoSuchElementException();
        }
        long currentLogNum = PersistentEventLog.getLogNum(this.rcount);
        long nextLogNum = PersistentEventLog.getLogNum(readCount);
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "EventLog::moveAhead() readCount = {0}, readPosition = {1}, currentLogNum = {2}, nextLogNum = {3}", new Object[]{readCount, readPosition, currentLogNum, nextLogNum});
        }
        File logFile = null;
        LogInputStream in = null;
        while (currentLogNum < nextLogNum) {
            try {
                logFile = this.getLogFile(currentLogNum);
                in = streamPool.getLogInputStream(logFile, this.rpos);
                streamPool.removeLogStream(in);
            }
            catch (IOException ioe) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                persistenceLogger.log(Levels.HANDLED, "Had trouble accessing old log file", ioe);
            }
            finally {
                if (logFile != null && !logFile.delete() && persistenceLogger.isLoggable(Levels.HANDLED)) {
                    persistenceLogger.log(Levels.HANDLED, "Had trouble deleting {0}", logFile);
                }
                if (persistenceLogger.isLoggable(Level.FINEST)) {
                    persistenceLogger.log(Level.FINEST, "Deleted {0}", logFile);
                }
                ++currentLogNum;
            }
        }
        this.rcount = readCount;
        this.rpos = this.rcount % 10L == 0L ? 0L : readPosition;
        this.writeControlFile();
        this.assertInvariants();
        this.printControlData(persistenceLogger, "After Event::moveAhead");
    }

    @Override
    public void close() throws IOException {
        this.stateCheck();
        long logNum = PersistentEventLog.getLogNum(this.rcount);
        File log = this.getLogFile(logNum);
        Closeable strm = null;
        try {
            strm = streamPool.getLogInputStream(log, this.rpos);
            streamPool.removeLogStream((LogStream)((Object)strm));
        }
        catch (FileNotFoundException fnfe) {
        }
        catch (IOException ioe) {
            // empty catch block
        }
        logNum = PersistentEventLog.getLogNum(this.wcount);
        log = this.getLogFile(logNum);
        try {
            strm = streamPool.getLogOutputStream(log, this.wpos);
            streamPool.removeLogStream((LogStream)((Object)strm));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        try {
            strm = streamPool.getControlLog(this.controlFile);
            streamPool.removeLogStream((LogStream)((Object)strm));
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.closed = true;
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "EventLog::close for {0}", this.uuid);
        }
    }

    @Override
    public void delete() throws IOException {
        if (!this.closed) {
            throw new IOException("Cannot delete log until it is closed");
        }
        PersistentEventLog.removeDir(this.logDir);
    }

    private static void removeDir(File logDir) {
        if (logDir == null || !logDir.isDirectory()) {
            return;
        }
        String[] contents = logDir.list();
        if (contents == null) {
            return;
        }
        File entry = null;
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Deleting contents of: {0}", logDir);
        }
        for (int i = 0; i < contents.length; ++i) {
            entry = new File(logDir, contents[i]);
            if (entry.isDirectory()) {
                PersistentEventLog.removeDir(entry);
                continue;
            }
            if (!entry.delete()) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) continue;
                persistenceLogger.log(Levels.HANDLED, "Had trouble deleting file: {0}", entry);
                continue;
            }
            if (!persistenceLogger.isLoggable(Level.FINEST)) continue;
            persistenceLogger.log(Level.FINEST, "Deleted file: {0}", entry);
        }
        if (!logDir.delete()) {
            if (persistenceLogger.isLoggable(Levels.HANDLED)) {
                persistenceLogger.log(Levels.HANDLED, "Had trouble deleting directory: {0}", logDir);
            }
        } else if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Deleted directory: {0}", logDir);
        }
    }

    private void nextReadLog() {
        long remainder = this.rcount % 10L;
        this.rcount += 10L - remainder;
        this.rpos = 0L;
        if (!this.verifyInvariants()) {
            this.nextWriteLog();
        }
        this.printControlData(persistenceLogger, "EventLog::nextReadLog");
    }

    private long nextReadAheadLog(long readCount) {
        long remainder = readCount % 10L;
        this.printControlData(persistenceLogger, "EventLog::nextReadAheadLog");
        return readCount += 10L - remainder;
    }

    private void nextWriteLog() {
        long remainder = this.wcount % 10L;
        this.wcount += 10L - remainder;
        this.wpos = 0L;
        this.printControlData(persistenceLogger, "EventLog::nextWriteLog");
    }

    private void printControlData(Logger logger, String msg) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0}", msg);
            logger.log(Level.FINEST, "ID: {0}", this.uuid);
            logger.log(Level.FINEST, "ReadCount: {0}", this.rcount);
            logger.log(Level.FINEST, "ReadPos: {0}", this.rpos);
            logger.log(Level.FINEST, "NextReadPos: {0}", this.nextReadPos);
            logger.log(Level.FINEST, "WriteCount: {0}", this.wcount);
            logger.log(Level.FINEST, "WritePos: {0}", this.wpos);
        }
    }

    private void writeControlFile() throws IOException {
        PersistentEventLog.packLong(this.wcount, this.ctlbuf, 0);
        PersistentEventLog.packLong(this.rcount, this.ctlbuf, 8);
        PersistentEventLog.packLong(this.wpos, this.ctlbuf, 16);
        PersistentEventLog.packLong(this.rpos, this.ctlbuf, 24);
        ControlLog ctl = streamPool.getControlLog(this.controlFile);
        ctl.seek(0L);
        ctl.write(this.ctlbuf);
        ctl.getFD().sync();
        streamPool.releaseLogStream(ctl);
    }

    private void readControlFile() throws IOException {
        ControlLog ctl = streamPool.getControlLog(this.controlFile);
        ctl.seek(0L);
        ctl.readFully(this.ctlbuf);
        streamPool.releaseLogStream(ctl);
        this.wcount = PersistentEventLog.unpackLong(this.ctlbuf, 0);
        this.rcount = PersistentEventLog.unpackLong(this.ctlbuf, 8);
        this.wpos = PersistentEventLog.unpackLong(this.ctlbuf, 16);
        this.rpos = PersistentEventLog.unpackLong(this.ctlbuf, 24);
    }

    private static void packLong(long val, byte[] b, int off) {
        b[off++] = (byte)(val >>> 56);
        b[off++] = (byte)(val >>> 48);
        b[off++] = (byte)(val >>> 40);
        b[off++] = (byte)(val >>> 32);
        b[off++] = (byte)(val >>> 24);
        b[off++] = (byte)(val >>> 16);
        b[off++] = (byte)(val >>> 8);
        b[off++] = (byte)(val >>> 0);
    }

    private static long unpackLong(byte[] b, int off) {
        return (((long)b[off + 0] & 0xFFL) << 56) + (((long)b[off + 1] & 0xFFL) << 48) + (((long)b[off + 2] & 0xFFL) << 40) + (((long)b[off + 3] & 0xFFL) << 32) + (((long)b[off + 4] & 0xFFL) << 24) + (((long)b[off + 5] & 0xFFL) << 16) + (((long)b[off + 6] & 0xFFL) << 8) + (((long)b[off + 7] & 0xFFL) << 0);
    }

    private File getLogFile(long lognum) {
        return new File(this.logDir, lognum + "." + LOGFILE_SUFFIX).getAbsoluteFile();
    }

    private File getControlFile() {
        return new File(this.logDir, "log.ctl").getAbsoluteFile();
    }

    private static long getLogNum(long count) {
        return count / 10L;
    }

    private void stateCheck() throws IOException {
        if (!this.initialized) {
            throw new IOException("Trying to use an uninitialized control data object for: " + this.uuid);
        }
        if (this.closed) {
            throw new IOException("Attempt to access closed log file for : " + this.uuid);
        }
    }

    private boolean verifyInvariants() {
        return this.wcount >= this.rcount && (PersistentEventLog.getLogNum(this.wcount) != PersistentEventLog.getLogNum(this.rcount) || this.wpos >= this.rpos);
    }

    private void assertInvariants() {
        if (!this.verifyInvariants()) {
            this.printControlData(persistenceLogger, "Dumping invalid state for " + this.uuid);
            throw new InternalMailboxException("Invalid state for " + this.uuid);
        }
    }
}

