/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.proxy.MarshalledWrapper;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.core.event.RemoteEvent;
import net.jini.io.MarshalledInstance;

class RemoteEventData
implements Serializable {
    private static final long serialVersionUID = 1L;
    private MarshalledInstance mi;
    private final Object cookie;
    private transient boolean integrity;

    RemoteEventData(RemoteEvent re, Object cookie) {
        try {
            this.mi = re == null ? null : new MarshalledInstance(re);
        }
        catch (IOException ioe) {
            this.mi = null;
        }
        this.cookie = cookie;
    }

    public RemoteEvent getRemoteEvent() throws ClassNotFoundException {
        if (this.mi == null) {
            throw new ClassNotFoundException("Failed to create server-side remote event");
        }
        RemoteEvent re = null;
        try {
            re = (RemoteEvent)this.mi.get(this.integrity);
        }
        catch (IOException ioe) {
            throw new ClassNotFoundException("Failed to create client-side remote event", ioe);
        }
        return re;
    }

    public Object getCookie() {
        return this.cookie;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.cookie == null) {
            throw new InvalidObjectException("null cookie");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(in);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("RemoteEventData should always have data");
    }
}

