/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.mercury.EventLogIterator;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalledObject;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;

class ServiceRegistration
implements LeasedResource,
Comparable,
Serializable {
    private static final long serialVersionUID = 2L;
    private final Uuid cookie;
    private long expiration = 0L;
    private transient RemoteEventListener preparedEventTarget = null;
    private MarshalledObject marshalledEventTarget = null;
    private transient EventLogIterator eventIterator = null;
    private Map unknownEvents = new HashMap();
    private Uuid remoteEventIteratorID;
    private final String iteratorNotifier = new String();

    public ServiceRegistration(Uuid cookie, EventLogIterator eventIterator) {
        this.cookie = cookie;
        this.eventIterator = eventIterator;
    }

    @Override
    public void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
    }

    @Override
    public long getExpiration() {
        return this.expiration;
    }

    @Override
    public Uuid getCookie() {
        return this.cookie;
    }

    public Map getUnknownEvents() {
        return this.unknownEvents;
    }

    public RemoteEventListener getEventTarget() {
        return this.preparedEventTarget;
    }

    public void setEventTarget(RemoteEventListener preparedTarget) throws IOException {
        if (preparedTarget == null) {
            this.preparedEventTarget = null;
            this.marshalledEventTarget = null;
        } else {
            this.preparedEventTarget = preparedTarget;
            this.marshalledEventTarget = new MarshalledObject<RemoteEventListener>(preparedTarget);
        }
    }

    public Uuid getRemoteEventIteratorID() {
        return this.remoteEventIteratorID;
    }

    public Object getIteratorNotifier() {
        return this.iteratorNotifier;
    }

    public void setRemoteEventIteratorID(Uuid id) {
        this.remoteEventIteratorID = id;
    }

    public boolean hasEventTarget() {
        return this.marshalledEventTarget != null;
    }

    public void restoreTransientState(ProxyPreparer targetPreparer) throws IOException, ClassNotFoundException {
        if (targetPreparer == null) {
            throw new NullPointerException("targetPreparer cannot be null");
        }
        if (this.marshalledEventTarget != null) {
            RemoteEventListener unprepared = (RemoteEventListener)this.marshalledEventTarget.get();
            this.preparedEventTarget = (RemoteEventListener)targetPreparer.prepareProxy(unprepared);
        }
    }

    public EventLogIterator iterator() {
        return this.eventIterator;
    }

    public void setIterator(EventLogIterator iter2) {
        this.eventIterator = iter2;
    }

    public int compareTo(Object obj) {
        ServiceRegistration reg = (ServiceRegistration)obj;
        if (this == reg) {
            return 0;
        }
        if (this.expiration < reg.expiration || this.expiration == reg.expiration && this.cookie.getMostSignificantBits() < reg.cookie.getMostSignificantBits() && this.cookie.getLeastSignificantBits() < reg.cookie.getLeastSignificantBits()) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return this.getClass().getName() + ":" + this.cookie.toString();
    }

    void dumpInfo(Logger logger) {
        logger.log(Level.FINEST, "{0}", this.toString());
        logger.log(Level.FINEST, "Expires at: {0}", new Date(this.expiration));
        logger.log(Level.FINEST, "Prepared target is: {0}", this.preparedEventTarget);
        logger.log(Level.FINEST, "Marshalled target is: {0}", this.marshalledEventTarget);
        logger.log(Level.FINEST, "Unknowns: {0}", this.unknownEvents.size());
        if (this.eventIterator != null) {
            try {
                logger.log(Level.FINEST, "hasNext: {0}", this.eventIterator.hasNext());
            }
            catch (IOException ioe) {
                logger.log(Level.FINEST, "hasNext exception.", ioe);
            }
        }
    }
}

