/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.logging.Levels;
import com.sun.jini.mercury.ControlLog;
import com.sun.jini.mercury.InternalMailboxException;
import com.sun.jini.mercury.LogInputStream;
import com.sun.jini.mercury.LogOutputStream;
import com.sun.jini.mercury.LogStream;
import com.sun.jini.mercury.MailboxImpl;
import com.sun.jini.mercury.StreamKey;
import com.sun.jini.mercury.StreamType;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;

class StreamPool {
    private static final Logger persistenceLogger = MailboxImpl.persistenceLogger;
    private final int maxPoolSize;
    private final HashMap pool;
    private final LinkedList freeList;

    StreamPool(int size) {
        if (size < 1) {
            throw new IllegalArgumentException("Pool size must be greater than 0.");
        }
        this.maxPoolSize = size;
        this.pool = new HashMap(this.maxPoolSize);
        this.freeList = new LinkedList();
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "Created StreamPool of size {0}", this.maxPoolSize);
        }
    }

    synchronized ControlLog getControlLog(File file) throws IOException {
        StreamKey key = new StreamKey(file, StreamType.CONTROL);
        ControlLog log = (ControlLog)this.pool.get(key);
        if (log != null) {
            if (!this.freeList.remove(key)) {
                throw new InternalMailboxException("Did not find re-used control log stream in freeList.");
            }
        } else {
            this.ensurePoolSpace();
            log = new ControlLog(file, key);
            this.pool.put(key, log);
            if (this.freeList.remove(key)) {
                throw new InternalMailboxException("Found newly created ControlLog in freeList");
            }
        }
        return log;
    }

    synchronized LogInputStream getLogInputStream(File file, long offset) throws IOException {
        StreamKey key = new StreamKey(file, StreamType.INPUT);
        LogInputStream in = (LogInputStream)this.pool.get(key);
        if (in != null && !this.freeList.remove(key)) {
            throw new InternalMailboxException("Did not find re-used input log stream in freelist.");
        }
        if (in == null || in.getOffset() > offset) {
            this.ensurePoolSpace();
            in = new LogInputStream(file, key);
            this.pool.put(key, in);
            if (this.freeList.remove(key)) {
                throw new InternalMailboxException("Found newly created ControlLog on freeList");
            }
        }
        if (offset > file.length()) {
            throw new EOFException("Attempting to read past end of file.");
        }
        while (in.getOffset() < offset) {
            in.skip(offset - in.getOffset());
        }
        return in;
    }

    synchronized LogOutputStream getLogOutputStream(File file, long offset) throws IOException {
        StreamKey key = new StreamKey(file, StreamType.OUTPUT);
        LogOutputStream out = (LogOutputStream)this.pool.get(key);
        if (out != null) {
            if (!this.freeList.remove(key)) {
                throw new InternalMailboxException("Did not find re-used output log stream in freelist");
            }
            if (out.getOffset() != offset) {
                this.removeLogStream(out);
                out = null;
            }
        }
        if (out == null) {
            this.ensurePoolSpace();
            if (offset == 0L) {
                out = new LogOutputStream(file, key, false);
            } else {
                long len = file.length();
                if (offset > len) {
                    throw new EOFException("Attempting to write past end of file");
                }
                if (offset < len) {
                    RandomAccessFile raf = new RandomAccessFile(file, "rw");
                    raf.setLength(offset);
                    raf.close();
                }
                out = new LogOutputStream(file, key, true);
            }
            this.pool.put(key, out);
            if (this.freeList.remove(key)) {
                throw new InternalMailboxException("Found newly created output log in freeList");
            }
        }
        return out;
    }

    private synchronized void ensurePoolSpace() throws IOException {
        if (this.pool.size() >= this.maxPoolSize) {
            while (this.freeList.size() < 1) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {}
            }
            StreamKey key = (StreamKey)this.freeList.removeFirst();
            LogStream els = (LogStream)this.pool.remove(key);
            els.close();
        }
    }

    synchronized void releaseLogStream(LogStream stream) {
        StreamKey key = (StreamKey)stream.getKey();
        if (this.pool.get(key) == null) {
            throw new InternalMailboxException("Not managing stream: " + stream + ":" + key + " -- release failed");
        }
        this.freeList.add(key);
        this.notifyAll();
    }

    synchronized void removeLogStream(LogStream stream) {
        block3: {
            StreamKey key = (StreamKey)stream.getKey();
            if (this.pool.remove(key) == null) {
                throw new InternalMailboxException("Not managing stream: " + stream + ":" + key + " -- remove failed");
            }
            this.freeList.remove(key);
            try {
                stream.close();
            }
            catch (IOException ioe) {
                if (!persistenceLogger.isLoggable(Levels.HANDLED)) break block3;
                persistenceLogger.log(Levels.HANDLED, "Exception closing Log", ioe);
            }
        }
    }

    synchronized int getPoolSize() {
        return this.pool.size();
    }

    synchronized int getFreeSize() {
        return this.freeList.size();
    }

    synchronized void dump() {
        System.out.println("Pool:\n" + this.pool);
        System.out.println("Free:\n" + this.freeList);
    }
}

