/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.mercury;

import com.sun.jini.mercury.EventLog;
import com.sun.jini.mercury.InternalMailboxException;
import com.sun.jini.mercury.MailboxImpl;
import com.sun.jini.mercury.RemoteEventData;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.event.RemoteEvent;
import net.jini.id.Uuid;

class TransientEventLog
implements EventLog {
    private static final Logger persistenceLogger = MailboxImpl.persistenceLogger;
    private Uuid uuid = null;
    private List entries = null;
    private boolean closed = false;
    private boolean initialized = false;
    private long eventCounter = 1L;

    TransientEventLog(Uuid uuid) {
        if (uuid == null) {
            throw new IllegalArgumentException("Uuid cannot be null");
        }
        this.uuid = uuid;
        this.entries = Collections.synchronizedList(new LinkedList());
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "TransientEventLog for: {0}", uuid);
        }
    }

    @Override
    public void init() throws IOException {
        if (this.initialized) {
            throw new InternalMailboxException("Trying to re-initialize event log for: " + this.uuid);
        }
        this.initialized = true;
    }

    private void stateCheck() throws IOException {
        if (!this.initialized) {
            throw new IOException("Trying to use an uninitialized event log for: " + this.uuid);
        }
        if (this.closed) {
            throw new IOException("Attempt to access closed log file for : " + this.uuid);
        }
    }

    @Override
    public void add(RemoteEvent event) throws IOException {
        this.stateCheck();
        long id = this.eventCounter++;
        RemoteEventHolder data = new RemoteEventHolder(id, event);
        this.entries.add(data);
        this.printControlData(persistenceLogger, "TransientEventLog::add");
    }

    @Override
    public RemoteEvent next() throws IOException {
        this.stateCheck();
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.printControlData(persistenceLogger, "TransientEventLog::next");
        RemoteEventHolder data = (RemoteEventHolder)this.entries.get(0);
        return data.getRemoteEvent();
    }

    @Override
    public RemoteEventData[] readAhead(int maxEvents) throws IOException {
        this.stateCheck();
        if (maxEvents < 0) {
            throw new IllegalArgumentException();
        }
        if (maxEvents == 0) {
            return new RemoteEventData[0];
        }
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        this.printControlData(persistenceLogger, "TransientEventLog::readAhead");
        int limit = maxEvents < this.entries.size() ? maxEvents : this.entries.size();
        RemoteEventHolder[] evts = this.entries.subList(0, limit).toArray(new RemoteEventHolder[0]);
        RemoteEventData[] set = new RemoteEventData[evts.length];
        for (int i = 0; i < set.length; ++i) {
            set[i] = new RemoteEventData(evts[i].getRemoteEvent(), evts[i].getID());
        }
        return set;
    }

    @Override
    public boolean isEmpty() throws IOException {
        this.stateCheck();
        return this.entries.isEmpty();
    }

    @Override
    public void remove() throws IOException {
        this.stateCheck();
        try {
            this.entries.remove(0);
        }
        catch (IndexOutOfBoundsException iob) {
            throw new NoSuchElementException();
        }
        this.printControlData(persistenceLogger, "TransientEventLog::remove");
    }

    @Override
    public void moveAhead(Object cookie) throws IOException {
        long lastID;
        this.stateCheck();
        if (cookie == null) {
            return;
        }
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "moveAhead past {0}", cookie);
        }
        if ((lastID = ((Long)cookie).longValue()) >= this.eventCounter) {
            throw new NoSuchElementException();
        }
        RemoteEventHolder rh = null;
        ListIterator iter2 = this.entries.listIterator();
        while (iter2.hasNext() && (rh = (RemoteEventHolder)iter2.next()).getID() <= lastID) {
            iter2.remove();
            if (!persistenceLogger.isLoggable(Level.FINEST)) continue;
            persistenceLogger.log(Level.FINEST, "Removing event with ID {0}", rh.getID());
        }
        this.printControlData(persistenceLogger, "TransientEventLog::moveAhead");
    }

    @Override
    public void close() throws IOException {
        this.stateCheck();
        this.closed = true;
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "TransientEventLog::close for {0}", this.uuid);
        }
    }

    @Override
    public void delete() throws IOException {
        if (!this.closed) {
            throw new IOException("Cannot delete log until it is closed");
        }
        this.entries.clear();
        if (persistenceLogger.isLoggable(Level.FINEST)) {
            persistenceLogger.log(Level.FINEST, "TransientEventLog::destroy for {0}", this.uuid);
        }
    }

    private void printControlData(Logger logger, String msg) {
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0}", msg);
            logger.log(Level.FINEST, "ID: {0}", this.uuid);
            logger.log(Level.FINEST, "NumEvents: {0}", this.entries.size());
        }
    }

    private static class RemoteEventHolder {
        private final long id;
        private final RemoteEvent remoteEvent;

        RemoteEventHolder(long stamp, RemoteEvent re) {
            this.id = stamp;
            this.remoteEvent = re;
        }

        long getID() {
            return this.id;
        }

        RemoteEvent getRemoteEvent() {
            return this.remoteEvent;
        }
    }
}

