/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.NormServer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

abstract class AbstractProxy
implements ReferentUuid,
Serializable {
    private static final long serialVersionUID = 1L;
    final NormServer server;
    final Uuid uuid;

    AbstractProxy(NormServer server, Uuid uuid) {
        if (server == null) {
            throw new NullPointerException("server cannot be null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid cannot be null");
        }
        this.server = server;
        this.uuid = uuid;
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("server and uuid must be non-null");
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.server == null || this.uuid == null) {
            throw new InvalidObjectException("server and uuid must be non-null");
        }
    }

    public boolean equals(Object object) {
        return ReferentUuids.compare(this, object);
    }

    public int hashCode() {
        return this.uuid.hashCode();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.uuid;
    }
}

