/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.NormServerBaseImpl;
import com.sun.jini.norm.Queue;
import com.sun.jini.thread.InterruptedStatusThread;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.lease.DesiredExpirationListener;
import net.jini.lease.LeaseRenewalEvent;

class LRMEventListener
extends InterruptedStatusThread
implements DesiredExpirationListener {
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    private final NormServerBaseImpl server;
    private final Queue queue = new Queue();
    static final LeaseDeniedException EXPIRED_SET_EXCEPTION = new LeaseDeniedException("Set Expired");

    LRMEventListener(NormServerBaseImpl server) {
        super("LRM Event Listener");
        this.setDaemon(true);
        this.server = server;
    }

    @Override
    public void notify(LeaseRenewalEvent e) {
        if (e.getException() == EXPIRED_SET_EXCEPTION) {
            return;
        }
        Lease l = e.getLease();
        if (l instanceof ClientLeaseWrapper) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)l;
            this.queue.enqueue(new Discriminator(clw, true));
        }
    }

    @Override
    public void expirationReached(LeaseRenewalEvent e) {
        Lease l = e.getLease();
        if (l instanceof ClientLeaseWrapper) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)l;
            this.queue.enqueue(new Discriminator(clw, false));
        }
    }

    @Override
    public void run() {
        while (!this.hasBeenInterrupted()) {
            try {
                Discriminator d = (Discriminator)this.queue.dequeue();
                if (d.isFailure) {
                    this.server.renewalFailure(d.clw);
                    continue;
                }
                this.server.desiredExpirationReached(d.clw);
            }
            catch (InterruptedException e) {
                return;
            }
            catch (RuntimeException e) {
                logger.log(Level.INFO, "Exception in LRMEventListener Notifier while processing an event from the LRM -- attempting to continue", e);
            }
            catch (Error e) {
                logger.log(Level.INFO, "Exception in LRMEventListener Notifier while processing an event from the LRM -- attempting to continue", e);
            }
        }
    }

    private static class Discriminator {
        private final boolean isFailure;
        private final ClientLeaseWrapper clw;

        private Discriminator(ClientLeaseWrapper clw, boolean isFailure) {
            this.isFailure = isFailure;
            this.clw = clw;
        }
    }
}

