/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm;

import com.sun.jini.config.Config;
import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordLease;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.norm.AdminProxy;
import com.sun.jini.norm.ClientLeaseWrapper;
import com.sun.jini.norm.CorruptedStoreException;
import com.sun.jini.norm.CreateLeaseSet;
import com.sun.jini.norm.GetLeasesResult;
import com.sun.jini.norm.InternalNormException;
import com.sun.jini.norm.LRMEventListener;
import com.sun.jini.norm.LeaseExpirationMgr;
import com.sun.jini.norm.LeaseSet;
import com.sun.jini.norm.LoggedOperation;
import com.sun.jini.norm.NormProxy;
import com.sun.jini.norm.NormServer;
import com.sun.jini.norm.PersistentStore;
import com.sun.jini.norm.ProxyVerifier;
import com.sun.jini.norm.SetProxy;
import com.sun.jini.norm.StoreException;
import com.sun.jini.norm.UIDGenerator;
import com.sun.jini.norm.event.EventType;
import com.sun.jini.norm.event.EventTypeGenerator;
import com.sun.jini.norm.event.SendMonitor;
import com.sun.jini.norm.lookup.JoinState;
import com.sun.jini.proxy.ThrowThis;
import com.sun.jini.reliableLog.LogException;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.start.LifeCycle;
import com.sun.jini.thread.InterruptedStatusThread;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEvent;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.export.Exporter;
import net.jini.export.ProxyAccessor;
import net.jini.id.ReferentUuid;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lease.LeaseRenewalEvent;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lease.LeaseRenewalService;
import net.jini.lease.LeaseRenewalSet;
import net.jini.loader.RiverClassLoader;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;

abstract class NormServerBaseImpl
implements NormServer,
LocalLandlord,
ServerProxyTrust,
ProxyAccessor {
    private static final int CURRENT_LOG_VERSION = 2;
    static final String NORM = "com.sun.jini.norm";
    static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    final boolean persistent;
    LoginContext loginContext;
    String persistenceDirectory;
    private ProxyPreparer leasePreparer;
    private ProxyPreparer recoveredLeasePreparer;
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredListenerPreparer;
    private ProxyPreparer locatorPreparer;
    private ProxyPreparer recoveredLocatorPreparer;
    Exporter exporter;
    private LifeCycle lifeCycle;
    private Uuid serverUuid;
    private JoinState joinState;
    private Map setTable = Collections.synchronizedMap(new HashMap());
    private LeaseRenewalManager lrm;
    private LeaseExpirationMgr expMgr;
    private LeaseFactory leaseFactory;
    private LeasePeriodPolicy setLeasePolicy;
    private boolean isolateSets;
    private PersistentStore store;
    private UIDGenerator idGen = new UIDGenerator();
    private List renewedList = new LinkedList();
    private RenewLogThread renewLogger;
    private EventTypeGenerator generator;
    private LRMEventListener lrmEventListener;
    private int logToSnapshotThresh;
    private float snapshotWt;
    NormServer serverProxy = null;
    LeaseRenewalService normProxy = null;
    private AdminProxy adminProxy;
    private SnapshotThread snapshotter;
    private final ReadyState ready = new ReadyState();
    private final CountLeases countLeases = new CountLeases();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renewFor(Uuid id, Lease leaseToRenew, long membershipDuration, long renewDuration) throws RemoteException, ThrowThis {
        Uuid cookie;
        LeaseSet setForLease;
        this.ready.check();
        LeaseSet set = this.getSet(id);
        if (leaseToRenew == null) {
            throw new NullPointerException("LeaseRenewalSet.renewFor:Must pass a non-null lease");
        }
        if (membershipDuration != Long.MAX_VALUE && renewDuration == -1L) {
            throw new IllegalArgumentException("LeaseRenewalSet.renewFor:renewDuration can only be Lease.ANY if membershipDuration is Lease.FOREVER");
        }
        if (renewDuration != -1L && renewDuration != Long.MAX_VALUE && renewDuration <= 0L) {
            throw new IllegalArgumentException("LeaseRenewalSet.renewFor:renewDuration can only be Lease.ANY, Lease.FOREVER, or positive");
        }
        if ((leaseToRenew = (Lease)this.leasePreparer.prepareProxy(leaseToRenew)) instanceof ReferentUuid && (setForLease = (LeaseSet)this.setTable.get(cookie = ((ReferentUuid)((Object)leaseToRenew)).getReferentUuid())) != null) {
            LeaseSet leaseSet = setForLease;
            synchronized (leaseSet) {
                if (NormServerBaseImpl.isCurrent(setForLease)) {
                    throw new IllegalArgumentException("Cannot add leases granted by a LeaseRenewalService to a set created by that service");
                }
            }
        }
        if (logger.isLoggable(Level.FINE)) {
            Class<?> lc = leaseToRenew.getClass();
            logger.log(Level.FINE, "Adding lease of class {0} with annotation {1}", new Object[]{leaseToRenew.getClass(), RiverClassLoader.getClassAnnotation(lc)});
        }
        this.add(set, leaseToRenew, membershipDuration, renewDuration);
    }

    void updateLeaseCount(int change) {
        this.countLeases.updateCount(change);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(LeaseSet set, Lease leaseToRenew, long membershipDuration, long renewDuration) throws ThrowThis {
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                NormServerBaseImpl.ensureCurrent(set);
                long now = System.currentTimeMillis();
                ClientLeaseWrapper clw = set.getClientLeaseWrapper(leaseToRenew);
                if (clw == null) {
                    try {
                        clw = new ClientLeaseWrapper(leaseToRenew, this.idGen.newID(), this.renewedList, set, membershipDuration, renewDuration, now);
                    }
                    catch (IOException e) {
                        throw new IllegalArgumentException("NormServerBaseImpl.renewFor:Handed lease that can't be marshalled");
                    }
                } else {
                    clw.update(membershipDuration, renewDuration, now);
                }
                set.update(clw);
                this.lrm.renewUntil(clw, clw.getMembershipExpiration(), clw.getRenewDuration(), this.lrmEventListener);
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Lease remove(Uuid id, Lease leaseToRemove) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet set = this.getSet(id);
        if (leaseToRemove == null) {
            throw new NullPointerException("LeaseRenewalSet.remove:Must pass a non-null lease");
        }
        leaseToRemove = (Lease)this.leasePreparer.prepareProxy(leaseToRemove);
        logger.log(Level.FINE, "Removing lease {0}", leaseToRemove);
        Lease rslt = null;
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                ClientLeaseWrapper clw;
                block13: {
                    NormServerBaseImpl.ensureCurrent(set);
                    clw = set.getClientLeaseWrapper(leaseToRemove);
                    if (clw != null) break block13;
                    Lease lease = null;
                    return lease;
                }
                try {
                    this.lrm.remove(clw);
                }
                catch (UnknownLeaseException e) {
                    // empty catch block
                }
                boolean present = set.remove(clw);
                if (present) {
                    rslt = clw.getClientLease();
                }
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
        if (rslt == null) {
            return null;
        }
        rslt.setSerialFormat(1);
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GetLeasesResult getLeases(Uuid id) throws ThrowThis {
        LeaseSet set;
        this.ready.check();
        LeaseSet leaseSet = set = this.getSet(id);
        synchronized (leaseSet) {
            NormServerBaseImpl.ensureCurrent(set);
            return new GetLeasesResult(set.getLeases());
        }
    }

    @Override
    public EventRegistration setExpirationWarningListener(Uuid id, RemoteEventListener listener, long minWarning, MarshalledObject handback) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet set = this.getSet(id);
        if (listener == null) {
            minWarning = -1L;
            handback = null;
        } else {
            if (minWarning < 0L) {
                throw new IllegalArgumentException("LeaseRenewalSet.setExpirationWarningListener:minWarning must be positive");
            }
            listener = (RemoteEventListener)this.listenerPreparer.prepareProxy(listener);
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                NormServerBaseImpl.ensureCurrent(set);
                try {
                    boolean haveBefore = set.haveWarningRegistration();
                    EventRegistration rslt = set.setExpirationWarningListener(listener, minWarning, handback);
                    boolean haveAfter = set.haveWarningRegistration();
                    if (haveAfter || haveBefore != haveAfter) {
                        this.expMgr.reschedule(set);
                    }
                    EventRegistration eventRegistration = rslt;
                    return eventRegistration;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Passed a listener that could not be serialized");
                }
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expireIfTime(LeaseSet set) {
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                block8: {
                    if (!NormServerBaseImpl.isCurrent(set)) break block8;
                    return;
                }
                this.removeSet(set);
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendWarningEvent(LeaseSet set) {
        LeaseSet leaseSet = set;
        synchronized (leaseSet) {
            if (!NormServerBaseImpl.isCurrent(set)) {
                return;
            }
            set.sendWarningEvent();
        }
    }

    @Override
    public EventRegistration setRenewalFailureListener(Uuid id, RemoteEventListener listener, MarshalledObject handback) throws RemoteException, ThrowThis {
        this.ready.check();
        LeaseSet set = this.getSet(id);
        if (listener == null) {
            handback = null;
        } else {
            listener = (RemoteEventListener)this.listenerPreparer.prepareProxy(listener);
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                NormServerBaseImpl.ensureCurrent(set);
                try {
                    EventRegistration eventRegistration = set.setRenewalFailureListener(listener, handback);
                    return eventRegistration;
                }
                catch (IOException e) {
                    throw new IllegalArgumentException("Passed a listener that could not be serialized");
                }
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void renewalFailure(ClientLeaseWrapper clw) {
        LeaseSet set = clw.getLeaseSet();
        if (set == null) {
            return;
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                block11: {
                    logger.log(Level.INFO, "Lease renewal failed for {0}", clw);
                    if (NormServerBaseImpl.isCurrent(set)) break block11;
                    return;
                }
                set.renewalFailure(clw);
                try {
                    this.lrm.remove(clw);
                }
                catch (UnknownLeaseException e) {
                    // empty catch block
                }
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void desiredExpirationReached(ClientLeaseWrapper clw) {
        LeaseSet set;
        block16: {
            set = clw.getLeaseSet();
            if (set == null) {
                return;
            }
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            // MONITORENTER : leaseSet
            if (!NormServerBaseImpl.isCurrent(set)) {
                // MONITOREXIT : leaseSet
                this.store.releaseMutatorLock();
                return;
            }
            if (set.doesContainWrapper(clw)) break block16;
            this.store.releaseMutatorLock();
            return;
        }
        long desiredExpiration = clw.getMembershipExpiration();
        if (desiredExpiration > System.currentTimeMillis()) {
            this.lrm.renewUntil(clw, clw.getMembershipExpiration(), clw.getRenewDuration(), this.lrmEventListener);
            // MONITOREXIT : leaseSet
            this.store.releaseMutatorLock();
            return;
        }
        if (clw.getExpiration() < desiredExpiration) {
            // MONITOREXIT : leaseSet
            this.store.releaseMutatorLock();
            return;
        }
        try {
            logger.log(Level.FINE, "Reached desired expiration for lease {0}", clw);
            set.remove(clw);
            try {
                this.lrm.remove(clw);
                return;
            }
            catch (UnknownLeaseException e) {
                // empty catch block
            }
            return;
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    private void removeClientLeases(Iterator deadLeases) {
        while (deadLeases.hasNext()) {
            ClientLeaseWrapper clw = (ClientLeaseWrapper)deadLeases.next();
            try {
                this.lrm.remove(clw);
            }
            catch (UnknownLeaseException unknownLeaseException) {}
        }
    }

    private static void ensureCurrent(LeaseSet set) throws ThrowThis {
        if (!NormServerBaseImpl.isCurrent(set)) {
            throw new ThrowThis(new NoSuchObjectException("Set has expired"));
        }
    }

    private static boolean isCurrent(LeaseSet set) {
        return set.getExpiration() > System.currentTimeMillis();
    }

    private LeaseSet getSet(Uuid id) throws ThrowThis {
        LeaseSet rslt = (LeaseSet)this.setTable.get(id);
        if (rslt == null) {
            throw new ThrowThis(new NoSuchObjectException("Can't find set"));
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LeaseRenewalSet createLeaseRenewalSet(long leaseDuration) {
        LeasePeriodPolicy.Result leasePeriod;
        this.ready.check();
        Uuid newID = UuidFactory.generate();
        LeaseSet newSet = new LeaseSet(newID, this.generator, this.store, this);
        try {
            leasePeriod = this.setLeasePolicy.grant(newSet, leaseDuration);
        }
        catch (LeaseDeniedException e) {
            logger.log(Level.WARNING, "Got LeaseDeniedException creating lease -- this should not happen!", e);
            throw new InternalNormException("Error creating lease", e);
        }
        LandlordLease newLease = this.leaseFactory.newLease(newID, leasePeriod.expiration);
        newSet.setExpiration(leasePeriod.expiration);
        try {
            this.store.acquireMutatorLock();
            CreateLeaseSet u = new CreateLeaseSet(newSet);
            this.store.update(u);
            this.expMgr.register(newSet);
            this.setTable.put(newID, newSet);
        }
        finally {
            this.store.releaseMutatorLock();
        }
        SetProxy result = SetProxy.create(this.serverProxy, newID, newLease);
        logger.log(Level.FINE, "Created lease renewal set {0}", result);
        return result;
    }

    SetProxy newSetProxy(LeaseSet set) {
        LandlordLease l = this.leaseFactory.newLease(set.getUuid(), set.getExpiration());
        return SetProxy.create(this.serverProxy, set.getUuid(), l);
    }

    SendMonitor newSendMonitor(LeaseSet set) {
        return new SendMonitorImpl(set);
    }

    @Override
    public TrustVerifier getProxyVerifier() {
        return new ProxyVerifier(this.serverProxy, this.serverUuid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Uuid cookie, long extension) throws UnknownLeaseException, LeaseDeniedException {
        this.ready.check();
        LeaseSet set = (LeaseSet)this.setTable.get(cookie);
        if (set == null) {
            throw new UnknownLeaseException("No lease for cookie:" + cookie);
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                if (!NormServerBaseImpl.isCurrent(set)) {
                    throw new UnknownLeaseException("Lease has already expired");
                }
                long oldExpiration = set.getExpiration();
                LeasePeriodPolicy.Result leasePeriod = this.setLeasePolicy.renew(set, extension);
                LeaseSet.ChangeSetExpiration u = new LeaseSet.ChangeSetExpiration(set, leasePeriod.expiration);
                this.store.update(u);
                set.setExpiration(leasePeriod.expiration);
                this.expMgr.reschedule(set);
                long l = leasePeriod.duration;
                return l;
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Uuid cookie) throws UnknownLeaseException {
        this.ready.check();
        LeaseSet set = (LeaseSet)this.setTable.get(cookie);
        if (set == null) {
            throw new UnknownLeaseException("No lease for cookie:" + cookie);
        }
        try {
            this.store.acquireMutatorLock();
            LeaseSet leaseSet = set;
            synchronized (leaseSet) {
                block9: {
                    if (NormServerBaseImpl.isCurrent(set)) break block9;
                    return;
                }
                this.removeSet(set);
            }
        }
        finally {
            this.store.releaseMutatorLock();
        }
    }

    private void removeSet(LeaseSet set) {
        if (this.setTable.remove(set.getUuid()) != null) {
            Set leases = set.destroy();
            this.removeClientLeases(leases.iterator());
        }
    }

    @Override
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extensions) {
        this.ready.check();
        return LandlordUtil.renewAll(this, cookies, extensions);
    }

    @Override
    public Map cancelAll(Uuid[] cookies) {
        this.ready.check();
        return LandlordUtil.cancelAll(this, cookies);
    }

    void updatePerformed(int updateCount) {
        int snapshotSize;
        if (updateCount >= this.logToSnapshotThresh && (float)updateCount >= this.snapshotWt * (float)(snapshotSize = this.setTable.size() + this.countLeases.getCount())) {
            this.snapshotter.takeSnapshot();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void restoreTransientState() {
        long now = System.currentTimeMillis();
        Iterator i = this.setTable.values().iterator();
        while (i.hasNext()) {
            LeaseSet set = (LeaseSet)i.next();
            if (now > set.getExpiration()) {
                i.remove();
                continue;
            }
            Iterator leases = set.restoreTransientState(this.generator, this.store, this, this.recoveredListenerPreparer);
            while (leases.hasNext()) {
                ClientLeaseWrapper clw;
                NormServerBaseImpl normServerBaseImpl = this;
                synchronized (normServerBaseImpl) {
                    clw = (ClientLeaseWrapper)leases.next();
                    clw.recoverTransient(this.renewedList, this.idGen, set, this.recoveredLeasePreparer);
                }
                Throwable lt = clw.getLastFailure();
                if (lt == null || ThrowableConstants.retryable(lt) == 0) {
                    this.lrm.renewUntil(clw, clw.getMembershipExpiration(), clw.getRenewDuration(), this.lrmEventListener);
                    continue;
                }
                this.lrmEventListener.notify(new LeaseRenewalEvent(this.lrm, clw, clw.getMembershipExpiration(), lt));
            }
        }
    }

    private String inventory() {
        return this.countLeases.getCount() + " client leases, " + this.setTable.size() + " sets.";
    }

    @Override
    public Object getAdmin() {
        this.ready.check();
        return this.adminProxy;
    }

    @Override
    public Entry[] getLookupAttributes() {
        this.ready.check();
        return this.joinState.getAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) {
        this.ready.check();
        this.joinState.addAttributes(attrSets, true);
        logger.log(Level.CONFIG, "Added attributes");
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        this.ready.check();
        this.joinState.modifyAttributes(attrSetTemplates, attrSets, true);
        logger.log(Level.CONFIG, "Modified attributes");
    }

    @Override
    public String[] getLookupGroups() {
        this.ready.check();
        return this.joinState.getGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) {
        this.ready.check();
        this.joinState.addGroups(groups);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Added lookup groups: {0}", NormServerBaseImpl.toString(groups));
        }
    }

    @Override
    public void removeLookupGroups(String[] groups) {
        this.ready.check();
        this.joinState.removeGroups(groups);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Removed lookup groups: {0}", NormServerBaseImpl.toString(groups));
        }
    }

    @Override
    public void setLookupGroups(String[] groups) {
        this.ready.check();
        this.joinState.setGroups(groups);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Set lookup groups: {0}", NormServerBaseImpl.toString(groups));
        }
    }

    @Override
    public LookupLocator[] getLookupLocators() {
        this.ready.check();
        return this.joinState.getLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        int i = locators.length;
        while (--i >= 0) {
            locators[i] = (LookupLocator)this.locatorPreparer.prepareProxy(locators[i]);
        }
        this.joinState.addLocators(locators);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Added lookup locators: {0}", NormServerBaseImpl.toString(locators));
        }
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        int i = locators.length;
        while (--i >= 0) {
            locators[i] = (LookupLocator)this.locatorPreparer.prepareProxy(locators[i]);
        }
        this.joinState.removeLocators(locators);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Removed lookup locators: {0}", NormServerBaseImpl.toString(locators));
        }
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.ready.check();
        int i = locators.length;
        while (--i >= 0) {
            locators[i] = (LookupLocator)this.locatorPreparer.prepareProxy(locators[i]);
        }
        this.joinState.setLocators(locators);
        if (logger.isLoggable(Level.CONFIG)) {
            logger.log(Level.CONFIG, "Set lookup locators: {0}", NormServerBaseImpl.toString(locators));
        }
    }

    private static String toString(Object[] array) {
        if (array == null) {
            return "null";
        }
        StringBuffer sb = new StringBuffer(String.valueOf(array[0]));
        for (int i = 1; i < array.length; ++i) {
            sb.append(", ").append(array[i]);
        }
        return sb.toString();
    }

    @Override
    public void destroy() throws RemoteException {
        this.ready.shutdown();
        logger.log(Level.INFO, "Destroying Norm service");
        this.joinState.terminateJoin();
        this.lrmEventListener.interrupt();
        this.renewLogger.interrupt();
        this.snapshotter.interrupt();
        this.expMgr.terminate();
        this.generator.terminate();
        this.lrm.clear();
        logger.log(Level.FINEST, "Independent threads interrupted");
        new DestroyThread().start();
        logger.log(Level.FINEST, "Destroy thread started");
    }

    boolean unexport(boolean force) throws NoSuchObjectException {
        return this.exporter.unexport(force);
    }

    void postDestroy() {
    }

    @Override
    public Object getServiceProxy() {
        this.ready.check();
        return this.normProxy;
    }

    @Override
    public Object getProxy() {
        return this.serverProxy;
    }

    public String toString() {
        String className = this.getClass().getName();
        className = className.substring(className.lastIndexOf(46) + 1);
        return className + "[" + this.serverUuid + "]";
    }

    void init(String[] configOptions, LifeCycle lifeCycle) throws Exception {
        try {
            final Configuration config = ConfigurationProvider.getInstance(configOptions, this.getClass().getClassLoader());
            this.lifeCycle = lifeCycle;
            this.loginContext = (LoginContext)config.getEntry(NORM, "loginContext", LoginContext.class, null);
            if (this.loginContext == null) {
                this.initAsSubject(config);
            } else {
                this.loginContext.login();
                try {
                    Subject.doAsPrivileged(this.loginContext.getSubject(), new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            NormServerBaseImpl.this.initAsSubject(config);
                            return null;
                        }
                    }, null);
                }
                catch (PrivilegedActionException e) {
                    throw e.getCause();
                }
            }
            this.ready.ready();
            logger.log(Level.INFO, "Norm service started: {0}", this);
        }
        catch (Throwable e) {
            NormServerBaseImpl.initFailed(e);
        }
    }

    static void initFailed(Throwable e) throws Exception {
        String message = null;
        if (e instanceof InitException) {
            message = e.getMessage();
            e = e.getCause();
        }
        if (logger.isLoggable(Level.SEVERE)) {
            if (message != null) {
                NormServerBaseImpl.logThrow(Level.SEVERE, "initFailed", "Unable to start Norm service: {0}", new Object[]{message}, e);
            } else {
                logger.log(Level.SEVERE, "Unable to start Norm service", e);
            }
        }
        if (e instanceof Exception) {
            throw (Exception)e;
        }
        if (e instanceof Error) {
            throw (Error)e;
        }
        IllegalStateException ise = new IllegalStateException(e.getMessage());
        ise.initCause(e);
        throw ise;
    }

    private static void logThrow(Level level, String method, String msg, Object[] msgParams, Throwable t) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(NormServerBaseImpl.class.getName());
        r.setSourceMethodName(method);
        r.setParameters(msgParams);
        r.setThrown(t);
        logger.log(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initAsSubject(Configuration config) throws Exception {
        if (this.persistent) {
            this.persistenceDirectory = (String)Config.getNonNullEntry(config, NORM, "persistenceDirectory", String.class);
            this.snapshotWt = Config.getFloatEntry(config, NORM, "persistenceSnapshotWeight", 10.0f, 0.0f, Float.MAX_VALUE);
            this.logToSnapshotThresh = Config.getIntEntry(config, NORM, "persistenceSnapshotThreshold", 200, 0, Integer.MAX_VALUE);
        }
        this.leasePreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "leasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "listenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        this.locatorPreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "locatorPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        if (this.persistent) {
            this.recoveredLeasePreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "recoveredLeasePreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "recoveredListenerPreparer", ProxyPreparer.class, new BasicProxyPreparer());
            this.recoveredLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(config, NORM, "recoveredLocatorPreparer", ProxyPreparer.class, new BasicProxyPreparer());
        }
        this.setLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, NORM, "leasePolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(0x6DDD00L, 3600000L));
        this.isolateSets = (Boolean)config.getEntry(NORM, "isolateSets", Boolean.TYPE, Boolean.FALSE);
        try {
            this.lrm = (LeaseRenewalManager)Config.getNonNullEntry(config, NORM, "leaseManager", LeaseRenewalManager.class);
        }
        catch (NoSuchEntryException e) {
            this.lrm = new LeaseRenewalManager(config);
        }
        this.exporter = this.getExporter(config);
        this.serverProxy = (NormServer)this.exporter.export(this);
        boolean done = false;
        try {
            this.expMgr = new LeaseExpirationMgr(this);
            this.generator = new EventTypeGenerator();
            this.lrmEventListener = new LRMEventListener(this);
            this.renewLogger = new RenewLogThread();
            this.snapshotter = new SnapshotThread();
            try {
                this.store = new PersistentStore(this.persistenceDirectory, new OurLogHandler(), this);
                this.restoreTransientState();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Log recovered: {0}", this.inventory());
                }
            }
            catch (CorruptedStoreException e) {
                throw new InitException("Log corrupted, can't recover ", e);
            }
            catch (StoreException e) {
                throw new InitException("Can't recover log", e);
            }
            if (this.serverUuid == null) {
                this.serverUuid = UuidFactory.generate();
            }
            this.normProxy = NormProxy.create(this.serverProxy, this.serverUuid);
            this.adminProxy = AdminProxy.create(this.serverProxy, this.serverUuid);
            try {
                this.store.snapshot();
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "Completed new baseline snapshot: {0}", this.inventory());
                }
            }
            catch (IOException e) {
                throw new InitException("Can't create new baseline snapshot", e);
            }
            Entry[] serviceAttributes = new Entry[]{new ServiceInfo("Lease Renewal Service", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.0", "", ""), new BasicServiceType("Lease Renewal Service")};
            try {
                this.joinState = new JoinState(this.normProxy, this.lrm, config, serviceAttributes, this.recoveredLocatorPreparer, new ServiceID(this.serverUuid.getMostSignificantBits(), this.serverUuid.getLeastSignificantBits()));
                this.store.addSubStore(this.joinState);
            }
            catch (StoreException e) {
                throw new InitException("Can't create JoinState", e);
            }
            this.leaseFactory = new LeaseFactory(this.serverProxy, this.serverUuid);
            Iterator i = this.setTable.values().iterator();
            while (i.hasNext()) {
                LeaseSet set;
                LeaseSet leaseSet = set = (LeaseSet)i.next();
                synchronized (leaseSet) {
                    this.expMgr.schedule(set);
                }
            }
            this.lrmEventListener.start();
            this.renewLogger.start();
            this.snapshotter.start();
            done = true;
        }
        finally {
            if (!done) {
                try {
                    this.unexport(true);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Unable to unexport after failure during startup", e);
                }
            }
        }
    }

    boolean isolateSets() {
        return this.isolateSets;
    }

    NormServerBaseImpl(boolean persistent) {
        this.persistent = persistent;
    }

    Exporter getExporter(Configuration config) throws ConfigurationException {
        return (Exporter)Config.getNonNullEntry(config, NORM, "serverExporter", Exporter.class, new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory()));
    }

    class InitException
    extends Exception {
        private static final long serialVersionUID = 1L;

        private InitException(String message, Throwable nested) {
            super(message, nested);
        }
    }

    private class DestroyThread
    extends Thread {
        private static final long MAX_DELAY = 120000L;

        private DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            logger.log(Level.FINEST, "DestroyThread running");
            long end_time = System.currentTimeMillis() + 120000L;
            boolean unexported = false;
            try {
                while (!unexported && System.currentTimeMillis() < end_time) {
                    logger.log(Level.FINEST, "Calling unexport (force=false)...");
                    unexported = NormServerBaseImpl.this.unexport(false);
                    logger.log(Level.FINEST, "...rslt = " + unexported);
                    if (unexported) continue;
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                    }
                }
            }
            catch (NoSuchObjectException e) {
                logger.log(Level.FINEST, "...rslt = NoSuchObjectException");
                unexported = true;
            }
            catch (Throwable t) {
                logger.log(Level.FINEST, "...rslt = ", t);
            }
            if (!unexported) {
                try {
                    logger.log(Level.FINEST, "Calling unexport (force=true)");
                    NormServerBaseImpl.this.unexport(true);
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
            }
            try {
                logger.log(Level.FINEST, "Joining independent threads");
                NormServerBaseImpl.this.lrmEventListener.join(120000L);
                NormServerBaseImpl.this.renewLogger.join(120000L);
                NormServerBaseImpl.this.snapshotter.join(120000L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            try {
                logger.log(Level.FINEST, "Destroying store");
                NormServerBaseImpl.this.store.destroy();
            }
            catch (Exception t) {
                logger.log(Level.INFO, "While destroying persistent store -- destroy continuing", t);
            }
            if (NormServerBaseImpl.this.lifeCycle != null) {
                NormServerBaseImpl.this.lifeCycle.unregister(this);
            }
            logger.log(Level.FINEST, "Calling postDestroy");
            NormServerBaseImpl.this.postDestroy();
            if (NormServerBaseImpl.this.loginContext != null) {
                try {
                    logger.log(Level.FINEST, "Logging out");
                    NormServerBaseImpl.this.loginContext.logout();
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception while logging out", e);
                }
            }
            logger.log(Level.FINEST, "Ending DestroyThread");
        }
    }

    private class SnapshotThread
    extends InterruptedStatusThread {
        private SnapshotThread() {
            super("snapshot thread");
            this.setDaemon(true);
        }

        private synchronized void takeSnapshot() {
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.hasBeenInterrupted()) {
                SnapshotThread snapshotThread = this;
                synchronized (snapshotThread) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
                try {
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Taking snapshot: {0}", NormServerBaseImpl.this.inventory());
                    }
                    NormServerBaseImpl.this.store.snapshot();
                }
                catch (InterruptedIOException e) {
                    return;
                }
                catch (Exception e) {
                    if (e instanceof LogException && ((LogException)e).detail instanceof InterruptedIOException) {
                        return;
                    }
                    logger.log(Level.WARNING, "Snapshot failed", e);
                }
            }
        }
    }

    private class OurLogHandler
    extends LogHandler {
        private OurLogHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void snapshot(OutputStream out) throws Exception {
            long now = System.currentTimeMillis();
            ObjectOutputStream oostream = new ObjectOutputStream(out);
            oostream.writeInt(2);
            oostream.writeObject(NormServerBaseImpl.this.serverUuid);
            oostream.writeObject(NormServerBaseImpl.this.generator);
            oostream.writeInt(NormServerBaseImpl.this.setTable.size());
            Collection sets = NormServerBaseImpl.this.setTable.values();
            Iterator i = sets.iterator();
            while (i.hasNext()) {
                LeaseSet set;
                LeaseSet leaseSet = set = (LeaseSet)i.next();
                synchronized (leaseSet) {
                    oostream.writeObject(set);
                }
            }
            oostream.flush();
        }

        @Override
        public void recover(InputStream in) throws Exception {
            ObjectInputStream oistream = new ObjectInputStream(in);
            int version = oistream.readInt();
            if (version != 2) {
                throw new CorruptedStoreException("Incompatible version ID in log, looking for 2, got " + version);
            }
            NormServerBaseImpl.this.serverUuid = (Uuid)oistream.readObject();
            NormServerBaseImpl.this.generator = (EventTypeGenerator)oistream.readObject();
            int size = oistream.readInt();
            NormServerBaseImpl.this.setTable = Collections.synchronizedMap(new HashMap(size));
            for (int i = 0; i < size; ++i) {
                LeaseSet set = (LeaseSet)oistream.readObject();
                NormServerBaseImpl.this.setTable.put(set.getUuid(), set);
            }
        }

        @Override
        public void applyUpdate(Object update) throws Exception {
            LoggedOperation op = (LoggedOperation)update;
            op.apply(NormServerBaseImpl.this.setTable);
        }
    }

    private class RenewLogThread
    extends InterruptedStatusThread {
        private RenewLogThread() {
            super("log renewals thread");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (!this.hasBeenInterrupted()) {
                try {
                    LeaseSet set;
                    ClientLeaseWrapper clw;
                    List list = NormServerBaseImpl.this.renewedList;
                    synchronized (list) {
                        if (NormServerBaseImpl.this.renewedList.isEmpty()) {
                            try {
                                NormServerBaseImpl.this.renewedList.wait();
                                continue;
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                return;
                            }
                        }
                        clw = (ClientLeaseWrapper)NormServerBaseImpl.this.renewedList.remove(0);
                    }
                    if (logger.isLoggable(Level.FINER)) {
                        logger.log(Level.FINER, "Attempting to renew lease {0} at {1}", new Object[]{clw, System.currentTimeMillis()});
                    }
                    if ((set = clw.getLeaseSet()) == null) continue;
                    try {
                        NormServerBaseImpl.this.store.acquireMutatorLock();
                        LeaseSet e = set;
                        synchronized (e) {
                            block20: {
                                if (NormServerBaseImpl.isCurrent(set)) break block20;
                                continue;
                            }
                            clw.clearRenewed();
                            set.logRenewal(clw);
                        }
                    }
                    finally {
                        NormServerBaseImpl.this.store.releaseMutatorLock();
                        continue;
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException ex) {
                        Thread.currentThread().interrupt();
                    }
                }
                catch (RuntimeException e) {
                    logger.log(Level.INFO, "Runtime exception in RenewLogThread -- restarting", e);
                }
            }
        }
    }

    private class SendMonitorImpl
    implements SendMonitor {
        private final LeaseSet set;

        private SendMonitorImpl(LeaseSet set) {
            this.set = set;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void definiteException(EventType type, RemoteEvent ev, long registrationNumber, Throwable t) {
            try {
                NormServerBaseImpl.this.store.acquireMutatorLock();
                if (!NormServerBaseImpl.isCurrent(this.set)) {
                    return;
                }
                LeaseSet leaseSet = this.set;
                synchronized (leaseSet) {
                    this.set.definiteException(type, ev, registrationNumber);
                }
            }
            finally {
                NormServerBaseImpl.this.store.releaseMutatorLock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isCurrent() {
            LeaseSet leaseSet = this.set;
            synchronized (leaseSet) {
                return NormServerBaseImpl.isCurrent(this.set);
            }
        }
    }

    private static class CountLeases {
        private int count;

        private CountLeases() {
        }

        private synchronized void updateCount(int change) {
            this.count += change;
            assert (this.count >= 0);
        }

        private synchronized int getCount() {
            return this.count;
        }
    }

    private static final class ReadyState {
        private static final int INITIALIZE = 0;
        private static final int READY = 1;
        private static final int SHUTDOWN = 2;
        private int state = 0;

        private ReadyState() {
        }

        synchronized void check() {
            block6: while (true) {
                switch (this.state) {
                    case 0: {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {}
                        continue block6;
                    }
                    case 1: {
                        return;
                    }
                }
                break;
            }
            throw new IllegalStateException("Norm service is unavailable");
        }

        synchronized void ready() {
            switch (this.state) {
                case 0: {
                    this.state = 1;
                    this.notifyAll();
                    break;
                }
                case 1: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Norm service is unavailable");
                }
            }
        }

        synchronized void shutdown() {
            this.check();
            this.state = 2;
            this.notifyAll();
        }
    }
}

