/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.norm.lookup;

import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.norm.lookup.SubStore;
import com.sun.jini.reliableLog.LogHandler;
import com.sun.jini.reliableLog.ReliableLog;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.rmi.MarshalledObject;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.NoSuchEntryException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lease.LeaseRenewalManager;
import net.jini.lookup.JoinManager;
import net.jini.security.ProxyPreparer;

public class JoinState
extends LogHandler
implements SubStore {
    private static final String NORM = "com.sun.jini.norm";
    private static final Logger logger = Logger.getLogger("com.sun.jini.norm");
    final Object service;
    private final LeaseRenewalManager lrm;
    private final Configuration config;
    private final Entry[] serviceAttributes;
    private final ProxyPreparer recoveredLookupLocatorPreparer;
    private final ServiceID serviceID;
    private ReliableLog log;
    private boolean recoveredData;
    private Entry[] attributes;
    private String[] groups = DiscoveryGroupManagement.NO_GROUPS;
    private LookupLocator[] locators;
    private DiscoveryManagement dm;
    private JoinManager joinMgr;

    public JoinState(Object service, LeaseRenewalManager lrm, Configuration config, Entry[] serviceAttributes, ProxyPreparer recoveredLookupLocatorPreparer, ServiceID serviceID) throws IOException {
        this.service = service;
        this.lrm = lrm;
        this.config = config;
        this.serviceAttributes = serviceAttributes;
        this.recoveredLookupLocatorPreparer = recoveredLookupLocatorPreparer;
        this.serviceID = serviceID;
    }

    @Override
    public String subDirectory() {
        return "JoinState";
    }

    @Override
    public void setDirectory(File dir) throws IOException, ConfigurationException {
        if (dir != null) {
            try {
                this.log = new ReliableLog(dir.getCanonicalPath(), this);
                this.log.recover();
            }
            catch (IOException e) {
                IOException e2 = new IOException("Log is corrupted: " + e.getMessage());
                e2.initCause(e);
                throw e2;
            }
        }
        if (!this.recoveredData) {
            this.getInitialEntries();
        } else {
            LinkedList<Object> prepared = new LinkedList<Object>();
            int i = this.locators.length;
            while (--i >= 0) {
                try {
                    prepared.add(this.recoveredLookupLocatorPreparer.prepareProxy(this.locators[i]));
                }
                catch (Throwable t) {
                    if (!logger.isLoggable(Level.INFO)) continue;
                    JoinState.logThrow(Level.INFO, "setDirectory", "Problem preparing lookup locator {0} -- discarding", new Object[]{this.locators[i]}, t);
                }
            }
            this.locators = prepared.toArray(new LookupLocator[prepared.size()]);
        }
        this.createDiscoveryManager();
        try {
            this.joinMgr = new JoinManager(this.service, this.attributes, this.serviceID, this.dm, this.lrm, this.config);
        }
        catch (IOException e) {
            IOException e2 = new IOException("Problem starting JoinManager: " + e.getMessage());
            e2.initCause(e2);
            throw e2;
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Ignoring problem creating initial snapshot", e);
        }
    }

    private static void logThrow(Level level, String method, String msg, Object[] msgParams, Throwable t) {
        LogRecord r = new LogRecord(level, msg);
        r.setLoggerName(logger.getName());
        r.setSourceClassName(JoinState.class.getName());
        r.setSourceMethodName(method);
        r.setParameters(msgParams);
        r.setThrown(t);
        logger.log(r);
    }

    private Object[] getArrayEntry(String name, Class type, Object defaultValue) throws ConfigurationException {
        Object[] result = (Object[])this.config.getEntry(NORM, name, type, defaultValue);
        if (result != null) {
            int i = result.length;
            while (--i >= 0) {
                if (result[i] != null) continue;
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name " + name + " must not contain null elements");
            }
        }
        return result;
    }

    private void getInitialEntries() throws ConfigurationException {
        this.attributes = (Entry[])this.getArrayEntry("initialLookupAttributes", Entry[].class, null);
        if (this.attributes == null || this.attributes.length == 0) {
            this.attributes = this.serviceAttributes;
        } else {
            Entry[] temp = new Entry[this.serviceAttributes.length + this.attributes.length];
            System.arraycopy(this.serviceAttributes, 0, temp, 0, this.serviceAttributes.length);
            System.arraycopy(this.attributes, 0, temp, this.serviceAttributes.length, this.attributes.length);
            this.attributes = temp;
        }
        this.groups = (String[])this.getArrayEntry("initialLookupGroups", String[].class, new String[]{""});
        this.locators = (LookupLocator[])this.getArrayEntry("initialLookupLocators", LookupLocator[].class, null);
        if (this.locators == null) {
            this.locators = new LookupLocator[0];
        }
    }

    private void createDiscoveryManager() throws ConfigurationException, IOException {
        try {
            this.dm = (DiscoveryManagement)Config.getNonNullEntry(this.config, NORM, "discoveryManager", DiscoveryManagement.class);
            if (!(this.dm instanceof DiscoveryGroupManagement)) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must implement net.jini.discovery.DiscoveryGroupManagement");
            }
            String[] groups = ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
            if (groups == null || groups.length != 0) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must be configured with no groups");
            }
            if (!(this.dm instanceof DiscoveryLocatorManagement)) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must implement net.jini.discovery.DiscoveryLocatorManagement");
            }
            if (((DiscoveryLocatorManagement)((Object)this.dm)).getLocators().length != 0) {
                throw new ConfigurationException("Entry for component com.sun.jini.norm, name discoveryManager must be configured with no locators");
            }
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(groups);
            ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(this.locators);
        }
        catch (NoSuchEntryException e) {
            this.dm = new LookupDiscoveryManager(this.groups, this.locators, null, this.config);
        }
    }

    @Override
    public void prepareDestroy() {
        try {
            if (this.log != null) {
                this.log.close();
            }
        }
        catch (IOException e) {
            logger.log(Levels.HANDLED, "Ignoring problem closing log during destroy", e);
        }
    }

    public void terminateJoin() {
        if (this.joinMgr != null) {
            this.joinMgr.terminate();
        }
        if (this.dm != null) {
            this.dm.terminate();
        }
    }

    @Override
    public void snapshot(OutputStream out) throws IOException {
        ObjectOutputStream oostream = new ObjectOutputStream(out);
        JoinState.writeAttributes(this.joinMgr.getAttributes(), oostream);
        oostream.writeObject(((DiscoveryGroupManagement)((Object)this.dm)).getGroups());
        oostream.writeObject(((DiscoveryLocatorManagement)((Object)this.dm)).getLocators());
        oostream.flush();
    }

    @Override
    public void recover(InputStream in) throws Exception {
        ObjectInputStream oistream = new ObjectInputStream(in);
        this.attributes = JoinState.readAttributes(oistream);
        this.groups = (String[])oistream.readObject();
        this.locators = (LookupLocator[])oistream.readObject();
        this.recoveredData = true;
    }

    @Override
    public void applyUpdate(Object update) throws Exception {
        throw new UnsupportedOperationException("Recovering log update -- this should not happen");
    }

    private static void writeAttributes(Entry[] attributes, ObjectOutputStream out) throws IOException {
        out.writeInt(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            out.writeObject(new MarshalledObject<Entry>(attributes[i]));
        }
    }

    private static Entry[] readAttributes(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LinkedList entries = new LinkedList();
        int objectCount = in.readInt();
        for (int i = 0; i < objectCount; ++i) {
            try {
                MarshalledObject mo = (MarshalledObject)in.readObject();
                entries.add(mo.get());
                continue;
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Problem recovering attribute -- discarding", e);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.INFO, "Problem recovering attribute -- discarding", e);
            }
        }
        return entries.toArray(new Entry[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void takeSnapshot() throws IOException {
        if (this.log == null) {
            return;
        }
        ReliableLog reliableLog = this.log;
        synchronized (reliableLog) {
            this.log.snapshot();
        }
    }

    public String[] getGroups() {
        return ((DiscoveryGroupManagement)((Object)this.dm)).getGroups();
    }

    public void addGroups(String[] groups) {
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).addGroups(groups);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not change groups: " + e.getMessage(), e);
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public void removeGroups(String[] groups) {
        ((DiscoveryGroupManagement)((Object)this.dm)).removeGroups(groups);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public void setGroups(String[] groups) {
        try {
            ((DiscoveryGroupManagement)((Object)this.dm)).setGroups(groups);
        }
        catch (IOException e) {
            throw new RuntimeException("Could not change groups: " + e.getMessage(), e);
        }
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public LookupLocator[] getLocators() {
        return ((DiscoveryLocatorManagement)((Object)this.dm)).getLocators();
    }

    public void addLocators(LookupLocator[] locators) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).addLocators(locators);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public void removeLocators(LookupLocator[] locators) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).removeLocators(locators);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public void setLocators(LookupLocator[] locators) {
        ((DiscoveryLocatorManagement)((Object)this.dm)).setLocators(locators);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public Entry[] getAttributes() {
        return this.joinMgr.getAttributes();
    }

    public void addAttributes(Entry[] attrSets, boolean checkSC) {
        this.joinMgr.addAttributes(attrSets, checkSC);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }

    public void modifyAttributes(Entry[] attrSetTemplates, Entry[] attrSets, boolean checkSC) {
        this.joinMgr.modifyAttributes(attrSetTemplates, attrSets, checkSC);
        try {
            this.takeSnapshot();
        }
        catch (IOException e) {
            throw new RuntimeException("Could not log change: " + e.getMessage(), e);
        }
    }
}

