/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.AdminIterator;
import com.sun.jini.outrigger.IteratorProxy;
import com.sun.jini.outrigger.JavaSpaceAdmin;
import com.sun.jini.outrigger.OutriggerAdmin;
import com.sun.jini.outrigger.SpaceProxy2;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;
import net.jini.space.JavaSpace;

class AdminProxy
implements JavaSpaceAdmin,
ReferentUuid,
Serializable {
    private static final long serialVersionUID = 1L;
    final OutriggerAdmin admin;
    final Uuid spaceUuid;
    private static final boolean DEBUG = false;

    AdminProxy(OutriggerAdmin admin, Uuid spaceUuid) {
        if (admin == null) {
            throw new NullPointerException("admin must be non-null");
        }
        if (spaceUuid == null) {
            throw new NullPointerException("spaceUuid must be non-null");
        }
        this.admin = admin;
        this.spaceUuid = spaceUuid;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.admin == null) {
            throw new InvalidObjectException("null server reference");
        }
        if (this.spaceUuid == null) {
            throw new InvalidObjectException("null Uuid");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("SpaceProxy should always have data");
    }

    @Override
    public JavaSpace space() throws RemoteException {
        return this.admin.space();
    }

    @Override
    public AdminIterator contents(Entry tmpl, Transaction tr) throws TransactionException, RemoteException {
        return this.contents(tmpl, tr, -1);
    }

    @Override
    public AdminIterator contents(Entry tmpl, Transaction tr, int fetchSize) throws TransactionException, RemoteException {
        return new IteratorProxy(this.admin.contents(SpaceProxy2.repFor(tmpl), tr), this.admin, fetchSize);
    }

    @Override
    public void destroy() throws RemoteException {
        this.admin.destroy();
    }

    @Override
    public Entry[] getLookupAttributes() throws RemoteException {
        return this.admin.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) throws RemoteException {
        this.admin.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) throws RemoteException {
        this.admin.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() throws RemoteException {
        return this.admin.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) throws RemoteException {
        this.admin.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) throws RemoteException {
        this.admin.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) throws RemoteException {
        this.admin.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() throws RemoteException {
        return this.admin.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.admin.setLookupLocators(locators);
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.spaceUuid + " (through " + this.admin + ")";
    }

    public boolean equals(Object other) {
        return ReferentUuids.compare(this, other);
    }

    public int hashCode() {
        return this.spaceUuid.hashCode();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.spaceUuid;
    }
}

