/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.StorableResource;
import com.sun.jini.proxy.MarshalledWrapper;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.rmi.MarshalException;
import java.rmi.UnmarshalException;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import net.jini.core.entry.Entry;
import net.jini.core.entry.UnusableEntryException;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.io.MarshalledInstance;
import net.jini.loader.ClassLoading;
import net.jini.loader.RiverClassLoader;

class EntryRep
implements StorableResource,
LeasedResource,
Serializable {
    static final long serialVersionUID = 3L;
    private MarshalledInstance[] values;
    private String[] superclasses;
    private long[] hashes;
    private long hash;
    private String className;
    private String codebase;
    private Uuid id;
    private transient long expires;
    private transient boolean integrity;
    private static final FieldComparator comparator = new FieldComparator();
    private static final EntryRep matchAnyRep;
    private transient Class realClass;
    private static final Logger logger;
    private static WeakHashMap classHashes;
    private static Class[] noArg;

    void shareWith(EntryRep other) {
        this.className = other.className;
        this.superclasses = other.superclasses;
        this.hashes = other.hashes;
        this.hash = other.hash;
    }

    private static Field[] getFields(Class cl) {
        Field[] fields = cl.getFields();
        Arrays.sort(fields, comparator);
        return fields;
    }

    private static synchronized Long findHash(Class clazz, boolean marshaling) throws MarshalException, UnusableEntryException {
        Long hash;
        if (classHashes == null) {
            classHashes = new WeakHashMap();
        }
        if ((hash = (Long)classHashes.get(clazz)) == null) {
            try {
                Field[] fields = EntryRep.getFields(clazz);
                MessageDigest md = MessageDigest.getInstance("SHA");
                DataOutputStream out = new DataOutputStream(new DigestOutputStream(new ByteArrayOutputStream(127), md));
                Class c = clazz.getSuperclass();
                if (c != Object.class) {
                    out.writeLong(EntryRep.findHash(c, marshaling));
                }
                for (int i = 0; i < fields.length; ++i) {
                    if (!EntryRep.usableField(fields[i])) continue;
                    out.writeUTF(fields[i].getName());
                    out.writeUTF(fields[i].getType().getName());
                }
                out.flush();
                byte[] digest = md.digest();
                long h = 0L;
                int i = Math.min(8, digest.length);
                while (--i >= 0) {
                    h += (long)(digest[i] & 0xFF) << i * 8;
                }
                hash = h;
            }
            catch (Exception e) {
                if (marshaling) {
                    throw EntryRep.throwNewMarshalException("Exception calculating entry class hash for " + clazz, e);
                }
                throw EntryRep.throwNewUnusableEntryException("Exception calculating entry class hash for " + clazz, e);
            }
            classHashes.put(clazz, hash);
        }
        return hash;
    }

    private EntryRep(Entry entry, boolean validate) throws MarshalException {
        this.realClass = entry.getClass();
        if (validate) {
            EntryRep.ensureValidClass(this.realClass);
        }
        this.className = this.realClass.getName();
        this.codebase = RiverClassLoader.getClassAnnotation(this.realClass);
        Field[] fields = EntryRep.getFields(this.realClass);
        int numFields = fields.length;
        MarshalledInstance[] vals = new MarshalledInstance[numFields];
        int nvals = 0;
        for (int fnum = 0; fnum < fields.length; ++fnum) {
            Object fieldValue;
            Field field = fields[fnum];
            if (!EntryRep.usableField(field)) continue;
            try {
                fieldValue = field.get(entry);
            }
            catch (IllegalAccessException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Couldn't access field " + field);
                iae.initCause(e);
                throw EntryRep.throwRuntime(iae);
            }
            if (fieldValue == null) {
                vals[nvals] = null;
            } else {
                try {
                    vals[nvals] = new MarshalledInstance(fieldValue);
                }
                catch (IOException e) {
                    throw EntryRep.throwNewMarshalException("Can't marshal field " + field + " with value " + fieldValue, e);
                }
            }
            ++nvals;
        }
        this.values = new MarshalledInstance[nvals];
        System.arraycopy(vals, 0, this.values, 0, nvals);
        try {
            this.hash = EntryRep.findHash(this.realClass, true);
        }
        catch (UnusableEntryException e) {
            throw new AssertionError((Object)e);
        }
        ArrayList<String> sclasses = new ArrayList<String>();
        ArrayList<Long> shashes = new ArrayList<Long>();
        for (Class c = this.realClass.getSuperclass(); c != Object.class; c = c.getSuperclass()) {
            try {
                sclasses.add(c.getName());
                shashes.add(EntryRep.findHash(c, true));
                continue;
            }
            catch (ClassCastException cce) {
                break;
            }
            catch (UnusableEntryException e) {
                throw new AssertionError((Object)e);
            }
        }
        this.superclasses = sclasses.toArray(new String[sclasses.size()]);
        this.hashes = new long[shashes.size()];
        for (int i = 0; i < this.hashes.length; ++i) {
            this.hashes[i] = (Long)shashes.get(i);
        }
    }

    public EntryRep(Entry entry) throws MarshalException {
        this(entry, true);
    }

    EntryRep() {
    }

    private static void ensureValidClass(Class c) {
        boolean ctorOK = false;
        try {
            if (!Modifier.isPublic(c.getModifiers())) {
                throw EntryRep.throwRuntime(new IllegalArgumentException("entry class " + c.getName() + " not public"));
            }
            Constructor ctor = c.getConstructor(noArg);
            ctorOK = Modifier.isPublic(ctor.getModifiers());
        }
        catch (NoSuchMethodException e) {
            ctorOK = false;
        }
        catch (SecurityException e) {
            ctorOK = false;
        }
        if (!ctorOK) {
            throw EntryRep.throwRuntime(new IllegalArgumentException("entry class " + c.getName() + " needs public no-arg constructor"));
        }
    }

    static EntryRep matchAnyEntryRep() {
        return matchAnyRep;
    }

    private static boolean isMatchAny(EntryRep rep) {
        return matchAnyRep.equals(rep);
    }

    static String matchAnyClassName() {
        return matchAnyRep.classFor();
    }

    Entry entry() throws UnusableEntryException {
        Object objIn = null;
        try {
            ArrayList<String> badFields = null;
            ArrayList<Throwable> except = null;
            this.realClass = ClassLoading.loadClass(this.codebase, this.className, null, this.integrity, null);
            if (EntryRep.findHash(this.realClass, false) != this.hash) {
                throw EntryRep.throwNewUnusableEntryException(new IncompatibleClassChangeError(this.realClass + " changed"));
            }
            Entry entryObj = (Entry)this.realClass.newInstance();
            Field[] fields = EntryRep.getFields(this.realClass);
            int nvals = 0;
            for (int i = 0; i < fields.length; ++i) {
                Throwable nested = null;
                try {
                    MarshalledInstance val;
                    if (!EntryRep.usableField(fields[i])) continue;
                    Object value = (val = this.values[nvals++]) == null ? null : val.get(this.integrity);
                    fields[i].set(entryObj, value);
                }
                catch (Throwable e) {
                    nested = e;
                }
                if (nested == null) continue;
                if (badFields == null) {
                    badFields = new ArrayList<String>(fields.length);
                    except = new ArrayList<Throwable>(fields.length);
                }
                badFields.add(fields[i].getName());
                except.add(nested);
            }
            if (nvals < this.values.length) {
                throw this.throwNewUnusableEntryException(entryObj, null, new Throwable[]{new IncompatibleClassChangeError("A usable field has been removed from " + entryObj.getClass().getName() + " since this EntryRep was created")});
            }
            if (badFields != null) {
                String[] bf = badFields.toArray(new String[badFields.size()]);
                Throwable[] ex = except.toArray(new Throwable[bf.length]);
                throw this.throwNewUnusableEntryException(entryObj, bf, ex);
            }
            return entryObj;
        }
        catch (InstantiationException e) {
            throw EntryRep.throwNewUnusableEntryException(e);
        }
        catch (ClassNotFoundException e) {
            throw EntryRep.throwNewUnusableEntryException("Encountered a ClassNotFoundException while unmarshalling " + this.className, e);
        }
        catch (IllegalAccessException e) {
            throw EntryRep.throwNewUnusableEntryException(e);
        }
        catch (RuntimeException e) {
            throw EntryRep.throwNewUnusableEntryException("Encountered a RuntimeException while unmarshalling " + this.className, e);
        }
        catch (MalformedURLException e) {
            throw EntryRep.throwNewUnusableEntryException("Malformed URL associated with entry of type " + this.className, e);
        }
        catch (MarshalException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int hashCode() {
        return this.className.hashCode();
    }

    public boolean equals(Object o) {
        int i;
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (!(o instanceof EntryRep)) {
            return false;
        }
        EntryRep other = (EntryRep)o;
        if (this.hash != other.hash) {
            return false;
        }
        if (this.values.length != other.values.length) {
            return false;
        }
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null && other.values[i] != null) {
                return false;
            }
            if (this.values[i] == null || other.values[i] != null) continue;
            return false;
        }
        for (i = 0; i < this.values.length; ++i) {
            if (this.values[i] == null || this.values[i].equals(other.values[i])) continue;
            return false;
        }
        return true;
    }

    private static boolean usableField(Field field) {
        int ignoreMods = 152;
        if ((field.getModifiers() & 0x98) != 0) {
            return false;
        }
        if (field.getType().isPrimitive()) {
            throw EntryRep.throwRuntime(new IllegalArgumentException("primitive field, " + field + ", not allowed in an Entry"));
        }
        return true;
    }

    Uuid id() {
        return this.id;
    }

    void pickID() {
        if (this.id != null) {
            throw new IllegalStateException("pickID called more than once");
        }
        this.id = UuidFactory.generate();
    }

    public MarshalledInstance value(int fieldNum) {
        return this.values[fieldNum];
    }

    public int numFields() {
        if (this.values != null) {
            return this.values.length;
        }
        return 0;
    }

    public String classFor() {
        return this.className;
    }

    public String[] superclasses() {
        return this.superclasses;
    }

    long getHash() {
        return this.hash;
    }

    long[] getHashes() {
        return this.hashes;
    }

    boolean matches(EntryRep other) {
        if (EntryRep.isMatchAny(this)) {
            return true;
        }
        for (int f = 0; f < this.values.length; ++f) {
            if (this.values[f] == null || this.values[f].equals(other.values[f])) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        return "EntryRep[" + this.className + "]";
    }

    boolean isAtLeastA(String otherClass) {
        if (otherClass.equals(EntryRep.matchAnyClassName())) {
            return true;
        }
        if (this.className.equals(otherClass)) {
            return true;
        }
        for (int i = 0; i < this.superclasses.length; ++i) {
            if (!this.superclasses[i].equals(otherClass)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.className == null) {
            throw new InvalidObjectException("null className");
        }
        if (this.values == null) {
            throw new InvalidObjectException("null values");
        }
        if (this.superclasses == null) {
            throw new InvalidObjectException("null superclasses");
        }
        if (this.hashes == null) {
            throw new InvalidObjectException("null hashes");
        }
        if (this.hashes.length != this.superclasses.length) {
            throw new InvalidObjectException("hashes.length (" + this.hashes.length + ") does not equal  superclasses.length (" + this.superclasses.length + ")");
        }
        this.integrity = MarshalledWrapper.integrityEnforced(in);
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("SpaceProxy should always have data");
    }

    @Override
    public void setExpiration(long newExpiration) {
        this.expires = newExpiration;
    }

    @Override
    public long getExpiration() {
        return this.expires;
    }

    @Override
    public Uuid getCookie() {
        return this.id;
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        long bits1;
        long bits0;
        if (this.id == null) {
            bits0 = 0L;
            bits1 = 0L;
        } else {
            bits0 = this.id.getMostSignificantBits();
            bits1 = this.id.getLeastSignificantBits();
        }
        out.writeLong(bits0);
        out.writeLong(bits1);
        out.writeLong(this.expires);
        out.writeObject(this.codebase);
        out.writeObject(this.className);
        out.writeObject(this.superclasses);
        out.writeObject(this.values);
        out.writeLong(this.hash);
        out.writeObject(this.hashes);
    }

    @Override
    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        long bits0 = in.readLong();
        long bits1 = in.readLong();
        this.id = bits0 == 0L && bits1 == 0L ? null : UuidFactory.create(bits0, bits1);
        this.expires = in.readLong();
        this.codebase = (String)in.readObject();
        this.className = (String)in.readObject();
        this.superclasses = (String[])in.readObject();
        this.values = (MarshalledInstance[])in.readObject();
        this.hash = in.readLong();
        this.hashes = (long[])in.readObject();
    }

    private static RuntimeException throwRuntime(RuntimeException e) {
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, e.getMessage(), e);
        }
        throw e;
    }

    private static MarshalException throwNewMarshalException(String msg, Exception nested) throws MarshalException {
        MarshalException me = new MarshalException(msg, nested);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, msg, me);
        }
        throw me;
    }

    private UnusableEntryException throwNewUnusableEntryException(Entry partial, String[] badFields, Throwable[] exceptions) throws UnusableEntryException {
        UnusableEntryException uee = new UnusableEntryException(partial, badFields, exceptions);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, "failure constructing entry of type " + this.className, uee);
        }
        throw uee;
    }

    private static UnusableEntryException throwNewUnusableEntryException(Throwable nested) throws UnusableEntryException {
        UnusableEntryException uee = new UnusableEntryException(nested);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, nested.getMessage(), uee);
        }
        throw uee;
    }

    private static UnusableEntryException throwNewUnusableEntryException(String msg, Exception nested) throws UnusableEntryException {
        UnmarshalException ue = new UnmarshalException(msg, nested);
        UnusableEntryException uee = new UnusableEntryException(ue);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, msg, uee);
        }
        throw uee;
    }

    static {
        try {
            matchAnyRep = new EntryRep(new Entry(){
                static final long serialVersionUID = -4244768995726274609L;
            }, false);
        }
        catch (MarshalException e) {
            throw new AssertionError((Object)e);
        }
        logger = Logger.getLogger("com.sun.jini.outrigger.proxy");
        noArg = new Class[0];
    }

    private static class FieldComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Field f1 = (Field)o1;
            Field f2 = (Field)o2;
            if (f1 == f2) {
                return 0;
            }
            if (f1.getDeclaringClass() == f2.getDeclaringClass()) {
                return f1.getName().compareTo(f2.getName());
            }
            if (f1.getDeclaringClass().isAssignableFrom(f2.getDeclaringClass())) {
                return -1;
            }
            return 1;
        }
    }
}

