/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.config.Config;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.LogOps;
import com.sun.jini.outrigger.StorableObject;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.rmi.MarshalledObject;
import java.rmi.RemoteException;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.lookup.ServiceID;
import net.jini.discovery.DiscoveryGroupManagement;
import net.jini.discovery.DiscoveryLocatorManagement;
import net.jini.discovery.DiscoveryManagement;
import net.jini.discovery.LookupDiscoveryManager;
import net.jini.lookup.JoinManager;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;

class JoinStateManager
implements StorableObject {
    private ProxyPreparer lookupLocatorPreparer;
    private DiscoveryGroupManagement dgm;
    private JoinManager mgr;
    private LogOps log;
    private Entry[] attributes;
    private LookupLocator[] locators;
    private String[] groups;
    private boolean initial = true;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.join");

    JoinStateManager() {
    }

    void startManager(Configuration config, LogOps log, Object service, ServiceID serviceID, Entry[] baseAttributes) throws IOException, ConfigurationException {
        BasicProxyPreparer defaultPreparer = new BasicProxyPreparer();
        if (serviceID == null) {
            throw new NullPointerException("serviceID can't be null");
        }
        this.log = log;
        this.lookupLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "lookupLocatorPreparer", ProxyPreparer.class, defaultPreparer);
        this.dgm = (DiscoveryGroupManagement)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "discoveryManager", DiscoveryGroupManagement.class, new LookupDiscoveryManager(DiscoveryGroupManagement.NO_GROUPS, null, null, config));
        if (!(this.dgm instanceof DiscoveryManagement)) {
            throw JoinStateManager.throwNewConfigurationException("Entry for component com.sun.jini.outrigger, name discoveryManager must implement net.jini.discovery.DiscoveryGroupManagement");
        }
        if (!(this.dgm instanceof DiscoveryLocatorManagement)) {
            throw JoinStateManager.throwNewConfigurationException("Entry for component com.sun.jini.outrigger, name discoveryManager must implement net.jini.discovery.DiscoveryLocatorManagement");
        }
        String[] toCheck = this.dgm.getGroups();
        if (toCheck == null || toCheck.length != 0) {
            throw JoinStateManager.throwNewConfigurationException("Entry for component com.sun.jini.outrigger, name discoveryManager must be initially configured with no groups");
        }
        if (((DiscoveryLocatorManagement)((Object)this.dgm)).getLocators().length != 0) {
            throw JoinStateManager.throwNewConfigurationException("Entry for component com.sun.jini.outrigger, name discoveryManager must be initially configured with no locators");
        }
        if (this.initial) {
            this.groups = (String[])config.getEntry("com.sun.jini.outrigger", "initialLookupGroups", String[].class, new String[]{""});
            this.locators = (LookupLocator[])Config.getNonNullEntry(config, "com.sun.jini.outrigger", "initialLookupLocators", LookupLocator[].class, new LookupLocator[0]);
            Entry[] cAttrs = (Entry[])Config.getNonNullEntry(config, "com.sun.jini.outrigger", "initialLookupAttributes", Entry[].class, new Entry[0]);
            if (cAttrs.length == 0) {
                this.attributes = baseAttributes;
            } else {
                this.attributes = new Entry[cAttrs.length + baseAttributes.length];
                System.arraycopy(baseAttributes, 0, this.attributes, 0, baseAttributes.length);
                System.arraycopy(cAttrs, 0, this.attributes, baseAttributes.length, cAttrs.length);
            }
        } else if (this.locators.length > 0) {
            ProxyPreparer recoveredLookupLocatorPreparer = (ProxyPreparer)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "recoveredLookupLocatorPreparer", ProxyPreparer.class, defaultPreparer);
            LinkedList<Object> prepared = new LinkedList<Object>();
            for (int i = 0; i < this.locators.length; ++i) {
                LookupLocator locator = this.locators[i];
                try {
                    prepared.add(recoveredLookupLocatorPreparer.prepareProxy(locator));
                    continue;
                }
                catch (Throwable t) {
                    logger.log(Level.INFO, "Encountered exception preparing lookup locator for " + locator + ", dropping locator", t);
                }
            }
            this.locators = prepared.toArray(new LookupLocator[0]);
        }
        if (logger.isLoggable(Level.CONFIG)) {
            StringBuffer buf;
            if (this.groups == null) {
                logger.log(Level.CONFIG, "joining all groups");
            } else if (this.groups.length == 0) {
                logger.log(Level.CONFIG, "joining no groups");
            } else {
                buf = new StringBuffer();
                buf.append("joining groups:");
                for (int i = 0; i < this.groups.length; ++i) {
                    if (i != 0) {
                        buf.append(",");
                    }
                    buf.append("\"");
                    buf.append(this.groups[i]);
                    buf.append("\"");
                }
                logger.log(Level.CONFIG, buf.toString());
            }
            if (this.locators.length == 0) {
                logger.log(Level.CONFIG, "joining no specific registrars");
            } else {
                buf = new StringBuffer();
                buf.append("joining the specific registrars:");
                for (int i = 0; i < this.locators.length; ++i) {
                    if (i != 0) {
                        buf.append(", ");
                    }
                    buf.append(this.locators[i]);
                }
                logger.log(Level.CONFIG, buf.toString());
            }
            if (this.attributes.length == 0) {
                logger.log(Level.CONFIG, "registering no attributes");
            } else {
                buf = new StringBuffer();
                buf.append("registering the attributes:");
                for (int i = 0; i < this.attributes.length; ++i) {
                    if (i != 0) {
                        buf.append(", ");
                    }
                    buf.append(this.attributes[i]);
                }
                logger.log(Level.CONFIG, buf.toString());
            }
        }
        this.dgm.setGroups(this.groups);
        ((DiscoveryLocatorManagement)((Object)this.dgm)).setLocators(this.locators);
        this.mgr = new JoinManager(service, this.attributes, serviceID, (DiscoveryManagement)((Object)this.dgm), null, config);
        this.attributes = null;
        this.groups = null;
        this.locators = null;
        this.update();
    }

    public void destroy() {
        if (this.mgr != null) {
            this.mgr.terminate();
        }
        if (this.dgm != null) {
            ((DiscoveryManagement)((Object)this.dgm)).terminate();
        }
    }

    public Entry[] getLookupAttributes() {
        return this.mgr.getAttributes();
    }

    public void addLookupAttributes(Entry[] attrSets) {
        this.mgr.addAttributes(attrSets, true);
        this.update();
    }

    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        this.mgr.modifyAttributes(attrSetTemplates, attrSets, true);
        this.update();
    }

    public String[] getLookupGroups() {
        return this.dgm.getGroups();
    }

    public void addLookupGroups(String[] groups) {
        try {
            this.dgm.addGroups(groups);
        }
        catch (IOException e) {
            throw JoinStateManager.propagateIOException("Could not change groups", e);
        }
        this.update();
    }

    public void removeLookupGroups(String[] groups) {
        this.dgm.removeGroups(groups);
        this.update();
    }

    public void setLookupGroups(String[] groups) {
        try {
            this.dgm.setGroups(groups);
        }
        catch (IOException e) {
            throw JoinStateManager.propagateIOException("Could not change groups", e);
        }
        this.update();
    }

    public LookupLocator[] getLookupLocators() {
        return ((DiscoveryLocatorManagement)((Object)this.dgm)).getLocators();
    }

    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dgm)).addLocators(locators);
        this.update();
    }

    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dgm)).removeLocators(locators);
        this.update();
    }

    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        this.prepareLocators(locators);
        ((DiscoveryLocatorManagement)((Object)this.dgm)).setLocators(locators);
        this.update();
    }

    private void update() {
        if (this.log != null) {
            this.log.joinStateOp(this);
        }
    }

    private void prepareLocators(LookupLocator[] locators) throws RemoteException {
        for (int i = 0; i < locators.length; ++i) {
            locators[i] = (LookupLocator)this.lookupLocatorPreparer.prepareProxy(locators[i]);
        }
    }

    private static void writeAttributes(Entry[] attributes, ObjectOutputStream out) throws IOException {
        out.writeInt(attributes.length);
        for (int i = 0; i < attributes.length; ++i) {
            out.writeObject(new MarshalledObject<Entry>(attributes[i]));
        }
    }

    private static Entry[] readAttributes(ObjectInputStream in) throws IOException, ClassNotFoundException {
        LinkedList entries = new LinkedList();
        int objectCount = in.readInt();
        for (int i = 0; i < objectCount; ++i) {
            try {
                MarshalledObject mo = (MarshalledObject)in.readObject();
                entries.add(mo.get());
                continue;
            }
            catch (IOException e) {
                logger.log(Level.INFO, "Encountered IOException recovering attribute, dropping attribute", e);
                continue;
            }
            catch (ClassNotFoundException e) {
                logger.log(Level.INFO, "Encountered ClassNotFoundException recovering attribute, dropping attribute", e);
            }
        }
        return entries.toArray(new Entry[0]);
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        JoinStateManager.writeAttributes(this.mgr.getAttributes(), out);
        out.writeObject(((DiscoveryLocatorManagement)((Object)this.dgm)).getLocators());
        out.writeObject(this.dgm.getGroups());
    }

    @Override
    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.initial = false;
        this.attributes = JoinStateManager.readAttributes(in);
        this.locators = (LookupLocator[])in.readObject();
        this.groups = (String[])in.readObject();
    }

    private static ConfigurationException throwNewConfigurationException(String msg) throws ConfigurationException {
        ConfigurationException e = new ConfigurationException(msg);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, msg, e);
        }
        throw e;
    }

    private static RuntimeException propagateIOException(String msg, IOException nested) {
        RuntimeException e = new RuntimeException(msg, nested);
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, msg, e);
        }
        throw e;
    }
}

