/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.config.Config;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.landlord.FixedLeasePeriodPolicy;
import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordUtil;
import com.sun.jini.landlord.LeaseFactory;
import com.sun.jini.landlord.LeasePeriodPolicy;
import com.sun.jini.landlord.LeasedResource;
import com.sun.jini.landlord.LocalLandlord;
import com.sun.jini.logging.Levels;
import com.sun.jini.lookup.entry.BasicServiceType;
import com.sun.jini.outrigger.AdminProxy;
import com.sun.jini.outrigger.AvailabilityRegistrationWatcher;
import com.sun.jini.outrigger.ConstrainableAdminProxy;
import com.sun.jini.outrigger.ConstrainableParticipantProxy;
import com.sun.jini.outrigger.ConstrainableSpaceProxy2;
import com.sun.jini.outrigger.ConsumingWatcher;
import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.EntryHolder;
import com.sun.jini.outrigger.EntryHolderSet;
import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.EventRegistrationRecord;
import com.sun.jini.outrigger.EventRegistrationWatcher;
import com.sun.jini.outrigger.EventSender;
import com.sun.jini.outrigger.ExpirationOpQueue;
import com.sun.jini.outrigger.IfExistsWatcher;
import com.sun.jini.outrigger.JoinStateManager;
import com.sun.jini.outrigger.LogOps;
import com.sun.jini.outrigger.MatchSetData;
import com.sun.jini.outrigger.Notifier;
import com.sun.jini.outrigger.OperationJournal;
import com.sun.jini.outrigger.OutriggerQueryCookie;
import com.sun.jini.outrigger.OutriggerServer;
import com.sun.jini.outrigger.OutriggerServerWrapper;
import com.sun.jini.outrigger.ParticipantProxy;
import com.sun.jini.outrigger.ProxyVerifier;
import com.sun.jini.outrigger.QueryWatcher;
import com.sun.jini.outrigger.ReadIfExistsWatcher;
import com.sun.jini.outrigger.ReadWatcher;
import com.sun.jini.outrigger.Recover;
import com.sun.jini.outrigger.RepEnum;
import com.sun.jini.outrigger.SingletonQueryWatcher;
import com.sun.jini.outrigger.SpaceProxy2;
import com.sun.jini.outrigger.StorableAvailabilityWatcher;
import com.sun.jini.outrigger.StorableEventWatcher;
import com.sun.jini.outrigger.StorableObject;
import com.sun.jini.outrigger.StorableResource;
import com.sun.jini.outrigger.Store;
import com.sun.jini.outrigger.StoredObject;
import com.sun.jini.outrigger.StoredResource;
import com.sun.jini.outrigger.TakeIfExistsWatcher;
import com.sun.jini.outrigger.TakeMultipleWatcher;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableAvailabilityWatcher;
import com.sun.jini.outrigger.TransactableEventWatcher;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.TransactableReadIfExistsWatcher;
import com.sun.jini.outrigger.TransitionWatcher;
import com.sun.jini.outrigger.TransitionWatchers;
import com.sun.jini.outrigger.Txn;
import com.sun.jini.outrigger.TxnMonitor;
import com.sun.jini.outrigger.TxnTable;
import com.sun.jini.outrigger.TypeTree;
import com.sun.jini.start.LifeCycle;
import java.io.IOException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.Subject;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import net.jini.activation.ActivationExporter;
import net.jini.activation.ActivationGroup;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.config.ConfigurationProvider;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.core.discovery.LookupLocator;
import net.jini.core.entry.Entry;
import net.jini.core.event.EventRegistration;
import net.jini.core.event.RemoteEventListener;
import net.jini.core.lease.LeaseDeniedException;
import net.jini.core.lease.UnknownLeaseException;
import net.jini.core.lookup.ServiceID;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.CannotNestException;
import net.jini.core.transaction.Transaction;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.export.Exporter;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicJeriExporter;
import net.jini.jeri.tcp.TcpServerEndpoint;
import net.jini.lookup.entry.ServiceInfo;
import net.jini.security.BasicProxyPreparer;
import net.jini.security.ProxyPreparer;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.ServerProxyTrust;
import net.jini.space.InternalSpaceException;
import net.jini.space.JavaSpace;

public class OutriggerServerImpl
implements OutriggerServer,
TimeConstants,
LocalLandlord,
Recover,
ServerProxyTrust {
    public static final String COMPONENT_NAME = "com.sun.jini.outrigger";
    static final String lifecycleLoggerName = "com.sun.jini.outrigger.lifecycle";
    static final String opsLoggerName = "com.sun.jini.outrigger.operations";
    static final String txnLoggerName = "com.sun.jini.outrigger.transactions";
    static final String leaseLoggerName = "com.sun.jini.outrigger.leases";
    static final String iteratorLoggerName = "com.sun.jini.outrigger.iterator";
    static final String joinLoggerName = "com.sun.jini.outrigger.join";
    static final String matchingLoggerName = "com.sun.jini.outrigger.entryMatching";
    static final String eventLoggerName = "com.sun.jini.outrigger.event";
    public static final String storeLoggerName = "com.sun.jini.outrigger.store";
    private static final Logger lifecycleLogger = Logger.getLogger("com.sun.jini.outrigger.lifecycle");
    private static final Logger opsLogger = Logger.getLogger("com.sun.jini.outrigger.operations");
    private static final Logger txnLogger = Logger.getLogger("com.sun.jini.outrigger.transactions");
    private static final Logger leaseLogger = Logger.getLogger("com.sun.jini.outrigger.leases");
    private static final Logger iteratorLogger = Logger.getLogger("com.sun.jini.outrigger.iterator");
    private static final Logger joinLogger = Logger.getLogger("com.sun.jini.outrigger.join");
    public static final String PERSISTENCE_DIR_CONFIG_ENTRY = "persistenceDirectory";
    private EntryHolderSet contents;
    private final TypeTree types;
    private final HashMap typeHashes;
    private TransitionWatchers templates;
    private final Map eventRegistrations;
    private final Map contentsQueries;
    private Map recoveredTxns;
    private TxnTable txnTable;
    private final long crashCount;
    private TemplateReaper templateReaperThread;
    private EntryReaper entryReaperThread;
    private ContentsQueryReaper contentsQueryReaperThread;
    private OperationJournal operationJournal;
    private Notifier notifier;
    private ExpirationOpQueue expirationOpQueue;
    private TxnMonitor txnMonitor;
    private final OutriggerServerWrapper serverGate;
    private final LifeCycle lifeCycle;
    private Exporter exporter;
    private OutriggerServer ourRemoteRef;
    private Uuid topUuid;
    private SpaceProxy2 spaceProxy;
    private AdminProxy adminProxy;
    private ParticipantProxy participantProxy;
    private long sessionId;
    private LeasePeriodPolicy entryLeasePolicy;
    private LeasePeriodPolicy eventLeasePolicy;
    private LeasePeriodPolicy contentsLeasePolicy;
    private LeaseFactory leaseFactory;
    private JoinStateManager joinStateManager;
    private static final SecureRandom idGen = new SecureRandom();
    private ActivationID activationID;
    private ActivationSystem activationSystem;
    private Store store;
    private LogOps log;
    private final Map iterations;
    private final LoginContext loginContext;
    private ProxyPreparer transactionManagerPreparer;
    private ProxyPreparer listenerPreparer;
    private ProxyPreparer recoveredTransactionManagerPreparer;
    private ProxyPreparer recoveredListenerPreparer;
    private int nextLimit;
    private int takeLimit;
    private long maxUnexportDelay;
    private long unexportRetryDelay;

    OutriggerServerImpl(ActivationID activationID, LifeCycle lifeCycle, String[] configArgs, final boolean persistent, OutriggerServerWrapper wrapper) throws IOException, ConfigurationException, LoginException, ActivationException {
        block9: {
            this.types = new TypeTree();
            this.typeHashes = new HashMap();
            this.eventRegistrations = Collections.synchronizedMap(new HashMap());
            this.contentsQueries = Collections.synchronizedMap(new HashMap());
            this.crashCount = System.currentTimeMillis();
            this.topUuid = null;
            this.sessionId = 0L;
            this.joinStateManager = new JoinStateManager();
            this.iterations = Collections.synchronizedMap(new HashMap());
            this.lifeCycle = lifeCycle;
            this.activationID = activationID;
            this.serverGate = wrapper;
            try {
                final Configuration config = ConfigurationProvider.getInstance(configArgs, this.getClass().getClassLoader());
                this.loginContext = (LoginContext)config.getEntry(COMPONENT_NAME, "loginContext", LoginContext.class, null);
                if (this.loginContext == null) {
                    this.init(config, persistent);
                    break block9;
                }
                this.loginContext.login();
                try {
                    Subject.doAsPrivileged(this.loginContext.getSubject(), new PrivilegedExceptionAction(){

                        public Object run() throws Exception {
                            OutriggerServerImpl.this.init(config, persistent);
                            return null;
                        }
                    }, null);
                }
                catch (PrivilegedActionException e) {
                    throw e.getCause();
                }
            }
            catch (IOException e) {
                this.unwindConstructor(e);
                throw e;
            }
            catch (ConfigurationException e) {
                this.unwindConstructor(e);
                throw e;
            }
            catch (LoginException e) {
                this.unwindConstructor(e);
                throw e;
            }
            catch (RuntimeException e) {
                this.unwindConstructor(e);
                throw e;
            }
            catch (Throwable e) {
                this.unwindConstructor(e);
                throw (Error)e;
            }
        }
        lifecycleLogger.log(Level.INFO, "Outrigger server started: {0}", this);
    }

    private void init(Configuration config, boolean persistent) throws IOException, ConfigurationException, ActivationException {
        this.txnMonitor = new TxnMonitor(this, config);
        BasicProxyPreparer defaultPreparer = new BasicProxyPreparer();
        if (this.activationID != null) {
            ProxyPreparer aidPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "activationIdPreparer", ProxyPreparer.class, defaultPreparer);
            ProxyPreparer aSysPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "activationSystemPreparer", ProxyPreparer.class, defaultPreparer);
            this.activationID = (ActivationID)aidPreparer.prepareProxy(this.activationID);
            this.activationSystem = (ActivationSystem)aSysPreparer.prepareProxy(ActivationGroup.getSystem());
        }
        this.transactionManagerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "transactionManagerPreparer", ProxyPreparer.class, defaultPreparer);
        this.listenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "listenerPreparer", ProxyPreparer.class, defaultPreparer);
        BasicJeriExporter basicExporter = new BasicJeriExporter(TcpServerEndpoint.getInstance(0), new BasicILFactory(), false, true);
        this.exporter = this.activationID == null ? (Exporter)Config.getNonNullEntry(config, COMPONENT_NAME, "serverExporter", Exporter.class, basicExporter) : (Exporter)Config.getNonNullEntry(config, COMPONENT_NAME, "serverExporter", Exporter.class, new ActivationExporter(this.activationID, basicExporter), this.activationID);
        this.ourRemoteRef = (OutriggerServer)this.exporter.export(this.serverGate);
        long maxServerQueryTimeout = Config.getLongEntry(config, COMPONENT_NAME, "maxServerQueryTimeout", Long.MAX_VALUE, 1L, Long.MAX_VALUE);
        this.contents = new EntryHolderSet(this);
        this.templates = new TransitionWatchers(this);
        new Thread(){

            @Override
            public void run() {
                OutriggerServerImpl.nextID();
            }
        }.start();
        this.operationJournal = new OperationJournal(this.templates);
        this.log = null;
        if (persistent) {
            this.store = (Store)Config.getNonNullEntry(config, COMPONENT_NAME, "store", Store.class);
            this.expirationOpQueue = new ExpirationOpQueue(this);
            this.expirationOpQueue.setDaemon(true);
            this.expirationOpQueue.start();
            this.recoveredTransactionManagerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "recoveredTransactionManagerPreparer", ProxyPreparer.class, defaultPreparer);
            this.recoveredListenerPreparer = (ProxyPreparer)Config.getNonNullEntry(config, COMPONENT_NAME, "recoveredListenerPreparer", ProxyPreparer.class, defaultPreparer);
        }
        this.txnTable = new TxnTable(this.recoveredTransactionManagerPreparer);
        if (this.store != null) {
            this.log = this.store.setupStore(this);
            this.log.bootOp(System.currentTimeMillis(), this.getSessionId());
            this.recoverTxns();
        } else if (this.activationID != null || persistent) {
            throw new ConfigurationException("Must provide for a store for component com.sun.jini.outrigger, by providing valid values for the store or persistenceDirectory entries if creating  a persistent space");
        }
        if (this.topUuid == null) {
            this.topUuid = UuidFactory.generate();
            if (this.log != null) {
                this.log.uuidOp(this.topUuid);
            }
        }
        if (this.ourRemoteRef instanceof RemoteMethodControl) {
            this.spaceProxy = new ConstrainableSpaceProxy2(this.ourRemoteRef, this.topUuid, maxServerQueryTimeout, null);
            this.adminProxy = new ConstrainableAdminProxy(this.ourRemoteRef, this.topUuid, null);
            this.participantProxy = new ConstrainableParticipantProxy(this.ourRemoteRef, this.topUuid, null);
        } else {
            this.spaceProxy = new SpaceProxy2(this.ourRemoteRef, this.topUuid, maxServerQueryTimeout);
            this.adminProxy = new AdminProxy(this.ourRemoteRef, this.topUuid);
            this.participantProxy = new ParticipantProxy(this.ourRemoteRef, this.topUuid);
        }
        this.leaseFactory = new LeaseFactory(this.ourRemoteRef, this.topUuid);
        this.entryLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, COMPONENT_NAME, "entryLeasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(Long.MAX_VALUE, 86400000L));
        this.eventLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, COMPONENT_NAME, "eventLeasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(3600000L, 3600000L));
        this.contentsLeasePolicy = (LeasePeriodPolicy)Config.getNonNullEntry(config, COMPONENT_NAME, "contentsLeasePeriodPolicy", LeasePeriodPolicy.class, new FixedLeasePeriodPolicy(3600000L, 3600000L));
        this.nextLimit = Config.getIntEntry(config, COMPONENT_NAME, "iteratorBatchSize", 100, 1, Integer.MAX_VALUE);
        this.takeLimit = Config.getIntEntry(config, COMPONENT_NAME, "takeMultipleLimit", 100, 1, Integer.MAX_VALUE);
        this.maxUnexportDelay = Config.getLongEntry(config, COMPONENT_NAME, "maxUnexportDelay", 120000L, 0L, Long.MAX_VALUE);
        this.unexportRetryDelay = Config.getLongEntry(config, COMPONENT_NAME, "unexportRetryDelay", 1000L, 1L, Long.MAX_VALUE);
        this.joinStateManager.startManager(config, this.log, this.spaceProxy, new ServiceID(this.topUuid.getMostSignificantBits(), this.topUuid.getLeastSignificantBits()), OutriggerServerImpl.attributesFor());
        this.operationJournal.setDaemon(true);
        this.operationJournal.start();
        this.notifier = new Notifier(this.spaceProxy, this.recoveredListenerPreparer, config);
        long reapingInterval = Config.getLongEntry(config, COMPONENT_NAME, "reapingInterval", 10000L, 1L, Long.MAX_VALUE);
        int reapingPriority = Config.getIntEntry(config, COMPONENT_NAME, "reapingPriority", 5, 1, 10);
        this.templateReaperThread = new TemplateReaper(reapingInterval);
        this.templateReaperThread.setPriority(reapingPriority);
        this.templateReaperThread.setDaemon(true);
        this.templateReaperThread.start();
        this.entryReaperThread = new EntryReaper(reapingInterval);
        this.entryReaperThread.setPriority(reapingPriority);
        this.entryReaperThread.setDaemon(true);
        this.entryReaperThread.start();
        this.contentsQueryReaperThread = new ContentsQueryReaper(reapingInterval);
        this.contentsQueryReaperThread.setPriority(reapingPriority);
        this.contentsQueryReaperThread.setDaemon(true);
        this.contentsQueryReaperThread.start();
    }

    private void unwindConstructor(Throwable cause) {
        this.serverGate.rejectCalls(new RemoteException("Constructor failure", cause));
        lifecycleLogger.log(Level.SEVERE, "exception encountered while (re)starting server", cause);
        try {
            this.joinStateManager.destroy();
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (this.ourRemoteRef != null) {
            try {
                this.exporter.unexport(true);
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.expirationOpQueue != null) {
            this.expirationOpQueue.terminate();
        }
        if (this.txnMonitor != null) {
            try {
                this.txnMonitor.destroy();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.notifier != null) {
            try {
                this.notifier.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        if (this.operationJournal != null) {
            try {
                this.operationJournal.terminate();
            }
            catch (Throwable t) {
                // empty catch block
            }
        }
        this.unwindReaper(this.templateReaperThread);
        this.unwindReaper(this.entryReaperThread);
        this.unwindReaper(this.contentsQueryReaperThread);
        if (this.store != null) {
            try {
                this.store.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void unwindReaper(Reaper r) {
        if (r == null) {
            return;
        }
        try {
            r.kill();
            r.join();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void recoverTxns() {
        if (this.recoveredTxns == null) {
            return;
        }
        Collection values = this.recoveredTxns.values();
        Iterator t = values.iterator();
        while (t.hasNext()) {
            this.txnTable.recover((Txn)t.next());
        }
        this.monitor(values);
        this.recoveredTxns = null;
    }

    long getSessionId() {
        return this.sessionId;
    }

    void cancelOp(Uuid cookie, boolean expired) {
        if (this.log != null) {
            this.log.cancelOp(cookie, expired);
        }
    }

    void scheduleCancelOp(Uuid cookie) {
        if (this.expirationOpQueue != null) {
            this.expirationOpQueue.enqueue(cookie);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void typeCheck(EntryRep rep) throws UnmarshalException {
        if (rep == null) {
            return;
        }
        HashMap hashMap = this.typeHashes;
        synchronized (hashMap) {
            if (this.checkClass(rep.classFor(), rep.getHash())) {
                return;
            }
            String[] superclasses = rep.superclasses();
            long[] hashes = rep.getHashes();
            for (int i = 0; i < superclasses.length; ++i) {
                if (!this.checkClass(superclasses[i], hashes[i])) continue;
                return;
            }
        }
    }

    private boolean checkClass(String className, long value) throws UnmarshalException {
        Long hash = (Long)this.typeHashes.get(className);
        if (hash == null) {
            this.typeHashes.put(className, value);
            return false;
        }
        if (hash != value) {
            String msg = "Class mismatch: " + className;
            UnmarshalException ue = new UnmarshalException(msg);
            opsLogger.log(Levels.FAILED, msg, ue);
            throw ue;
        }
        return true;
    }

    private LeasePeriodPolicy.Result grant(LeasedResource resource, long requestedDuration, LeasePeriodPolicy policy, String policyName) {
        LeasePeriodPolicy.Result r;
        try {
            r = policy.grant(resource, requestedDuration);
            resource.setExpiration(r.expiration);
        }
        catch (LeaseDeniedException e) {
            throw this.logAndThrow(new InternalSpaceException("OutriggerServerImpl:" + policyName + ".grant threw LeaseDeniedException", e), opsLogger);
        }
        return r;
    }

    private void checkForEmpty(EntryRep[] entries, String msg) {
        if (entries.length == 0) {
            throw this.logAndThrowIllegalArg(msg);
        }
    }

    private void checkForNull(Object value, String msg) {
        if (value == null) {
            throw this.logAndThrow(new NullPointerException(msg), opsLogger);
        }
    }

    private void checkTimeout(long timeout) {
        if (timeout < 0L) {
            throw this.logAndThrowIllegalArg("timeout = " + timeout + "must be a non-negative value");
        }
    }

    private void checkLimit(long limit) {
        if (limit < 1L) {
            throw this.logAndThrowIllegalArg("limit = " + limit + "must be a positive value");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] write(EntryRep rep, Transaction tr, long lease) throws TransactionException, RemoteException {
        opsLogger.entering("OutriggerServerImpl", "write");
        this.typeCheck(rep);
        rep.pickID();
        if (opsLogger.isLoggable(Level.FINER) && tr != null) {
            ServerTransaction str = this.serverTransaction(tr);
            opsLogger.log(Level.FINER, "OutriggerServerImpl: write under transaction [mgr:{0} id:{1}]", new Object[]{str.mgr, str.id});
        }
        Txn txn = this.enterTxn(tr);
        LeasePeriodPolicy.Result r = this.grant(rep, lease, this.entryLeasePolicy, "entryLeasePolicy");
        EntryHolder holder = this.contents.holderFor(rep);
        EntryHandle handle = new EntryHandle(rep, txn, holder);
        try {
            if (txn != null) {
                txn.ensureActive();
            }
            if (this.log != null) {
                this.log.writeOp(rep, txn == null ? null : txn.getId());
            }
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                this.addWrittenRep(handle, holder, txn);
                this.recordTransition(new EntryTransition(handle, txn, true, true, true));
            }
        }
        finally {
            if (txn != null) {
                txn.allowStateChange();
            }
        }
        if (opsLogger.isLoggable(Level.FINEST)) {
            opsLogger.log(Level.FINEST, "writing {0} (txn = {1})", new Object[]{rep, txn});
        }
        return new long[]{r.duration, rep.id().getMostSignificantBits(), rep.id().getLeastSignificantBits()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] write(EntryRep[] entries, Transaction tr, long[] leaseTimes) throws TransactionException, RemoteException {
        Object entry;
        int i;
        int i2;
        opsLogger.entering("OutriggerServerImpl", "write<multiple>");
        this.checkForEmpty(entries, "Must write at least one entry");
        if (entries.length != leaseTimes.length) {
            throw this.logAndThrowIllegalArg("Collection of entries and lease times must be same length");
        }
        for (i2 = 0; i2 < entries.length; ++i2) {
            this.checkForNull(entries[i2], "Can't write null entry");
            if (leaseTimes[i2] >= 0L || leaseTimes[i2] == -1L) continue;
            throw this.logAndThrowIllegalArg("Bad requested lease length:" + leaseTimes[i2]);
        }
        for (i2 = 0; i2 < entries.length; ++i2) {
            this.typeCheck(entries[i2]);
            entries[i2].pickID();
        }
        if (opsLogger.isLoggable(Level.FINER) && tr != null) {
            ServerTransaction str = this.serverTransaction(tr);
            opsLogger.log(Level.FINER, "OutriggerServerImpl: write<multiple> under transaction [mgr:{0} id:{1}]", new Object[]{str.mgr, str.id});
        }
        Txn txn = this.enterTxn(tr);
        LeasePeriodPolicy.Result[] leaseData = new LeasePeriodPolicy.Result[entries.length];
        EntryHolder[] holders = new EntryHolder[entries.length];
        EntryHandle[] handles = new EntryHandle[entries.length];
        for (i = 0; i < entries.length; ++i) {
            entry = entries[i];
            leaseData[i] = this.grant((LeasedResource)entry, leaseTimes[i], this.entryLeasePolicy, "entryLeasePolicy");
            holders[i] = this.contents.holderFor((EntryRep)entry);
            handles[i] = new EntryHandle((EntryRep)entry, txn, holders[i]);
        }
        try {
            if (txn != null) {
                txn.ensureActive();
            }
            if (this.log != null) {
                this.log.writeOp(entries, txn == null ? null : txn.getId());
            }
            for (i = 0; i < handles.length; ++i) {
                entry = handles[i];
                synchronized (entry) {
                    this.addWrittenRep(handles[i], holders[i], txn);
                    this.recordTransition(new EntryTransition(handles[i], txn, true, true, true));
                    continue;
                }
            }
        }
        finally {
            if (txn != null) {
                txn.allowStateChange();
            }
        }
        if (opsLogger.isLoggable(Level.FINEST)) {
            opsLogger.log(Level.FINEST, "writing multiples (txn = {0})", new Object[]{txn});
        }
        long[] rslt = new long[entries.length * 3];
        for (int i3 = 0; i3 < entries.length; ++i3) {
            rslt[i3] = leaseData[i3].duration;
            rslt[i3 + 1] = entries[i3].id().getMostSignificantBits();
            rslt[i3 + 2] = entries[i3].id().getLeastSignificantBits();
        }
        return rslt;
    }

    private void addWrittenRep(EntryHandle handle, EntryHolder holder, Txn txn) {
        opsLogger.log(Level.FINEST, "OutriggerServerImpl: addWrittenRep");
        this.types.addTypes(handle.rep());
        holder.add(handle, txn);
    }

    void recordTransition(EntryTransition transition) {
        this.operationJournal.recordTransition(transition);
    }

    void enqueueDelivery(EventSender sender) {
        this.notifier.enqueueDelivery(sender);
    }

    boolean attemptCapture(EntryHandle handle, TransactableMgr txn, boolean takeIt, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet, long now, QueryWatcher watcher) {
        HashSet conflictSet;
        EntryHolder holder = this.contents.holderFor(handle.rep());
        if (holder.attemptCapture(handle, txn, takeIt, conflictSet = new HashSet(), lockedEntrySet, provisionallyRemovedEntrySet, now)) {
            return true;
        }
        this.monitor(watcher, conflictSet);
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventRegistration notify(EntryRep tmpl, Transaction tr, RemoteEventListener listener, long leaseTime, MarshalledObject handback) throws TransactionException, RemoteException {
        opsLogger.entering("OutriggerServerImpl", "notify");
        this.typeCheck(tmpl);
        this.checkForNull(listener, "Passed null listener for event registration");
        listener = (RemoteEventListener)this.listenerPreparer.prepareProxy(listener);
        long currentOrdinal = this.operationJournal.currentOrdinal();
        tmpl = this.setupTmpl(tmpl);
        ServerTransaction str = this.serverTransaction(tr);
        Txn txn = this.enterTxn(tr);
        Uuid cookie = UuidFactory.generate();
        long eventID = OutriggerServerImpl.nextID();
        long now = System.currentTimeMillis();
        EventRegistrationWatcher reg = txn == null ? new StorableEventWatcher(now, currentOrdinal, cookie, handback, eventID, listener) : new TransactableEventWatcher(now, currentOrdinal, cookie, handback, eventID, listener, txn);
        this.grant(reg, leaseTime, this.eventLeasePolicy, "eventLeasePolicy");
        this.eventRegistrations.put(cookie, reg);
        if (txn != null) {
            try {
                txn.ensureActive();
                this.templates.add(reg, tmpl);
                txn.add((Transactable)((Object)reg));
            }
            finally {
                txn.allowStateChange();
            }
        } else {
            if (this.log != null) {
                this.log.registerOp((StorableResource)((Object)reg), "StorableEventWatcher", new StorableObject[]{tmpl});
            }
            this.templates.add(reg, tmpl);
        }
        return new EventRegistration(eventID, this.spaceProxy, this.leaseFactory.newLease(cookie, reg.getExpiration()), 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EventRegistration registerForAvailabilityEvent(EntryRep[] tmpls, Transaction tr, boolean visibilityOnly, RemoteEventListener listener, long leaseTime, MarshalledObject handback) throws TransactionException, RemoteException {
        int i;
        opsLogger.entering("OutriggerServerImpl", "registeForAvailabilityEvent");
        this.checkForNull(listener, "Passed null listener for event registration");
        this.checkForEmpty(tmpls, "Must provide at least one template");
        if (leaseTime == 0L) {
            throw this.logAndThrowIllegalArg("leaseTime must be non-zero");
        }
        listener = (RemoteEventListener)this.listenerPreparer.prepareProxy(listener);
        long currentOrdinal = this.operationJournal.currentOrdinal();
        ServerTransaction str = this.serverTransaction(tr);
        Txn txn = this.enterTxn(tr);
        for (i = 0; i < tmpls.length; ++i) {
            this.typeCheck(tmpls[i]);
        }
        for (i = 0; i < tmpls.length; ++i) {
            tmpls[i] = this.setupTmpl(tmpls[i]);
        }
        Uuid cookie = UuidFactory.generate();
        long eventID = OutriggerServerImpl.nextID();
        long now = System.currentTimeMillis();
        AvailabilityRegistrationWatcher reg = txn == null ? new StorableAvailabilityWatcher(now, currentOrdinal, cookie, visibilityOnly, handback, eventID, listener) : new TransactableAvailabilityWatcher(now, currentOrdinal, cookie, visibilityOnly, handback, eventID, listener, txn);
        this.grant(reg, leaseTime, this.eventLeasePolicy, "eventLeasePolicy");
        this.eventRegistrations.put(cookie, reg);
        if (txn != null) {
            try {
                txn.ensureActive();
                for (int i2 = 0; i2 < tmpls.length; ++i2) {
                    this.templates.add(reg, tmpls[i2]);
                }
                txn.add((Transactable)((Object)reg));
            }
            finally {
                txn.allowStateChange();
            }
        } else {
            if (this.log != null) {
                this.log.registerOp((StorableResource)((Object)reg), "StorableAvailabilityWatcher", tmpls);
            }
            for (int i3 = 0; i3 < tmpls.length; ++i3) {
                this.templates.add(reg, tmpls[i3]);
            }
        }
        return new EventRegistration(eventID, this.spaceProxy, this.leaseFactory.newLease(cookie, reg.getExpiration()), 0L);
    }

    void removeEventRegistration(EventRegistrationRecord reg) {
        this.eventRegistrations.remove(reg.getCookie());
    }

    private EntryRep setupTmpl(EntryRep tmpl) {
        if (tmpl == null) {
            tmpl = EntryRep.matchAnyEntryRep();
        }
        this.types.addTypes(tmpl);
        return tmpl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(Uuid cookie) throws UnknownLeaseException {
        leaseLogger.entering("OutriggerServerImpl", "cancel");
        EntryHandle handle = this.contents.handleFor(cookie);
        if (handle != null) {
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                if (handle.removed()) {
                    throw this.throwNewUnknownLeaseException(cookie);
                }
                if (handle.isProvisionallyRemoved()) {
                    try {
                        handle.waitOnCompleteRemoval();
                    }
                    catch (InterruptedException e) {
                        throw new AssertionError((Object)e);
                    }
                    throw this.throwNewUnknownLeaseException(cookie);
                }
                handle.provisionallyRemove();
            }
            this.cancelOp(cookie, false);
            entryHandle = handle;
            synchronized (entryHandle) {
                this.contents.remove(handle);
            }
            return;
        }
        EventRegistrationRecord reg = (EventRegistrationRecord)this.eventRegistrations.get(cookie);
        if (reg != null && reg.cancel()) {
            return;
        }
        ContentsQuery contentsQuery = (ContentsQuery)this.contentsQueries.get(cookie);
        if (contentsQuery != null && contentsQuery.cancel()) {
            return;
        }
        throw this.throwNewUnknownLeaseException(cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long renew(Uuid cookie, long extension) throws UnknownLeaseException, LeaseDeniedException {
        LeasePeriodPolicy policy;
        leaseLogger.entering("OutriggerServerImpl", "renew");
        LeasedResource resource = this.contents.getLeasedResource(cookie);
        if (null != resource) {
            policy = this.entryLeasePolicy;
        } else {
            resource = (LeasedResource)this.eventRegistrations.get(cookie);
            if (null != resource) {
                policy = this.eventLeasePolicy;
            } else {
                resource = (LeasedResource)this.contentsQueries.get(cookie);
                if (null != resource) {
                    policy = this.contentsLeasePolicy;
                } else {
                    throw this.throwNewUnknownLeaseException(cookie);
                }
            }
        }
        LeasedResource leasedResource = resource;
        synchronized (leasedResource) {
            if (resource.getExpiration() <= System.currentTimeMillis()) {
                throw this.throwNewUnknownLeaseException(cookie);
            }
            LeasePeriodPolicy.Result r = policy.renew(resource, extension);
            if (this.log != null) {
                this.log.renewOp(cookie, r.expiration);
            }
            resource.setExpiration(r.expiration);
            if (leaseLogger.isLoggable(Level.FINER)) {
                leaseLogger.log(Level.FINER, "renew({0},{1}) returns {2}", new Object[]{cookie, extension, r.duration});
            }
            return r.duration;
        }
    }

    @Override
    public Landlord.RenewResults renewAll(Uuid[] cookies, long[] extensions) {
        leaseLogger.entering("OutriggerServerImpl", "renewAll");
        if (leaseLogger.isLoggable(Level.FINER)) {
            leaseLogger.log(Level.FINER, "renewAll:{0} leases", cookies.length);
        }
        return LandlordUtil.renewAll(this, cookies, extensions);
    }

    @Override
    public Map cancelAll(Uuid[] cookies) {
        leaseLogger.entering("OutriggerServerImpl", "cancelAll");
        return LandlordUtil.cancelAll(this, cookies);
    }

    @Override
    public Object read(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "read:tmpl = {0}, timeout = {1}, cookie = {2}", new Object[]{tmpl, timeout, cookie});
        }
        return this.getMatch(tmpl, txn, timeout, false, false, cookie);
    }

    @Override
    public Object take(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "take:tmpl = {0}, timeout = {1}, cookie = {2}", new Object[]{tmpl, timeout, cookie});
        }
        return this.getMatch(tmpl, txn, timeout, true, false, cookie);
    }

    @Override
    public Object readIfExists(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "readIfExists:tmpl = {0}, timeout = {1}, cookie = {2}", new Object[]{tmpl, timeout, cookie});
        }
        return this.getMatch(tmpl, txn, timeout, false, true, cookie);
    }

    @Override
    public Object takeIfExists(EntryRep tmpl, Transaction txn, long timeout, OutriggerServer.QueryCookie cookie) throws TransactionException, RemoteException, InterruptedException {
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "takeIfExists:tmpl = {0}, timeout = {1}, cookie = {2}", new Object[]{tmpl, timeout, cookie});
        }
        return this.getMatch(tmpl, txn, timeout, true, true, cookie);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object take(EntryRep[] tmpls, Transaction tr, long timeout, int limit, OutriggerServer.QueryCookie queryCookieFromClient) throws TransactionException, RemoteException {
        long start;
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "take<multiple>:timeout = {1}, limit{2} = cookie = {3}", new Object[]{timeout, limit, queryCookieFromClient});
        }
        this.checkForEmpty(tmpls, "Must provide at least one template");
        for (int i = 0; i < tmpls.length; ++i) {
            this.typeCheck(tmpls[i]);
            if (tmpls[i] != null) continue;
            tmpls[i] = EntryRep.matchAnyEntryRep();
        }
        this.checkLimit(limit);
        this.checkTimeout(timeout);
        ServerTransaction str = this.serverTransaction(tr);
        Txn txn = this.enterTxn(tr);
        if (txn != null) {
            Txn txn2 = txn;
            synchronized (txn2) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
            }
        }
        long endTime = Long.MAX_VALUE - timeout <= (start = System.currentTimeMillis()) ? Long.MAX_VALUE : start + timeout;
        OutriggerQueryCookie queryCookie = queryCookieFromClient == null || !(queryCookieFromClient instanceof OutriggerQueryCookie) ? new OutriggerQueryCookie(start) : (OutriggerQueryCookie)queryCookieFromClient;
        OperationJournal.TransitionIterator transitionIterator = this.operationJournal.newTransitionIterator();
        HashSet classes = new HashSet();
        for (int i = 0; i < tmpls.length; ++i) {
            String whichClass = tmpls[i].classFor();
            Iterator subtypes = this.types.subTypes(whichClass);
            while (subtypes.hasNext()) {
                classes.add(subtypes.next());
            }
        }
        limit = Math.min(limit, this.takeLimit);
        EntryHandle[] handles = new EntryHandle[limit];
        int found = 0;
        HashSet conflictSet = new HashSet();
        WeakHashMap provisionallyRemovedEntrySet = new WeakHashMap();
        Iterator i = classes.iterator();
        while (i.hasNext() && found < handles.length) {
            EntryHandle handle;
            String clazz = (String)i.next();
            EntryHolder.ContinuingQuery query = this.createQuery(tmpls, clazz, txn, true, start);
            if (query == null) continue;
            while (found < handles.length && (handle = query.next(conflictSet, null, provisionallyRemovedEntrySet)) != null) {
                handles[found++] = handle;
            }
        }
        if (found > 0) {
            return this.completeTake(handles, found, txn);
        }
        long time = System.currentTimeMillis();
        if (time >= endTime) {
            this.monitor(conflictSet);
            try {
                OutriggerServerImpl.waitOnProvisionallyRemovedEntries(provisionallyRemovedEntrySet);
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            return queryCookie;
        }
        long startOrdinal = transitionIterator.currentOrdinalAtCreation();
        TakeMultipleWatcher watcher = new TakeMultipleWatcher(limit, endTime, queryCookie.startTime, startOrdinal, provisionallyRemovedEntrySet, txn);
        if (txn != null) {
            Txn txn3 = txn;
            synchronized (txn3) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
                txn.add(watcher);
            }
        }
        this.monitor(watcher, conflictSet);
        for (int i2 = 0; i2 < tmpls.length; ++i2) {
            this.templates.add(watcher, tmpls[i2]);
        }
        transitionIterator.watcherRegistered();
        EntryTransition i3 = transitionIterator.next();
        block18: while (i3 != null) {
            EntryRep rep = i3.getHandle().rep();
            for (int j = 0; j < tmpls.length; ++j) {
                EntryRep tmpl = tmpls[j];
                if (rep.isAtLeastA(tmpl.classFor()) && tmpl.matches(rep) && watcher.catchUp(i3, time)) break block18;
            }
            i3 = transitionIterator.next();
        }
        try {
            watcher.waitOnResolution();
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        handles = watcher.resolvedWithEntries();
        if (handles != null) {
            return this.completeTake(handles, handles.length, txn);
        }
        Throwable t = watcher.resolvedWithThrowable();
        if (t != null) {
            if (opsLogger.isLoggable(Levels.FAILED)) {
                opsLogger.log(Levels.FAILED, t.getMessage(), t);
            }
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            if (t instanceof TransactionException) {
                throw (TransactionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new InternalSpaceException("Query threw unexpected exception", t);
        }
        try {
            OutriggerServerImpl.waitOnProvisionallyRemovedEntries(provisionallyRemovedEntrySet);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
        return queryCookie;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryRep[] completeTake(EntryHandle[] handles, int found, Txn txn) throws TransactionException {
        int i;
        EntryRep[] reps = new EntryRep[found];
        if (this.log == null) {
            for (i = 0; i < found; ++i) {
                reps[i] = handles[i].rep();
            }
        } else {
            Uuid[] uuids = new Uuid[found];
            for (int i2 = 0; i2 < found; ++i2) {
                EntryRep rep;
                reps[i2] = rep = handles[i2].rep();
                uuids[i2] = rep.id();
            }
            if (txn == null) {
                this.log.takeOp(uuids, null);
            } else {
                try {
                    txn.ensureActive();
                    this.log.takeOp(uuids, txn.getId());
                }
                finally {
                    txn.allowStateChange();
                }
            }
        }
        if (txn == null) {
            for (i = 0; i < found; ++i) {
                EntryHandle entryHandle = handles[i];
                synchronized (entryHandle) {
                    this.contents.remove(handles[i]);
                    continue;
                }
            }
        }
        return reps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EntryRep completeTake(EntryHandle handle, Txn txn) throws TransactionException {
        EntryRep rep = handle.rep();
        if (this.log != null) {
            if (txn == null) {
                this.log.takeOp(rep.id(), null);
            } else {
                try {
                    txn.ensureActive();
                    this.log.takeOp(rep.id(), txn.getId());
                }
                finally {
                    txn.allowStateChange();
                }
            }
        }
        if (txn == null) {
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                this.contents.remove(handle);
            }
        }
        return rep;
    }

    private EntryHolder.ContinuingQuery createQuery(EntryRep[] tmpls, String clazz, Txn txn, boolean takeIt, long now) {
        EntryHolder holder = this.contents.holderFor(clazz);
        String[] supertypes = holder.supertypes();
        if (supertypes == null) {
            return null;
        }
        LinkedList<EntryRep> tmplsToCheck = new LinkedList<EntryRep>();
        block0: for (int i = 0; i < tmpls.length; ++i) {
            EntryRep tmpl = tmpls[i];
            String tmplClass = tmpl.classFor();
            if (tmplClass.equals(clazz) || tmpl == EntryRep.matchAnyEntryRep()) {
                tmplsToCheck.add(tmpl);
                continue;
            }
            for (int j = 0; j < supertypes.length; ++j) {
                if (!tmplClass.equals(supertypes[j])) continue;
                tmplsToCheck.add(tmpl);
                continue block0;
            }
        }
        return holder.continuingQuery(tmplsToCheck.toArray(new EntryRep[tmplsToCheck.size()]), txn, takeIt, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void waitOnProvisionallyRemovedEntries(WeakHashMap provisionallyRemovedEntrySet) throws InterruptedException {
        if (provisionallyRemovedEntrySet.isEmpty()) {
            return;
        }
        Set keys = provisionallyRemovedEntrySet.keySet();
        for (EntryHandle handle : keys) {
            if (handle == null) continue;
            EntryHandle entryHandle = handle;
            synchronized (entryHandle) {
                handle.waitOnCompleteRemoval();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getMatch(EntryRep tmpl, Transaction tr, long timeout, boolean takeIt, boolean ifExists, OutriggerServer.QueryCookie queryCookieFromClient) throws RemoteException, InterruptedException, TransactionException {
        EntryRep rep;
        SingletonQueryWatcher watcher;
        this.typeCheck(tmpl);
        this.checkTimeout(timeout);
        long startTime = System.currentTimeMillis();
        long endTime = Long.MAX_VALUE - timeout <= startTime ? Long.MAX_VALUE : startTime + timeout;
        Txn txn = this.enterTxn(tr);
        if (txn != null) {
            Txn txn2 = txn;
            synchronized (txn2) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
            }
        }
        OperationJournal.TransitionIterator transitionIterator = this.operationJournal.newTransitionIterator();
        if (tmpl == null) {
            tmpl = EntryRep.matchAnyEntryRep();
        }
        EntryHandle handle = null;
        HashSet conflictSet = new HashSet();
        HashSet lockedEntrySet = ifExists ? new HashSet() : null;
        WeakHashMap provisionallyRemovedEntrySet = new WeakHashMap();
        handle = this.find(tmpl, txn, takeIt, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet);
        opsLogger.log(Level.FINEST, "getMatch, initial search found {0}", handle);
        if (handle != null) {
            if (takeIt) {
                return this.completeTake(handle, txn);
            }
            return handle.rep();
        }
        if (opsLogger.isLoggable(Level.FINEST)) {
            opsLogger.log(Level.FINEST, "{0} conflicts, endTime = {1}", new Object[]{conflictSet.size(), endTime});
        }
        OutriggerQueryCookie queryCookie = queryCookieFromClient == null || !(queryCookieFromClient instanceof OutriggerQueryCookie) ? new OutriggerQueryCookie(startTime) : (OutriggerQueryCookie)queryCookieFromClient;
        long time = System.currentTimeMillis();
        if (time >= endTime) {
            this.monitor(conflictSet);
            OutriggerServerImpl.waitOnProvisionallyRemovedEntries(provisionallyRemovedEntrySet);
            return queryCookie;
        }
        long startOrdinal = transitionIterator.currentOrdinalAtCreation();
        if (!ifExists && !takeIt && txn == null) {
            watcher = new ReadWatcher(endTime, queryCookie.startTime, startOrdinal);
        } else if (ifExists && !takeIt) {
            watcher = txn == null ? new ReadIfExistsWatcher(endTime, queryCookie.startTime, startOrdinal, lockedEntrySet) : new TransactableReadIfExistsWatcher(endTime, queryCookie.startTime, startOrdinal, lockedEntrySet, provisionallyRemovedEntrySet, txn);
        } else if (!ifExists && (takeIt || txn != null)) {
            watcher = new ConsumingWatcher(endTime, queryCookie.startTime, startOrdinal, provisionallyRemovedEntrySet, txn, takeIt);
        } else if (ifExists && takeIt) {
            watcher = new TakeIfExistsWatcher(endTime, queryCookie.startTime, startOrdinal, lockedEntrySet, provisionallyRemovedEntrySet, txn);
        } else {
            throw new AssertionError((Object)"Can't create watcher for query");
        }
        if (txn != null) {
            Txn txn3 = txn;
            synchronized (txn3) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
                txn.add((Transactable)((Object)watcher));
            }
        }
        this.monitor(watcher, conflictSet);
        this.templates.add(watcher, tmpl);
        transitionIterator.watcherRegistered();
        String tmplClass = tmpl.classFor();
        EntryTransition i = transitionIterator.next();
        while (!(i == null || (rep = i.getHandle().rep()).isAtLeastA(tmplClass) && tmpl.matches(rep) && watcher.catchUp(i, time))) {
            i = transitionIterator.next();
        }
        if (ifExists) {
            this.operationJournal.markCaughtUp((IfExistsWatcher)((Object)watcher));
        }
        watcher.waitOnResolution();
        handle = watcher.resolvedWithEntry();
        if (handle != null) {
            if (takeIt) {
                return this.completeTake(handle, txn);
            }
            return handle.rep();
        }
        Throwable t = watcher.resolvedWithThrowable();
        if (t != null) {
            if (opsLogger.isLoggable(Levels.FAILED)) {
                opsLogger.log(Levels.FAILED, t.getMessage(), t);
            }
            if (t instanceof RemoteException) {
                throw (RemoteException)t;
            }
            if (t instanceof InterruptedException) {
                throw (InterruptedException)t;
            }
            if (t instanceof TransactionException) {
                throw (TransactionException)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new InternalSpaceException("Query threw unexpected exception", t);
        }
        OutriggerServerImpl.waitOnProvisionallyRemovedEntries(provisionallyRemovedEntrySet);
        if (ifExists && ((IfExistsWatcher)((Object)watcher)).isLockedEntrySetEmpty()) {
            return null;
        }
        return queryCookie;
    }

    private void monitor(QueryWatcher watcher, Collection toMonitor) {
        if (!toMonitor.isEmpty()) {
            this.txnMonitor.add(watcher, toMonitor);
        }
    }

    void monitor(Collection toMonitor) {
        if (!toMonitor.isEmpty()) {
            this.txnMonitor.add(toMonitor);
        }
    }

    void dump(String name, EntryRep rep) {
        OutriggerServerImpl.dump(this.contents.holderFor(rep), name, rep);
    }

    static void dump(EntryHolder holder, String name, EntryRep rep) {
        try {
            holder.dump(name + " " + rep.entry());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private EntryHandle find(EntryRep tmplRep, Txn txn, boolean takeIt, Set conflictSet, Set lockedEntrySet, WeakHashMap provisionallyRemovedEntrySet) throws TransactionException {
        String whichClass = tmplRep.classFor();
        Iterator subtypes = this.types.subTypes(whichClass);
        String className = null;
        EntryHandle result = null;
        boolean foundConflicts = false;
        EntryHolder holder = null;
        while (subtypes.hasNext()) {
            className = (String)subtypes.next();
            opsLogger.log(Level.FINEST, "OutriggerServerImpl: find: className = {0}", className);
            holder = this.contents.holderFor(className);
            result = holder.hasMatch(tmplRep, txn, takeIt, conflictSet, lockedEntrySet, provisionallyRemovedEntrySet);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    static long nextID() {
        return idGen.nextLong();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MatchSetData contents(EntryRep[] tmpls, Transaction tr, long leaseTime, long limit) throws TransactionException, RemoteException {
        Uuid uuid;
        ContentsQuery contentsQuery;
        EntryRep[] reps;
        if (opsLogger.isLoggable(Level.FINER)) {
            opsLogger.log(Level.FINER, "contents:tmpls = {0}, tr = {1}, leaseTime = {2}, limit = {3}", new Object[]{tmpls, tr, leaseTime, limit});
        }
        this.checkForEmpty(tmpls, "Must provide at least one template");
        this.checkLimit(limit);
        for (int i = 0; i < tmpls.length; ++i) {
            this.typeCheck(tmpls[i]);
            if (tmpls[i] != null) continue;
            tmpls[i] = EntryRep.matchAnyEntryRep();
        }
        if (leaseTime < 1L && leaseTime != -1L) {
            throw this.logAndThrowIllegalArg("leaseTime = " + leaseTime + ", must be postive or Lease.ANY");
        }
        ServerTransaction str = this.serverTransaction(tr);
        Txn txn = this.enterTxn(tr);
        if (txn != null) {
            Txn txn2 = txn;
            synchronized (txn2) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
            }
        }
        if ((reps = (contentsQuery = new ContentsQuery(uuid = UuidFactory.generate(), tmpls, txn, limit)).nextBatch(null, System.currentTimeMillis()))[reps.length - 1] == null) {
            return new MatchSetData(null, reps, -1L);
        }
        LeasePeriodPolicy.Result r = this.grant(contentsQuery, leaseTime, this.contentsLeasePolicy, "contentsLeasePolicy");
        this.contentsQueries.put(uuid, contentsQuery);
        return new MatchSetData(uuid, reps, r.duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntryRep[] nextBatch(Uuid contentsQueryUuid, Uuid entryUuid) throws NoSuchObjectException {
        opsLogger.entering("OutriggerServerImpl", "nextBatch");
        ContentsQuery contentsQuery = (ContentsQuery)this.contentsQueries.get(contentsQueryUuid);
        if (contentsQuery == null) {
            throw this.throwNewNoSuchObjectException("Unkown MatchSet", opsLogger);
        }
        long now = System.currentTimeMillis();
        ContentsQuery contentsQuery2 = contentsQuery;
        synchronized (contentsQuery2) {
            if (contentsQuery.getExpiration() <= now) {
                contentsQuery.cancel();
                this.throwNewNoSuchObjectException("Contents query expired", opsLogger);
            }
        }
        try {
            return contentsQuery.nextBatch(entryUuid, now);
        }
        catch (TransactionException e) {
            ContentsQuery contentsQuery3 = contentsQuery;
            synchronized (contentsQuery3) {
                contentsQuery.cancel();
            }
            throw this.throwNewNoSuchObjectException("Transaction no longer active", e, opsLogger);
        }
    }

    @Override
    public Object getServiceProxy() {
        opsLogger.entering("OutriggerServerImpl", "getServiceProxy");
        return this.spaceProxy;
    }

    synchronized Object getProxy() {
        return this.ourRemoteRef;
    }

    @Override
    public Object getAdmin() {
        opsLogger.entering("OutriggerServerImpl", "getAdmin");
        return this.adminProxy;
    }

    @Override
    public JavaSpace space() {
        opsLogger.entering("OutriggerServerImpl", "space");
        return this.spaceProxy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Uuid contents(EntryRep tmpl, Transaction tr) throws TransactionException, RemoteException {
        iteratorLogger.entering("OutriggerServerImpl", "contents");
        this.typeCheck(tmpl);
        ServerTransaction str = this.serverTransaction(tr);
        Txn txn = this.enterTxn(tr);
        if (txn != null) {
            Txn txn2 = txn;
            synchronized (txn2) {
                if (txn.getState() != 1) {
                    throw this.throwNewCannotJoinException();
                }
            }
        }
        Uuid uuid = UuidFactory.generate();
        this.iterations.put(uuid, new IteratorImpl(tmpl, txn));
        return uuid;
    }

    @Override
    public EntryRep[] nextReps(Uuid iterationUuid, int max, Uuid entryUuid) throws NoSuchObjectException {
        iteratorLogger.entering("OutriggerServerImpl", "nextReps");
        IteratorImpl iterImpl = (IteratorImpl)this.iterations.get(iterationUuid);
        if (iterImpl == null) {
            throw this.throwNewNoSuchObjectException("Unknown iteration", iteratorLogger);
        }
        return iterImpl.nextReps(max, entryUuid);
    }

    @Override
    public void delete(Uuid iterationUuid, Uuid entryUuid) throws NoSuchObjectException {
        iteratorLogger.entering("OutriggerServerImpl", "delete");
        IteratorImpl iterImpl = (IteratorImpl)this.iterations.get(iterationUuid);
        if (iterImpl == null) {
            throw this.throwNewNoSuchObjectException("Unknown iteration", iteratorLogger);
        }
        iterImpl.delete(entryUuid);
    }

    @Override
    public void close(Uuid iterationUuid) throws NoSuchObjectException {
        iteratorLogger.entering("OutriggerServerImpl", "close");
        IteratorImpl iterImpl = (IteratorImpl)this.iterations.remove(iterationUuid);
        if (iterImpl == null) {
            throw this.throwNewNoSuchObjectException("Unknown iteration", iteratorLogger);
        }
        iterImpl.close();
    }

    @Override
    public void destroy() {
        iteratorLogger.entering("OutriggerServerImpl", "destroy");
        this.serverGate.rejectCalls(new NoSuchObjectException("Service is destroyed"));
        new DestroyThread().start();
        lifecycleLogger.log(Level.INFO, "Outrigger server destroy thread started: {0}", this);
    }

    private void destroyReaper(Reaper r) {
        this.logDestroyPhase("stopping " + r.getName());
        r.kill();
    }

    private void joinThread(Thread t) {
        try {
            this.logDestroyPhase("joining " + t.getName());
            t.join();
        }
        catch (InterruptedException ie) {
            this.logDestroyProblem("joining " + t.getName(), ie);
        }
    }

    private void logDestroyProblem(String part, Throwable t) {
        lifecycleLogger.log(Level.INFO, "exception encountered " + part + ", continuing", t);
    }

    private void logDestroyPhase(String part) {
        if (lifecycleLogger.isLoggable(Level.FINER)) {
            lifecycleLogger.log(Level.FINER, "outrigger server:" + part + ":" + this);
        }
    }

    @Override
    public Entry[] getLookupAttributes() {
        joinLogger.entering("OutriggerServerImpl", "getLookupAttributes");
        return this.joinStateManager.getLookupAttributes();
    }

    @Override
    public void addLookupAttributes(Entry[] attrSets) {
        joinLogger.entering("OutriggerServerImpl", "addLookupAttributes");
        this.joinStateManager.addLookupAttributes(attrSets);
    }

    @Override
    public void modifyLookupAttributes(Entry[] attrSetTemplates, Entry[] attrSets) {
        joinLogger.entering("OutriggerServerImpl", "modifyLookupAttributes");
        this.joinStateManager.modifyLookupAttributes(attrSetTemplates, attrSets);
    }

    @Override
    public String[] getLookupGroups() {
        joinLogger.entering("OutriggerServerImpl", "getLookupGroups");
        return this.joinStateManager.getLookupGroups();
    }

    @Override
    public void addLookupGroups(String[] groups) {
        joinLogger.entering("OutriggerServerImpl", "addLookupGroups");
        this.joinStateManager.addLookupGroups(groups);
    }

    @Override
    public void removeLookupGroups(String[] groups) {
        joinLogger.entering("OutriggerServerImpl", "removeLookupGroups");
        this.joinStateManager.removeLookupGroups(groups);
    }

    @Override
    public void setLookupGroups(String[] groups) {
        joinLogger.entering("OutriggerServerImpl", "setLookupGroups");
        this.joinStateManager.setLookupGroups(groups);
    }

    @Override
    public LookupLocator[] getLookupLocators() {
        joinLogger.entering("OutriggerServerImpl", "getLookupLocators");
        return this.joinStateManager.getLookupLocators();
    }

    @Override
    public void addLookupLocators(LookupLocator[] locators) throws RemoteException {
        joinLogger.entering("OutriggerServerImpl", "addLookupLocators");
        this.joinStateManager.addLookupLocators(locators);
    }

    @Override
    public void removeLookupLocators(LookupLocator[] locators) throws RemoteException {
        joinLogger.entering("OutriggerServerImpl", "removeLookupLocators");
        this.joinStateManager.removeLookupLocators(locators);
    }

    @Override
    public void setLookupLocators(LookupLocator[] locators) throws RemoteException {
        joinLogger.entering("OutriggerServerImpl", "setLookupLocators");
        this.joinStateManager.setLookupLocators(locators);
    }

    @Override
    public void recoverSessionId(long sessionId) {
        long bumpValue = Integer.MAX_VALUE;
        this.sessionId = sessionId + bumpValue;
    }

    @Override
    public void recoverJoinState(StoredObject state) throws Exception {
        state.restore(this.joinStateManager);
    }

    @Override
    public void recoverWrite(StoredResource entry, Long txnId) throws Exception {
        EntryRep rep = new EntryRep();
        Txn txn = this.getRecoveredTxn(txnId);
        entry.restore(rep);
        this.typeCheck(rep);
        EntryHolder holder = this.contents.holderFor(rep);
        EntryHandle handle = new EntryHandle(rep, txn, holder);
        this.addWrittenRep(handle, holder, txn);
    }

    @Override
    public void recoverTake(Uuid cookie, Long txnId) throws Exception {
        EntryHandle handle = this.contents.handleFor(cookie);
        EntryHolder holder = this.contents.holderFor(handle.rep());
        Txn txn = this.getRecoveredTxn(txnId);
        holder.recoverTake(handle, txn);
    }

    @Override
    public void recoverTransaction(Long txnId, StoredObject transaction) throws Exception {
        Txn txn = new Txn(txnId);
        transaction.restore(txn);
        if (this.recoveredTxns == null) {
            this.recoveredTxns = new HashMap();
        }
        this.recoveredTxns.put(txnId, txn);
    }

    private Txn getRecoveredTxn(Long txnId) {
        Txn txn;
        if (txnId == null) {
            return null;
        }
        if (this.recoveredTxns == null || (txn = (Txn)this.recoveredTxns.get(txnId)) == null) {
            throw new InternalSpaceException("recover of write/take with unknown txnId");
        }
        return txn;
    }

    @Override
    public void recoverRegister(StoredResource registration, String type, StoredObject[] storedTemplates) throws Exception {
        TransitionWatcher reg;
        if (type.equals("StorableEventWatcher")) {
            assert (storedTemplates.length == 1);
            reg = new StorableEventWatcher(0L, this.operationJournal.currentOrdinal(), this.getSessionId());
        } else if (type.equals("StorableAvailabilityWatcher")) {
            reg = new StorableAvailabilityWatcher(0L, this.operationJournal.currentOrdinal(), this.getSessionId());
        } else {
            throw new AssertionError((Object)("Unknown registration type (" + type + ") while recovering event registration"));
        }
        registration.restore((StorableResource)((Object)reg));
        for (int i = 0; i < storedTemplates.length; ++i) {
            EntryRep templ = new EntryRep();
            storedTemplates[i].restore(templ);
            this.templates.add(reg, this.setupTmpl(templ));
        }
        this.eventRegistrations.put(reg.getCookie(), reg);
    }

    @Override
    public void recoverUuid(Uuid uuid) {
        this.topUuid = uuid;
    }

    @Override
    public TrustVerifier getProxyVerifier() {
        opsLogger.entering("OutriggerServerImpl", "getProxyVerifier");
        return new ProxyVerifier(this.ourRemoteRef, this.topUuid);
    }

    private Txn enterTxn(Transaction baseTr) throws TransactionException, RemoteException {
        txnLogger.entering("OutriggerServerImpl", "enterTxn");
        if (baseTr == null) {
            return null;
        }
        ServerTransaction tr = this.serverTransaction(baseTr);
        if (tr.isNested()) {
            String msg = "subtransactions not supported";
            CannotNestException cne = new CannotNestException("subtransactions not supported");
            txnLogger.log(Levels.FAILED, "subtransactions not supported", cne);
            throw cne;
        }
        Txn txn = null;
        try {
            txn = this.txnTable.get(tr.mgr, tr.id);
        }
        catch (IOException e) {
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (txn == null) {
            TransactionManager mgr = (TransactionManager)this.transactionManagerPreparer.prepareProxy(tr.mgr);
            tr = new ServerTransaction(mgr, tr.id);
            tr.join(this.participantProxy, this.crashCount);
            txn = this.txnTable.put(tr);
        }
        return txn;
    }

    private Txn getTxn(TransactionManager mgr, long id) throws UnknownTransactionException, UnmarshalException {
        Txn txn;
        try {
            txn = this.txnTable.get(mgr, id);
        }
        catch (IOException e) {
            throw this.brokenTxn(mgr, id, e);
        }
        catch (ClassNotFoundException e) {
            throw this.brokenTxn(mgr, id, e);
        }
        if (txnLogger.isLoggable(Level.FINEST)) {
            txnLogger.log(Level.FINEST, "OutriggerServerImpl: getTxn got Txn={0}", txn);
        }
        if (txn == null) {
            String msg = "unknown transaction [mgr:" + mgr + ", id:" + id + "], passed to abort/prepare/commit";
            UnknownTransactionException ute = new UnknownTransactionException(msg);
            if (txnLogger.isLoggable(Levels.FAILED)) {
                txnLogger.log(Levels.FAILED, msg, ute);
            }
            throw ute;
        }
        return txn;
    }

    private UnmarshalException brokenTxn(TransactionManager mgr, long id, Exception nested) throws UnmarshalException {
        UnmarshalException ue = new UnmarshalException("Outrigger has a transaction with this id(" + id + "), but can't" + "unmarshal its copy of manager to confirm it is the same " + "transaction", nested);
        String msg = "the unmarshalling/preparation failure of one or more transaction managers has prevented outrigger from processing an abort/prepare/commit for transaction [mgr:" + mgr + ", id:" + id + "]";
        txnLogger.log(Level.INFO, msg, ue);
        throw ue;
    }

    private ServerTransaction serverTransaction(Transaction baseTr) throws UnknownTransactionException {
        try {
            return (ServerTransaction)baseTr;
        }
        catch (ClassCastException e) {
            String msg = "unexpected transaction type:" + baseTr.getClass();
            UnknownTransactionException ute = new UnknownTransactionException(msg);
            if (txnLogger.isLoggable(Levels.FAILED)) {
                txnLogger.log(Levels.FAILED, msg, ute);
            }
            throw ute;
        }
    }

    @Override
    public int prepare(TransactionManager mgr, long id) throws UnknownTransactionException, UnmarshalException {
        int result;
        txnLogger.entering("OutriggerServerImpl", "prepare");
        Txn txn = this.getTxn(mgr, id);
        if (txn.getState() == 3) {
            return 3;
        }
        txn.makeInactive();
        if (this.log != null) {
            this.log.prepareOp(txn.getId(), txn);
        }
        if ((result = txn.prepare(this)) == 4 || result == 6) {
            if (this.log != null) {
                this.log.abortOp(txn.getId());
            }
            this.txnTable.remove(mgr, id);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit(TransactionManager mgr, long id) throws UnknownTransactionException, UnmarshalException {
        txnLogger.entering("OutriggerServerImpl", "commit");
        Txn txn = this.getTxn(mgr, id);
        txn.makeInactive();
        try {
            if (this.log != null) {
                this.log.commitOp(txn.getId());
            }
            txn.commit(this);
        }
        finally {
            this.txnTable.remove(mgr, id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void abort(TransactionManager mgr, long id) throws UnknownTransactionException, UnmarshalException {
        txnLogger.entering("OutriggerServerImpl", "abort");
        Txn txn = this.getTxn(mgr, id);
        txn.makeInactive();
        try {
            if (this.log != null) {
                this.log.abortOp(txn.getId());
            }
            txn.abort(this);
        }
        finally {
            this.txnTable.remove(mgr, id);
        }
    }

    @Override
    public int prepareAndCommit(TransactionManager mgr, long id) throws UnknownTransactionException, UnmarshalException {
        txnLogger.entering("OutriggerServerImpl", "prepareAndCommit");
        Txn txn = this.getTxn(mgr, id);
        txn.makeInactive();
        int result = txn.prepare(this);
        if (result == 3) {
            if (this.log != null) {
                this.log.commitOp(txn.getId());
            }
            txn.commit(this);
            result = 5;
        }
        this.txnTable.remove(mgr, id);
        return result;
    }

    ProxyPreparer getRecoveredTransactionManagerPreparer() {
        return this.recoveredTransactionManagerPreparer;
    }

    private final void debug(Object obj, String str) {
        String name = obj.getClass().getName();
        int dollar = name.indexOf(36);
        if (dollar > 0) {
            name = name.substring(dollar + 1);
        }
        System.out.print(name);
        System.out.print(':');
        System.out.println(str);
    }

    private static Entry[] attributesFor() {
        ServiceInfo info = new ServiceInfo("JavaSpace", "Sun Microsystems, Inc.", "Sun Microsystems, Inc.", "2.2.0", "", "");
        BasicServiceType type = new BasicServiceType("JavaSpace");
        return new Entry[]{info, type};
    }

    private RuntimeException logAndThrow(RuntimeException e, Logger logger) {
        if (logger.isLoggable(Levels.FAILED)) {
            logger.log(Levels.FAILED, e.getMessage(), e);
        }
        throw e;
    }

    private IllegalArgumentException logAndThrowIllegalArg(String msg) {
        IllegalArgumentException e = new IllegalArgumentException(msg);
        throw (IllegalArgumentException)this.logAndThrow(e, opsLogger);
    }

    private UnknownLeaseException throwNewUnknownLeaseException(Object cookie) throws UnknownLeaseException {
        UnknownLeaseException ule = new UnknownLeaseException();
        if (leaseLogger.isLoggable(Levels.FAILED)) {
            leaseLogger.log(Levels.FAILED, "unable to find lease for " + cookie, ule);
        }
        throw ule;
    }

    private CannotJoinException throwNewCannotJoinException() throws CannotJoinException {
        String msg = "transaction is not active";
        CannotJoinException cje = new CannotJoinException("transaction is not active");
        txnLogger.log(Levels.FAILED, "transaction is not active", cje);
        throw cje;
    }

    private NoSuchObjectException throwNewNoSuchObjectException(String msg, Logger logger) throws NoSuchObjectException {
        throw this.throwNewNoSuchObjectException(msg, null, logger);
    }

    private NoSuchObjectException throwNewNoSuchObjectException(String msg, Throwable t, Logger logger) throws NoSuchObjectException {
        NoSuchObjectException nsoe = new NoSuchObjectException(msg);
        nsoe.initCause(t);
        logger.log(Levels.FAILED, msg, nsoe);
        throw nsoe;
    }

    private class ContentsQueryReaper
    extends Reaper {
        private ContentsQueryReaper(long reapingInterval) {
            super("Contents Query Reaping Thread", reapingInterval);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void reap() {
            ContentsQuery[] queries;
            Map map = OutriggerServerImpl.this.contentsQueries;
            synchronized (map) {
                Collection c = OutriggerServerImpl.this.contentsQueries.values();
                queries = new ContentsQuery[c.size()];
                queries = c.toArray(queries);
            }
            long now = System.currentTimeMillis();
            for (int i = 0; i < queries.length; ++i) {
                ContentsQuery query;
                ContentsQuery contentsQuery = query = queries[i];
                synchronized (contentsQuery) {
                    if (query.getExpiration() <= now) {
                        query.cancel();
                    }
                    continue;
                }
            }
        }
    }

    private class TemplateReaper
    extends Reaper {
        private TemplateReaper(long reapingInterval) {
            super("Template Reaping Thread", reapingInterval);
        }

        @Override
        protected void reap() {
            OutriggerServerImpl.this.templates.reap();
        }
    }

    private class EntryReaper
    extends Reaper {
        private EntryReaper(long reapingInterval) {
            super("Entry Reaping Thread", reapingInterval);
        }

        @Override
        protected void reap() {
            OutriggerServerImpl.this.contents.reap();
        }
    }

    private abstract class Reaper
    extends Thread {
        private final long interval;
        private boolean dead;

        private Reaper(String name, long interval) {
            super(name);
            this.dead = false;
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            boolean goOn;
            Reaper reaper = this;
            synchronized (reaper) {
                goOn = !this.dead;
            }
            while (goOn) {
                this.reap();
                reaper = this;
                synchronized (reaper) {
                    try {
                        this.wait(this.interval);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    goOn = !this.dead;
                }
            }
        }

        abstract void reap();

        private synchronized void kill() {
            this.dead = true;
            this.notifyAll();
        }
    }

    private class IteratorImpl {
        private final EntryRep tmpl;
        private RepEnum repEnum;
        boolean closed;
        private EntryRep[] lastBatch = null;
        private Uuid lastId = null;

        IteratorImpl(EntryRep tmpl, Txn txn) {
            if (tmpl == null) {
                tmpl = EntryRep.matchAnyEntryRep();
            }
            this.tmpl = tmpl;
            this.repEnum = new AllReps(tmpl.classFor(), txn);
        }

        private void rememberLast(EntryRep[] newLast) {
            this.lastBatch = newLast;
            this.lastId = newLast == null ? null : this.lastBatch[this.lastBatch.length - 1].id();
        }

        public EntryRep[] nextReps(int max, Uuid id) {
            if (this.closed && id != null && this.lastId == null) {
                return null;
            }
            this.assertOpen();
            if (id != null && this.lastId == null) {
                throw OutriggerServerImpl.this.logAndThrow(new InternalSpaceException("First call to RemoteIter.next() should have id == null"), iteratorLogger);
            }
            if (id != null && this.lastId != null && !id.equals(this.lastId)) {
                return this.lastBatch;
            }
            if (this.repEnum == null) {
                this.close();
                return null;
            }
            if (max <= 0 && max != -1) {
                throw new AssertionError((Object)"Invalid iterator proxy");
            }
            if (max == -1) {
                max = 128;
            }
            int limit = Math.min(max, 512);
            EntryRep[] reps = new EntryRep[limit];
            int i = 0;
            while (i < reps.length) {
                reps[i] = this.repEnum.nextRep();
                if (reps[i] == null) {
                    this.repEnum = null;
                    if (i == 0) {
                        this.close();
                        return null;
                    }
                    EntryRep[] r = new EntryRep[i];
                    System.arraycopy(reps, 0, r, 0, r.length);
                    this.rememberLast(r);
                    return r;
                }
                if (!this.tmpl.matches(reps[i])) continue;
                ++i;
            }
            this.rememberLast(reps);
            return reps;
        }

        public void delete(Uuid id) {
            this.assertOpen();
            try {
                boolean found = false;
                for (int i = 0; i < this.lastBatch.length; ++i) {
                    if (!this.lastBatch[i].id().equals(id)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    throw OutriggerServerImpl.this.logAndThrow(new InternalSpaceException("Asked to delete entry not returned by last nextReps() call"), iteratorLogger);
                }
                OutriggerServerImpl.this.cancel(id);
            }
            catch (UnknownLeaseException unknownLeaseException) {
                // empty catch block
            }
        }

        public void close() {
            this.closed = true;
            this.repEnum = null;
            this.rememberLast(null);
        }

        private void assertOpen() throws IllegalStateException {
            if (this.closed) {
                throw OutriggerServerImpl.this.logAndThrow(new IllegalStateException("closed AdminIterator"), iteratorLogger);
            }
        }
    }

    private class AllReps
    implements RepEnum {
        RepEnum curEnum;
        Stack toDo = new Stack();
        Txn txn;

        AllReps(String classFor, Txn txn) {
            this.txn = txn;
            this.setup(classFor);
        }

        private void setup(String classFor) {
            if (classFor == null) {
                return;
            }
            Iterator matchingTypes = OutriggerServerImpl.this.types.subTypes(classFor);
            while (matchingTypes.hasNext()) {
                this.toDo.push((String)matchingTypes.next());
            }
            if (!this.toDo.isEmpty()) {
                this.curEnum = this.enumFor((String)this.toDo.pop());
            }
        }

        private RepEnum enumFor(String classFor) {
            EntryHolder holder = OutriggerServerImpl.this.contents.holderFor(classFor);
            return holder.contents(this.txn);
        }

        @Override
        public EntryRep nextRep() {
            while (this.curEnum != null) {
                EntryRep rep = this.curEnum.nextRep();
                if (rep != null) {
                    return rep;
                }
                if (this.toDo.isEmpty()) {
                    this.curEnum = null;
                    return null;
                }
                this.curEnum = this.enumFor((String)this.toDo.pop());
            }
            return null;
        }
    }

    private class DestroyThread
    extends Thread {
        public DestroyThread() {
            super("DestroyThread");
            this.setDaemon(false);
        }

        @Override
        public void run() {
            lifecycleLogger.log(Level.FINE, "Outrigger server destroy thread running: {0}", this);
            try {
                OutriggerServerImpl.this.logDestroyPhase("destroying JoinManager");
                OutriggerServerImpl.this.joinStateManager.destroy();
            }
            catch (Exception t) {
                OutriggerServerImpl.this.logDestroyProblem("destroying JoinManager", t);
            }
            if (OutriggerServerImpl.this.activationID != null) {
                try {
                    OutriggerServerImpl.this.logDestroyPhase("unregistering object");
                    OutriggerServerImpl.this.activationSystem.unregisterObject(OutriggerServerImpl.this.activationID);
                }
                catch (Exception t) {
                    OutriggerServerImpl.this.logDestroyProblem("unregistering server", t);
                }
            }
            OutriggerServerImpl.this.logDestroyPhase("unexporting force = false");
            long now = System.currentTimeMillis();
            long end_time = now + OutriggerServerImpl.this.maxUnexportDelay;
            if (end_time < 0L) {
                end_time = Long.MAX_VALUE;
            }
            boolean unexported = false;
            try {
                while (!unexported && now < end_time) {
                    unexported = OutriggerServerImpl.this.exporter.unexport(false);
                    if (unexported) continue;
                    try {
                        long sleepTime = Math.min(OutriggerServerImpl.this.unexportRetryDelay, end_time - now);
                        DestroyThread.sleep(sleepTime);
                        now = System.currentTimeMillis();
                    }
                    catch (InterruptedException e) {
                        OutriggerServerImpl.this.logDestroyProblem("unexport retry delay sleep", e);
                        break;
                    }
                }
            }
            catch (Throwable t) {
                OutriggerServerImpl.this.logDestroyProblem("trying \"nice\" unexport, will try forceful unexport", t);
            }
            if (!unexported) {
                OutriggerServerImpl.this.logDestroyPhase("unexporting force = true");
                try {
                    unexported = OutriggerServerImpl.this.exporter.unexport(true);
                }
                catch (Throwable t) {
                    OutriggerServerImpl.this.logDestroyProblem("trying forceful unexport", t);
                }
            }
            try {
                OutriggerServerImpl.this.logDestroyPhase("destroying txnMonitor");
                OutriggerServerImpl.this.txnMonitor.destroy();
            }
            catch (Exception t) {
                OutriggerServerImpl.this.logDestroyProblem("destroying txnMonitor", t);
            }
            try {
                OutriggerServerImpl.this.logDestroyPhase("terminating notifier");
                OutriggerServerImpl.this.notifier.terminate();
            }
            catch (Exception t) {
                OutriggerServerImpl.this.logDestroyProblem("terminating notifier ", t);
            }
            OutriggerServerImpl.this.logDestroyPhase("terminating operation journal");
            OutriggerServerImpl.this.operationJournal.terminate();
            OutriggerServerImpl.this.destroyReaper(OutriggerServerImpl.this.templateReaperThread);
            OutriggerServerImpl.this.destroyReaper(OutriggerServerImpl.this.entryReaperThread);
            OutriggerServerImpl.this.destroyReaper(OutriggerServerImpl.this.contentsQueryReaperThread);
            if (OutriggerServerImpl.this.expirationOpQueue != null) {
                OutriggerServerImpl.this.logDestroyPhase("terminating expiration op queue");
                OutriggerServerImpl.this.expirationOpQueue.terminate();
            }
            try {
                OutriggerServerImpl.this.logDestroyPhase("joining operation journal");
                OutriggerServerImpl.this.operationJournal.join();
            }
            catch (InterruptedException ie) {
                OutriggerServerImpl.this.logDestroyProblem("joining operation journal", ie);
            }
            OutriggerServerImpl.this.joinThread(OutriggerServerImpl.this.operationJournal);
            OutriggerServerImpl.this.joinThread(OutriggerServerImpl.this.templateReaperThread);
            OutriggerServerImpl.this.joinThread(OutriggerServerImpl.this.entryReaperThread);
            OutriggerServerImpl.this.joinThread(OutriggerServerImpl.this.contentsQueryReaperThread);
            if (OutriggerServerImpl.this.expirationOpQueue != null) {
                OutriggerServerImpl.this.joinThread(OutriggerServerImpl.this.expirationOpQueue);
            }
            if (OutriggerServerImpl.this.store != null) {
                try {
                    OutriggerServerImpl.this.logDestroyPhase("destroying store");
                    OutriggerServerImpl.this.store.destroy();
                }
                catch (Exception t) {
                    OutriggerServerImpl.this.logDestroyProblem("destroying store", t);
                }
            }
            if (OutriggerServerImpl.this.activationID != null) {
                OutriggerServerImpl.this.logDestroyPhase("calling ActivationGroup.inactive");
                try {
                    ActivationGroup.inactive(OutriggerServerImpl.this.activationID, OutriggerServerImpl.this.exporter);
                }
                catch (RemoteException e) {
                    OutriggerServerImpl.this.logDestroyProblem("calling ActivationGroup.inactive", e);
                }
                catch (ActivationException e) {
                    OutriggerServerImpl.this.logDestroyProblem("calling ActivationGroup.inactive", e);
                }
            }
            if (OutriggerServerImpl.this.lifeCycle != null) {
                OutriggerServerImpl.this.logDestroyPhase("calling lifeCycle.unregister");
                OutriggerServerImpl.this.lifeCycle.unregister(OutriggerServerImpl.this.serverGate);
            }
            if (OutriggerServerImpl.this.loginContext != null) {
                try {
                    OutriggerServerImpl.this.logDestroyPhase("logging out");
                    OutriggerServerImpl.this.loginContext.logout();
                }
                catch (Exception e) {
                    OutriggerServerImpl.this.logDestroyProblem("logging out", e);
                }
            }
            lifecycleLogger.log(Level.INFO, "Outrigger server destroy thread finished: {0}", this);
        }
    }

    private class ContentsQuery
    implements LeasedResource {
        private final Uuid uuid;
        private final Set classes = new HashSet();
        private final Iterator classesIterator;
        private final EntryRep[] tmpls;
        private final Txn txn;
        private final Object lock = new Object();
        private long expiration;
        private EntryHolder.ContinuingQuery currentQuery;
        private long remaining;
        private Uuid lastEntry;
        private EntryRep[] lastBatch;
        private final WeakHashMap provisionallyRemovedEntrySet = new WeakHashMap();

        private ContentsQuery(Uuid uuid, EntryRep[] tmpls, Txn txn, long limit) {
            this.uuid = uuid;
            this.tmpls = tmpls;
            this.txn = txn;
            this.remaining = limit;
            for (int i = 0; i < tmpls.length; ++i) {
                String whichClass = tmpls[i].classFor();
                Iterator subtypes = OutriggerServerImpl.this.types.subTypes(whichClass);
                while (subtypes.hasNext()) {
                    this.classes.add(subtypes.next());
                }
            }
            this.classesIterator = this.classes.iterator();
        }

        private boolean advanceCurrentQuery(long now) {
            while (this.classesIterator.hasNext()) {
                this.currentQuery = OutriggerServerImpl.this.createQuery(this.tmpls, (String)this.classesIterator.next(), this.txn, false, now);
                if (this.currentQuery == null) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private EntryRep[] nextBatch(Uuid lastReceived, long now) throws TransactionException {
            Object object = this.lock;
            synchronized (object) {
                if (lastReceived != null && !lastReceived.equals(this.lastEntry)) {
                    return this.lastBatch;
                }
                if (this.currentQuery == null) {
                    if (!this.advanceCurrentQuery(now)) {
                        try {
                            OutriggerServerImpl.waitOnProvisionallyRemovedEntries(this.provisionallyRemovedEntrySet);
                        }
                        catch (InterruptedException e) {
                            throw new AssertionError((Object)e);
                        }
                        return new EntryRep[1];
                    }
                } else {
                    this.currentQuery.restart(now);
                }
                HashSet conflictSet = new HashSet();
                this.lastBatch = new EntryRep[OutriggerServerImpl.this.nextLimit];
                int i = 0;
                while (this.remaining > 0L && i < this.lastBatch.length) {
                    EntryHandle handle = this.currentQuery.next(conflictSet, null, this.provisionallyRemovedEntrySet);
                    if (handle == null) {
                        if (this.advanceCurrentQuery(now)) continue;
                        this.currentQuery = null;
                        break;
                    }
                    this.lastBatch[i] = handle.rep();
                    ++i;
                    --this.remaining;
                }
                OutriggerServerImpl.this.monitor(conflictSet);
                this.lastEntry = i == 0 ? null : this.lastBatch[i - 1].id();
                return this.lastBatch;
            }
        }

        private boolean cancel() {
            if (OutriggerServerImpl.this.contentsQueries.remove(this.uuid) == null) {
                return false;
            }
            this.expiration = Long.MIN_VALUE;
            return true;
        }

        @Override
        public void setExpiration(long newExpiration) {
            this.expiration = newExpiration;
        }

        @Override
        public long getExpiration() {
            return this.expiration;
        }

        @Override
        public Uuid getCookie() {
            return this.uuid;
        }
    }
}

