/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.core.transaction.server.TransactionParticipant;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

class ParticipantProxy
implements TransactionParticipant,
ReferentUuid,
Serializable {
    static final long serialVersionUID = 1L;
    final TransactionParticipant space;
    final Uuid spaceUuid;

    ParticipantProxy(TransactionParticipant space, Uuid spaceUuid) {
        if (space == null) {
            throw new NullPointerException("space must be non-null");
        }
        if (spaceUuid == null) {
            throw new NullPointerException("spaceUuid must be non-null");
        }
        this.space = space;
        this.spaceUuid = spaceUuid;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.space == null) {
            throw new InvalidObjectException("null server reference");
        }
        if (this.spaceUuid == null) {
            throw new InvalidObjectException("null Uuid");
        }
    }

    private void readObjectNoData() throws InvalidObjectException {
        throw new InvalidObjectException("SpaceProxy should always have data");
    }

    public String toString() {
        return this.getClass().getName() + " for " + this.spaceUuid + " (through " + this.space + ")";
    }

    public boolean equals(Object other) {
        return ReferentUuids.compare(this, other);
    }

    public int hashCode() {
        return this.spaceUuid.hashCode();
    }

    @Override
    public Uuid getReferentUuid() {
        return this.spaceUuid;
    }

    @Override
    public int prepare(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        return this.space.prepare(mgr, id);
    }

    @Override
    public void commit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.space.commit(mgr, id);
    }

    @Override
    public void abort(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        this.space.abort(mgr, id);
    }

    @Override
    public int prepareAndCommit(TransactionManager mgr, long id) throws UnknownTransactionException, RemoteException {
        return this.space.prepareAndCommit(mgr, id);
    }
}

