/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.landlord.Landlord;
import com.sun.jini.landlord.LandlordProxyVerifier;
import com.sun.jini.outrigger.ConstrainableAdminProxy;
import com.sun.jini.outrigger.ConstrainableParticipantProxy;
import com.sun.jini.outrigger.ConstrainableSpaceProxy2;
import com.sun.jini.outrigger.OutriggerServer;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.rmi.RemoteException;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.id.Uuid;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements Serializable,
TrustVerifier {
    private static final long serialVersionUID = 1L;
    private final RemoteMethodControl server;
    private final Uuid uuid;

    ProxyVerifier(OutriggerServer server, Uuid uuid) {
        if (server == null) {
            throw new NullPointerException("server can not be null");
        }
        if (uuid == null) {
            throw new NullPointerException("uuid can not be null");
        }
        if (!(server instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("cannot construct verifier - server reference does not implement RemoteMethodControl");
        }
        if (!(server instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("cannot construct verifier - server reference does not implement TrustEquivalence");
        }
        this.uuid = uuid;
        this.server = (RemoteMethodControl)((Object)server);
    }

    @Override
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        RemoteMethodControl inputProxyServer;
        Uuid inputProxyUuid;
        if (obj == null || ctx == null) {
            throw new NullPointerException("arguments must not be null");
        }
        if (obj instanceof ConstrainableSpaceProxy2) {
            ConstrainableSpaceProxy2 csp = (ConstrainableSpaceProxy2)obj;
            inputProxyUuid = csp.getReferentUuid();
            inputProxyServer = (RemoteMethodControl)((Object)csp.space);
        } else if (obj instanceof ConstrainableAdminProxy) {
            ConstrainableAdminProxy cap = (ConstrainableAdminProxy)obj;
            inputProxyUuid = cap.getReferentUuid();
            inputProxyServer = (RemoteMethodControl)((Object)cap.admin);
        } else if (obj instanceof ConstrainableParticipantProxy) {
            ConstrainableParticipantProxy cpp = (ConstrainableParticipantProxy)obj;
            inputProxyUuid = cpp.getReferentUuid();
            inputProxyServer = (RemoteMethodControl)((Object)cpp.space);
        } else if (obj instanceof OutriggerServer && obj instanceof RemoteMethodControl) {
            inputProxyUuid = this.uuid;
            inputProxyServer = (RemoteMethodControl)obj;
        } else {
            LandlordProxyVerifier lpv = new LandlordProxyVerifier((Landlord)((Object)this.server), this.uuid);
            return lpv.isTrustedObject(obj, ctx);
        }
        if (!this.uuid.equals(inputProxyUuid)) {
            return false;
        }
        MethodConstraints mConstraints = inputProxyServer.getConstraints();
        TrustEquivalence constrainedServer = (TrustEquivalence)((Object)this.server.setConstraints(mConstraints));
        return constrainedServer.checkTrustEquivalence(inputProxyServer);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.server == null) {
            throw new InvalidObjectException("null server reference");
        }
        if (this.uuid == null) {
            throw new InvalidObjectException("null uuid reference");
        }
        if (!(this.server instanceof TrustEquivalence)) {
            throw new InvalidObjectException("server does not implement TrustEquivalence");
        }
        if (!(this.server instanceof Landlord)) {
            throw new InvalidObjectException("server does not implement landlord");
        }
    }
}

