/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryHandle;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.QueryWatcher;
import com.sun.jini.outrigger.TemplateHandle;

abstract class SingletonQueryWatcher
extends QueryWatcher {
    private boolean resolved = false;
    private EntryHandle handle;
    private Throwable toThrow;
    private TemplateHandle owner;

    SingletonQueryWatcher(long expiration, long timestamp, long startOrdinal) {
        super(expiration, timestamp, startOrdinal);
    }

    @Override
    boolean addTemplateHandle(TemplateHandle h) {
        if (h == null) {
            throw new NullPointerException("TemplateHandle must be non-null");
        }
        if (this.owner != null) {
            throw new AssertionError((Object)"Can only call addTemplateHandle once");
        }
        this.owner = h;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void waitOnResolution() throws InterruptedException {
        TemplateHandle owner;
        SingletonQueryWatcher singletonQueryWatcher = this;
        synchronized (singletonQueryWatcher) {
            while (!this.resolved) {
                long sleepTime = this.getExpiration() - System.currentTimeMillis();
                if (sleepTime <= 0L) {
                    this.resolved = true;
                    continue;
                }
                this.wait(sleepTime);
            }
            owner = this.owner;
            this.owner = null;
        }
        owner.removeTransitionWatcher(this);
    }

    synchronized EntryHandle resolvedWithEntry() {
        if (!this.resolved) {
            throw new IllegalStateException("Query not yet resolved");
        }
        return this.handle;
    }

    synchronized Throwable resolvedWithThrowable() {
        if (!this.resolved) {
            throw new IllegalStateException("Query not yet resolved");
        }
        return this.toThrow;
    }

    @Override
    boolean isResolved() {
        return this.resolved;
    }

    void resolve(EntryHandle handle, Throwable throwable) {
        assert (Thread.holdsLock(this)) : "Caller of resolve() must hold lock";
        if (this.resolved) {
            throw new IllegalStateException("Can't call resolve on a resolved query ");
        }
        if (this.handle != null || this.toThrow != null) {
            throw new IllegalStateException("At lease one argument must be null");
        }
        this.resolved = true;
        this.handle = handle;
        this.toThrow = throwable;
        this.notifyAll();
    }

    OutriggerServerImpl getServer() {
        assert (Thread.holdsLock(this)) : "getServer() called without lock";
        return this.owner.getServer();
    }
}

