/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.AvailabilityRegistrationWatcher;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.StorableReference;
import com.sun.jini.outrigger.StorableResource;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.StreamCorruptedException;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.security.ProxyPreparer;

class StorableAvailabilityWatcher
extends AvailabilityRegistrationWatcher
implements StorableResource {
    private StorableReference listener;

    StorableAvailabilityWatcher(long timestamp, long startOrdinal, long currentSeqNum) {
        super(timestamp, startOrdinal, currentSeqNum);
    }

    StorableAvailabilityWatcher(long timestamp, long startOrdinal, Uuid cookie, boolean visibilityOnly, MarshalledObject handback, long eventID, RemoteEventListener listener) {
        super(timestamp, startOrdinal, cookie, visibilityOnly, handback, eventID);
        if (listener == null) {
            throw new NullPointerException("listener must be non-null");
        }
        this.listener = new StorableReference(listener);
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        if (ordinal <= this.startOrdinal) {
            return false;
        }
        if (transition.getTxn() != null) {
            return false;
        }
        if (!transition.isAvailable()) {
            return false;
        }
        if (this.visibilityOnly && !transition.isVisible()) {
            return false;
        }
        if (transition.hasProcessed(this)) {
            return false;
        }
        transition.processedBy(this);
        return true;
    }

    @Override
    RemoteEventListener getListener(ProxyPreparer preparer) throws ClassNotFoundException, IOException {
        return (RemoteEventListener)this.listener.get(preparer);
    }

    @Override
    void cleanup(OutriggerServerImpl server, boolean expired) {
        if (expired) {
            server.scheduleCancelOp(this.cookie);
        } else {
            server.cancelOp(this.cookie, false);
        }
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        this.cookie.write(out);
        out.writeLong(this.expiration);
        out.writeLong(this.eventID);
        out.writeBoolean(this.visibilityOnly);
        out.writeObject(this.handback);
        out.writeObject(this.listener);
    }

    @Override
    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.cookie = UuidFactory.read(in);
        this.expiration = in.readLong();
        this.eventID = in.readLong();
        this.visibilityOnly = in.readBoolean();
        this.handback = (MarshalledObject)in.readObject();
        this.listener = (StorableReference)in.readObject();
        if (this.listener == null) {
            throw new StreamCorruptedException("Stream corrupted, should not be null");
        }
    }
}

