/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.rmi.MarshalledObject;
import net.jini.security.ProxyPreparer;

class StorableReference
implements Externalizable {
    private MarshalledObject bytes;
    private transient Object obj;
    private transient boolean prepared;
    private static final boolean DEBUG = false;
    private static final long serialVersionUID = -3793675220968988873L;

    public StorableReference(Object obj) {
        if (obj == null) {
            throw new NullPointerException("obj cannot be null");
        }
        this.obj = obj;
        this.prepared = true;
    }

    public StorableReference() {
    }

    public synchronized Object get(ProxyPreparer preparer) throws IOException, ClassNotFoundException {
        if (this.obj == null) {
            this.obj = this.bytes.get();
        }
        if (!this.prepared) {
            if (preparer != null) {
                this.obj = preparer.prepareProxy(this.obj);
            }
            this.prepared = true;
        }
        return this.obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        StorableReference storableReference = this;
        synchronized (storableReference) {
            if (this.bytes == null) {
                this.bytes = new MarshalledObject<Object>(this.obj);
            }
        }
        out.writeObject(this.bytes);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.bytes = (MarshalledObject)in.readObject();
    }
}

