/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.EventRegistrationWatcher;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.Txn;
import java.rmi.MarshalledObject;
import net.jini.core.event.RemoteEventListener;
import net.jini.id.Uuid;
import net.jini.security.ProxyPreparer;
import net.jini.space.InternalSpaceException;

class TransactableEventWatcher
extends EventRegistrationWatcher
implements Transactable {
    private final RemoteEventListener listener;
    private final Txn txn;

    TransactableEventWatcher(long timestamp, long startOrdinal, Uuid cookie, MarshalledObject handback, long eventID, RemoteEventListener listener, Txn txn) {
        super(timestamp, startOrdinal, cookie, handback, eventID);
        if (listener == null) {
            throw new NullPointerException("listener must be non-null");
        }
        if (txn == null) {
            throw new NullPointerException("txn must be non-null");
        }
        this.listener = listener;
        this.txn = txn;
    }

    @Override
    boolean isInterested(EntryTransition transition, long ordinal) {
        if (!transition.isNewEntry()) {
            return false;
        }
        if (ordinal <= this.startOrdinal) {
            return false;
        }
        TransactableMgr transitionTxn = transition.getTxn();
        return transitionTxn == null || transitionTxn == this.txn;
    }

    @Override
    RemoteEventListener getListener(ProxyPreparer preparer) {
        return this.listener;
    }

    @Override
    public int prepare(TransactableMgr mgr, OutriggerServerImpl space) {
        this.cancel();
        return 4;
    }

    @Override
    public void commit(TransactableMgr mgr, OutriggerServerImpl space) {
        throw new InternalSpaceException("committing a TransactableRegistrationWatcher");
    }

    @Override
    public void abort(TransactableMgr mgr, OutriggerServerImpl space) {
        this.prepare(mgr, space);
    }
}

