/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryRep;
import com.sun.jini.outrigger.EntryTransition;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.TransitionWatcher;
import com.sun.jini.outrigger.WatchersForTemplateClass;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

class TransitionWatchers {
    private final Map holders = new HashMap();
    private final OutriggerServerImpl server;

    TransitionWatchers(OutriggerServerImpl server) {
        if (server == null) {
            throw new NullPointerException("server must be non-null");
        }
        this.server = server;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(TransitionWatcher watcher, EntryRep template) {
        WatchersForTemplateClass holder;
        String className = template.classFor();
        Map map = this.holders;
        synchronized (map) {
            holder = (WatchersForTemplateClass)this.holders.get(className);
            if (holder == null) {
                holder = new WatchersForTemplateClass(this);
                this.holders.put(className, holder);
            }
        }
        holder.add(watcher, template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SortedSet allMatches(EntryTransition transition, long ordinal) {
        Map map;
        WatchersForTemplateClass holder;
        EntryRep rep = transition.getHandle().rep();
        TreeSet rslt = new TreeSet();
        String className = rep.classFor();
        Map map2 = this.holders;
        synchronized (map2) {
            holder = (WatchersForTemplateClass)this.holders.get(className);
        }
        if (holder != null) {
            holder.collectInterested(rslt, transition, ordinal);
        }
        String[] superclasses = rep.superclasses();
        for (int i = 0; i < superclasses.length; ++i) {
            map = this.holders;
            synchronized (map) {
                holder = (WatchersForTemplateClass)this.holders.get(superclasses[i]);
            }
            if (holder == null) continue;
            holder.collectInterested(rslt, transition, ordinal);
        }
        String nullClass = EntryRep.matchAnyEntryRep().classFor();
        map = this.holders;
        synchronized (map) {
            holder = (WatchersForTemplateClass)this.holders.get(nullClass);
        }
        if (holder != null) {
            holder.collectInterested(rslt, transition, ordinal);
        }
        return rslt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void reap() {
        WatchersForTemplateClass[] content;
        Map map = this.holders;
        synchronized (map) {
            Collection values = this.holders.values();
            content = new WatchersForTemplateClass[values.size()];
            values.toArray(content);
        }
        long now = System.currentTimeMillis();
        for (int i = 0; i < content.length; ++i) {
            content[i].reap(now);
        }
    }

    OutriggerServerImpl getServer() {
        return this.server;
    }
}

