/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.constants.TxnConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.OutriggerServerImpl;
import com.sun.jini.outrigger.StorableObject;
import com.sun.jini.outrigger.StorableReference;
import com.sun.jini.outrigger.Transactable;
import com.sun.jini.outrigger.TransactableMgr;
import com.sun.jini.outrigger.TxnMonitorTask;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.CannotJoinException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;
import net.jini.core.transaction.server.TransactionManager;
import net.jini.security.ProxyPreparer;
import net.jini.space.InternalSpaceException;

class Txn
implements TransactableMgr,
TransactionConstants,
StorableObject {
    private final long id;
    private int state;
    private StorableReference trm;
    private ServerTransaction tr;
    private long trId;
    private final List txnables = new LinkedList();
    private TxnMonitorTask monitorTask;
    private int stateReaders = 0;
    private boolean stateChangeWaiting = false;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.transactions");

    Txn(ServerTransaction tr, long id) {
        this(id);
        this.trId = tr.id;
        this.tr = tr;
        this.trm = new StorableReference(tr.mgr);
        this.state = 1;
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "creating txn for transaction mgr:{0}, id:{1}, state:{2}", new Object[]{tr, this.trId, TxnConstants.getName(this.state)});
        }
    }

    Txn(long id) {
        this.id = id;
    }

    Long getId() {
        return this.id;
    }

    long getTransactionId() {
        return this.trId;
    }

    int getState() {
        return this.state;
    }

    synchronized void ensureActive() throws CannotJoinException {
        if (this.state != 1 || this.stateChangeWaiting) {
            String msg = "transaction mgr:" + this.tr + ", id:" + this.trId + " not active, in state " + TxnConstants.getName(this.state);
            CannotJoinException e = new CannotJoinException(msg);
            logger.log(Levels.FAILED, msg, e);
            throw e;
        }
        assert (this.stateReaders >= 0);
        ++this.stateReaders;
    }

    synchronized void allowStateChange() {
        if (this.state != 1 || this.stateChangeWaiting) {
            return;
        }
        --this.stateReaders;
        assert (this.stateReaders >= 0);
        this.notifyAll();
    }

    synchronized void makeInactive() {
        this.stateChangeWaiting = true;
        assert (this.stateReaders >= 0);
        while (this.stateReaders != 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new AssertionError((Object)e);
            }
            assert (this.stateReaders >= 0);
        }
    }

    synchronized int prepare(OutriggerServerImpl space) {
        assert (this.stateChangeWaiting) : "prepare called before makeInactive";
        assert (this.stateReaders == 0) : "prepare called before makeInactive completed";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "prepare: transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
        }
        switch (this.state) {
            case 6: {
                return 6;
            }
            case 5: {
                throw new IllegalStateException();
            }
            case 3: 
            case 4: {
                return this.state;
            }
            case 1: {
                boolean changed = false;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "prepare:preparing transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
                }
                Iterator i = this.txnables.iterator();
                boolean c = false;
                block11: while (i.hasNext()) {
                    Transactable transactable = (Transactable)i.next();
                    int prepState = transactable.prepare(this, space);
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "prepare:prepared transactable {0} for transaction mgr:{1}, id:{2}, transactable now in state {3}", new Object[]{transactable, this.tr, this.trId, TxnConstants.getName(prepState)});
                    }
                    switch (prepState) {
                        case 3: {
                            changed = true;
                            continue block11;
                        }
                        case 6: {
                            this.abort(space);
                            this.state = 6;
                            return this.state;
                        }
                        case 4: {
                            i.remove();
                            continue block11;
                        }
                    }
                    throw new InternalSpaceException("prepare said " + prepState);
                }
                if (changed) {
                    this.state = 3;
                    space.monitor(Collections.nCopies(1, this));
                    break;
                }
                this.state = 4;
                break;
            }
            default: {
                throw new IllegalStateException("unknown Txn state: " + this.state);
            }
        }
        return this.state;
    }

    synchronized void abort(OutriggerServerImpl space) {
        assert (this.stateChangeWaiting) : "abort called before makeInactive";
        assert (this.stateReaders == 0) : "abort called before makeInactive completed";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "abort: transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
        }
        switch (this.state) {
            case 4: 
            case 6: {
                break;
            }
            case 5: {
                throw new IllegalStateException("aborting a committed txn");
            }
            case 1: 
            case 3: {
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "abort:aborting transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
                }
                Iterator i = this.txnables.iterator();
                while (i.hasNext()) {
                    ((Transactable)i.next()).abort(this, space);
                }
                this.state = 6;
                this.cleanup();
                break;
            }
            default: {
                throw new IllegalStateException("unknown Txn state: " + this.state);
            }
        }
    }

    synchronized void commit(OutriggerServerImpl space) {
        assert (this.stateChangeWaiting) : "commit called before makeInactive";
        assert (this.stateReaders == 0) : "commit called before makeInactive completed";
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "commit: transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
        }
        switch (this.state) {
            case 1: 
            case 4: 
            case 6: {
                throw new IllegalStateException("committing " + TxnConstants.getName(this.state) + " txn");
            }
            case 5: {
                return;
            }
            case 3: {
                Iterator i = this.txnables.iterator();
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "commit:committing transaction mgr:{0}, id:{1}, state:{2}", new Object[]{this.tr, this.trId, TxnConstants.getName(this.state)});
                }
                while (i.hasNext()) {
                    ((Transactable)i.next()).commit(this, space);
                }
                this.state = 5;
                this.cleanup();
                return;
            }
        }
        throw new IllegalStateException("unknown Txn state: " + this.state);
    }

    @Override
    public synchronized Transactable add(Transactable t) {
        this.txnables.add(t);
        return t;
    }

    @Override
    public ServerTransaction getTransaction(ProxyPreparer preparer) throws IOException, ClassNotFoundException {
        if (this.tr == null) {
            TransactionManager mgr = (TransactionManager)this.trm.get(preparer);
            this.tr = new ServerTransaction(mgr, this.trId);
        }
        return this.tr;
    }

    TransactionManager getManager() {
        if (this.tr == null) {
            throw new IllegalStateException("Txn is still broken");
        }
        return this.tr.mgr;
    }

    TxnMonitorTask monitorTask() {
        return this.monitorTask;
    }

    void monitorTask(TxnMonitorTask task) {
        this.monitorTask = task;
    }

    private void cleanup() {
        if (this.monitorTask != null) {
            this.monitorTask.cancel();
        }
    }

    @Override
    public void store(ObjectOutputStream out) throws IOException {
        out.writeObject(this.trm);
        out.writeLong(this.trId);
    }

    @Override
    public void restore(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.state = 3;
        this.trm = (StorableReference)in.readObject();
        this.trId = in.readLong();
    }
}

