/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.constants.ThrowableConstants;
import com.sun.jini.constants.TimeConstants;
import com.sun.jini.constants.TxnConstants;
import com.sun.jini.logging.Levels;
import com.sun.jini.outrigger.QueryWatcher;
import com.sun.jini.outrigger.Txn;
import com.sun.jini.outrigger.TxnMonitor;
import com.sun.jini.thread.RetryTask;
import com.sun.jini.thread.TaskManager;
import com.sun.jini.thread.WakeupManager;
import java.io.IOException;
import java.rmi.NoSuchObjectException;
import java.rmi.RemoteException;
import java.rmi.UnmarshalException;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.transaction.TransactionException;
import net.jini.core.transaction.UnknownTransactionException;
import net.jini.core.transaction.server.ServerTransaction;
import net.jini.core.transaction.server.TransactionConstants;

class TxnMonitorTask
extends RetryTask
implements TransactionConstants,
TimeConstants {
    private final Txn txn;
    private final TxnMonitor monitor;
    private Map queries;
    private int failCnt;
    private long nextQuery;
    private boolean mustQuery;
    private long deltaT;
    private static final long INITIAL_GRACE = 15000L;
    private static final long BETWEEN_EXCEPTIONS = 15000L;
    private static final long MAX_DELTA_T = 3600000L;
    private static final int MAX_FAILURES = 3;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.transactions");

    TxnMonitorTask(Txn txn, TxnMonitor monitor, TaskManager manager, WakeupManager wakeupMgr) {
        super(manager, wakeupMgr);
        this.txn = txn;
        this.monitor = monitor;
        this.nextQuery = this.startTime();
        this.deltaT = 15000L;
        this.mustQuery = true;
    }

    @Override
    public long retryTime() {
        if (this.failCnt == 0 && this.txn.getState() != 3) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "{0} retryTime adds {1}", new Object[]{this, this.deltaT});
            }
            this.nextQuery += this.deltaT;
            if (this.deltaT < 3600000L) {
                this.deltaT = Math.min(this.deltaT * 2L, 3600000L);
            }
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "{0} retryTime adds {1} (for {2})", new Object[]{this, 15000L, this.failCnt != 0 ? "failure" : "PREPARED"});
            }
            this.nextQuery += 15000L;
        }
        return this.nextQuery;
    }

    @Override
    public boolean runAfter(List tasks, int size) {
        return false;
    }

    synchronized void addSibling(Txn txn) {
        if (this.queries == null || this.queries.size() == 0) {
            return;
        }
        List<Txn> sibling = Collections.nCopies(1, txn);
        for (QueryWatcher query : this.queries.keySet()) {
            if (query == null) continue;
            this.monitor.add(query, sibling);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean tryOnce() {
        int trState;
        ServerTransaction tr;
        int txnState;
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0} attempt {1} mustQuery:{2}", new Object[]{this, this.attempt(), new Boolean(this.mustQuery)});
        }
        if (this.attempt() == 0) {
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0} txn.getState() = {1}", new Object[]{this, this.txn.getState()});
        }
        if ((txnState = this.txn.getState()) != 1 && txnState != 3) {
            return true;
        }
        this.mustQuery |= txnState == 3;
        TxnMonitorTask txnMonitorTask = this;
        synchronized (txnMonitorTask) {
            if (!this.mustQuery) {
                if (this.queries == null) {
                    return false;
                }
                Iterator it = this.queries.keySet().iterator();
                boolean foundNeed = false;
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "{0} nextQuery {1}", new Object[]{this, this.nextQuery});
                }
                while (it.hasNext()) {
                    QueryWatcher query = (QueryWatcher)it.next();
                    if (query == null) continue;
                    if (logger.isLoggable(Level.FINEST)) {
                        logger.log(Level.FINEST, "{0} query.getExpiration() {1}", new Object[]{this, query.getExpiration()});
                    }
                    if (query.getExpiration() < this.nextQuery || query.isResolved()) {
                        it.remove();
                        continue;
                    }
                    foundNeed = true;
                    break;
                }
                if (logger.isLoggable(Level.FINEST)) {
                    logger.log(Level.FINEST, "{0} foundNeed = {1}", new Object[]{this, new Boolean(foundNeed)});
                }
                if (!foundNeed) {
                    return false;
                }
            }
            this.mustQuery = false;
        }
        try {
            tr = this.txn.getTransaction(this.monitor.space().getRecoveredTransactionManagerPreparer());
        }
        catch (RemoteException e) {
            int cat = ThrowableConstants.retryable(e);
            if (cat == 1 || cat == 2) {
                this.logUnpackingFailure("definite exception", Level.INFO, true, e);
                return true;
            }
            if (cat == 0) {
                this.logUnpackingFailure("indefinite exception", Levels.FAILED, false, e);
                this.mustQuery = true;
                return false;
            }
            if (cat == 3) {
                this.mustQuery = true;
                this.logUnpackingFailure("uncategorized exception", Level.INFO, false, e);
                return false;
            }
            logger.log(Level.WARNING, "ThrowableConstants.retryable returned out of range value, " + cat, (Throwable)((Object)new AssertionError((Object)e)));
            return false;
        }
        catch (IOException e) {
            this.logUnpackingFailure("IOException", Level.INFO, true, e);
            return true;
        }
        catch (RuntimeException e) {
            this.logUnpackingFailure("RuntimeException", Level.INFO, true, e);
            return true;
        }
        catch (ClassNotFoundException e) {
            this.logUnpackingFailure("ClassNotFoundException", Levels.FAILED, false, e);
            this.mustQuery = true;
            return false;
        }
        if (logger.isLoggable(Level.FINEST)) {
            logger.log(Level.FINEST, "{0} tr = {1}", new Object[]{this, tr});
        }
        try {
            trState = tr.getState();
        }
        catch (TransactionException e) {
            if (logger.isLoggable(Level.INFO)) {
                logger.log(Level.INFO, "Got TransactionException when calling getState on " + tr + ", dropping transaction " + tr.id, e);
            }
            trState = 6;
        }
        catch (NoSuchObjectException e) {
            if (++this.failCnt >= 3) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "Got NoSuchObjectException when calling getState on " + tr + ", this was the " + this.failCnt + " RemoteException, dropping transaction" + tr.id, e);
                }
                trState = 6;
            }
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "Got NoSuchObjectException when calling getState on " + tr + ", failCount = " + this.failCnt + ", will retry", e);
            }
            this.mustQuery = true;
            return false;
        }
        catch (RemoteException e) {
            if (++this.failCnt >= 3) {
                Txn txn = this.txn;
                synchronized (txn) {
                    switch (this.txn.getState()) {
                        case 1: {
                            if (logger.isLoggable(Level.INFO)) {
                                logger.log(Level.INFO, "Got RemoteException when calling getState on " + tr + ", this " + "was " + this.failCnt + " RemoteException, " + "dropping active transaction " + tr.id, e);
                            }
                            try {
                                this.monitor.space().abort(tr.mgr, tr.id);
                                return true;
                            }
                            catch (UnknownTransactionException ute) {
                                throw new AssertionError((Object)ute);
                            }
                            catch (UnmarshalException ume) {
                                throw new AssertionError((Object)ume);
                            }
                        }
                        case 3: {
                            Level l;
                            Level level = l = this.failCnt % 3 == 0 ? Level.INFO : Levels.FAILED;
                            if (logger.isLoggable(l)) {
                                logger.log(l, "Got RemoteException when calling getState on " + tr + ", this was " + this.failCnt + " RemoteException, will keep " + "prepared transaction " + tr.id, e);
                            }
                            this.mustQuery = true;
                            return false;
                        }
                        case 5: 
                        case 6: {
                            return true;
                        }
                    }
                    throw new AssertionError((Object)"Txn in unreachable state");
                }
            }
            if (logger.isLoggable(Levels.FAILED)) {
                logger.log(Levels.FAILED, "Got RemoteException when calling getState on " + tr + ", failCount = " + this.failCnt + ", will retry", e);
            }
            this.mustQuery = true;
            return false;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.log(Level.FINER, "{0} trState = {1}", new Object[]{this, trState});
        }
        this.failCnt = 0;
        if (trState != txnState) {
            if (logger.isLoggable(Level.FINER)) {
                logger.log(Level.FINER, "{0} mgr state[{1}] != local state [{2}]", new Object[]{this, TxnConstants.getName(trState), TxnConstants.getName(txnState)});
            }
            try {
                switch (trState) {
                    case 6: {
                        logger.log(Level.FINER, "{0} moving to abort", this);
                        this.monitor.space().abort(tr.mgr, tr.id);
                        return true;
                    }
                    case 5: {
                        logger.log(Level.FINER, "{0} moving to commit", this);
                        this.monitor.space().commit(tr.mgr, tr.id);
                        return true;
                    }
                }
            }
            catch (UnknownTransactionException e) {
                return true;
            }
            catch (UnmarshalException ume) {
                throw new AssertionError((Object)ume);
            }
        }
        logger.log(Level.FINEST, "{0} return false", this);
        return false;
    }

    synchronized void add(QueryWatcher query) {
        if (query == null || query.getExpiration() <= this.nextQuery) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "adding resource to task -- SHORT");
            }
            this.mustQuery = true;
        } else {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "adding resource to task -- LONG");
            }
            if (this.queries == null) {
                this.queries = new WeakHashMap();
            }
            this.queries.put(query, null);
        }
    }

    private void logUnpackingFailure(String exceptionDescription, Level level, boolean terminal, Throwable t) {
        if (logger.isLoggable(level)) {
            logger.log(level, "Encountered " + exceptionDescription + "while unpacking exception to check state, " + (terminal ? "dropping" : "keeping") + " monitoring task", t);
        }
    }
}

