/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger;

import com.sun.jini.outrigger.EntryRep;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.Vector;
import net.jini.core.entry.Entry;

class TypeTree {
    private Hashtable subclasses = new Hashtable();
    private static final Random numgen = new Random();
    private static final String ROOT = Entry.class.getName();

    TypeTree() {
    }

    private Vector classVector(String whichClass) {
        return (Vector)this.subclasses.get(whichClass);
    }

    Iterator subTypes(String className) {
        return new RandomizedIterator(className);
    }

    void addTypes(EntryRep bits) {
        String classFor = bits.classFor();
        String[] superclasses = bits.superclasses();
        String prevClass = classFor;
        for (int i = 0; i < superclasses.length; ++i) {
            if (!this.addKnown(superclasses[i], prevClass)) {
                return;
            }
            prevClass = superclasses[i];
        }
        this.addKnown(ROOT, prevClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addKnown(String superclass, String subclass) {
        Vector<String> v;
        Cloneable cloneable = this.subclasses;
        synchronized (cloneable) {
            v = this.classVector(superclass);
            if (v == null) {
                v = new Vector<String>();
                this.subclasses.put(superclass, v);
            }
        }
        cloneable = v;
        synchronized (cloneable) {
            if (v.contains(subclass)) {
                return false;
            }
            v.addElement(subclass);
        }
        return true;
    }

    class RandomizedIterator
    extends TypeTreeIterator {
        RandomizedIterator(String className) {
            this.init(className);
        }

        private void walkTree(Collection children, Collection list) {
            if (children != null) {
                list.addAll(children);
                Object[] kids = children.toArray();
                for (int i = 0; i < kids.length; ++i) {
                    this.walkTree(TypeTree.this.classVector((String)kids[i]), list);
                }
            }
        }

        private void init(String className) {
            ArrayList<String> types = new ArrayList<String>();
            if (className.equals(EntryRep.matchAnyClassName())) {
                className = ROOT;
            } else {
                types.add(className);
            }
            this.walkTree(TypeTree.this.classVector(className), types);
            this.typearray = types.toArray();
            int randnum = 0;
            Object tmpobj = null;
            for (int i = 0; i < this.typearray.length; ++i) {
                randnum = numgen.nextInt(this.typearray.length - i);
                tmpobj = this.typearray[i];
                this.typearray[i] = this.typearray[randnum];
                this.typearray[randnum] = tmpobj;
            }
        }
    }

    private abstract class TypeTreeIterator
    implements Iterator {
        protected int cursor;
        protected Object[] typearray;

        private TypeTreeIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.cursor < this.typearray.length;
        }

        public Object next() throws NoSuchElementException {
            Object val = null;
            if (this.cursor >= this.typearray.length) {
                throw new NoSuchElementException("TypeTreeIterator: next");
            }
            try {
                val = this.typearray[this.cursor];
                ++this.cursor;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException("TypeTreeIterator: next" + e.getMessage());
            }
            return val;
        }

        @Override
        public void remove() throws UnsupportedOperationException {
            throw new UnsupportedOperationException("TypeTreeIterator: remove not supported");
        }
    }
}

