/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.Recover;
import com.sun.jini.outrigger.StoredObject;
import com.sun.jini.outrigger.snaplogstore.ByteArrayWrapper;
import com.sun.jini.outrigger.snaplogstore.LogInputFile;
import com.sun.jini.outrigger.snaplogstore.PendingTxn;
import com.sun.jini.outrigger.snaplogstore.Registration;
import com.sun.jini.outrigger.snaplogstore.Resource;
import com.sun.jini.outrigger.snaplogstore.SnapshotFile;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

class BackEnd
implements Observer {
    private Long sessionId;
    private StoredObject joinState;
    private Map entries;
    private Map registrations;
    private Map pendingTxns;
    private byte[] topUuid;
    private LastLog lastLog;
    private int retry = 3;
    private SnapshotFile snapshotFile;
    private final int SNAPSHOT_VERSION = 3;
    private String logFileBase;
    private String snapshotFileBase;
    private ConsumerThread consumer;
    private static final long WAIT_FOR_THREAD = 60000L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    BackEnd(String path) {
        this.logFileBase = new File(path, "LogStore").getAbsolutePath();
        this.snapshotFileBase = new File(path, "Snapshot.").getAbsolutePath();
    }

    void setupStore(Recover space) {
        Iterator i;
        this.recoverSnapshot();
        this.consumeLogs(true);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "recoverSnapshot: number of entries:{0}, number of pendingTxns:{1}, number of registrations:{2}", new Object[]{this.entries.size(), this.pendingTxns.size(), this.registrations.size()});
        }
        if (this.sessionId != null) {
            space.recoverSessionId(this.sessionId);
        }
        if (this.topUuid != null) {
            space.recoverUuid(ByteArrayWrapper.toUuid(this.topUuid));
        }
        if (this.joinState != null) {
            try {
                space.recoverJoinState(this.joinState);
            }
            catch (Exception e) {
                throw this.logAndThrowRecoveryException("Error recovering join state", e);
            }
        }
        try {
            i = this.entries.values().iterator();
            while (i.hasNext()) {
                space.recoverWrite((Resource)i.next(), null);
            }
        }
        catch (Exception e) {
            throw this.logAndThrowRecoveryException("Error recovering entries", e);
        }
        try {
            i = this.pendingTxns.values().iterator();
            while (i.hasNext()) {
                PendingTxn pt = (PendingTxn)i.next();
                if (pt.recover(space)) continue;
                i.remove();
            }
        }
        catch (Exception e) {
            throw this.logAndThrowRecoveryException("Error recovering transactions", e);
        }
        try {
            for (Registration reg : this.registrations.values()) {
                StoredObject[] templates = reg.getTemplates();
                space.recoverRegister(reg, reg.getType(), templates);
            }
        }
        catch (Exception e) {
            throw this.logAndThrowRecoveryException("Error recovering registrations", e);
        }
        this.startConsumer();
    }

    private void recoverSnapshot() {
        try {
            File[] snapshot = new File[1];
            this.snapshotFile = new SnapshotFile(this.snapshotFileBase, snapshot);
            if (snapshot[0] == null) {
                this.sessionId = null;
                this.entries = new HashMap();
                this.registrations = new HashMap();
                this.pendingTxns = new HashMap();
                this.topUuid = null;
                this.lastLog = null;
                return;
            }
            ObjectInputStream in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(snapshot[0])));
            int version = in.readInt();
            if (version != 3) {
                this.logAndThrowRecoveryException("Wrong file version:" + version, null);
            }
            this.sessionId = (Long)in.readObject();
            this.joinState = (StoredObject)in.readObject();
            this.entries = (Map)in.readObject();
            this.registrations = (Map)in.readObject();
            this.pendingTxns = (Map)in.readObject();
            this.topUuid = (byte[])in.readObject();
            this.lastLog = (LastLog)in.readObject();
            in.close();
        }
        catch (RuntimeException t) {
            throw t;
        }
        catch (Throwable t) {
            throw this.logAndThrowRecoveryException("Problem recovering snapshot", t);
        }
    }

    private void startConsumer() {
        this.consumer = new ConsumerThread();
        this.consumer.start();
    }

    @Override
    public void update(Observable source, Object arg) {
        if (!this.consumer.isAlive()) {
            if (this.retry > 0) {
                logger.log(Level.INFO, "Consumer thread died, attempting restart");
                --this.retry;
                this.startConsumer();
            } else {
                logger.log(Level.SEVERE, "Consumer thread no longer running");
                return;
            }
        }
        this.consumer.update();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        try {
            this.consumer.interrupt();
            this.consumer.join(60000L);
        }
        catch (InterruptedException ignore) {
        }
        finally {
            try {
                if (this.snapshotFile != null) {
                    this.snapshotFile.destroy();
                }
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Exception encounter while destroying store", t);
            }
        }
    }

    void close() {
        this.consumer.interrupt();
        try {
            this.consumer.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (this.snapshotFile != null) {
            try {
                this.snapshotFile.close();
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Exception encounter while closing store", t);
            }
        }
    }

    private PendingTxn pendingTxn(Long txnId) {
        PendingTxn pt = (PendingTxn)this.pendingTxns.get(txnId);
        if (pt == null) {
            pt = new PendingTxn(txnId);
            this.pendingTxns.put(txnId, pt);
        }
        return pt;
    }

    private void removePendingTxn(Long txnId) {
        this.pendingTxns.remove(txnId);
    }

    void bootOp(long time, long session) {
        this.sessionId = session;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "bootOp({0})", new Date(time));
        }
    }

    void joinStateOp(StoredObject state) {
        this.joinState = state;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "joinStateOp()");
        }
    }

    void writeOp(Resource entry, Long txnId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "writeOp({0},{1})", new Object[]{entry, txnId});
        }
        if (txnId != null) {
            this.pendingTxn(txnId).addWrite(entry);
        } else {
            this.entries.put(entry.getCookieAsWrapper(), entry);
        }
    }

    void takeOp(byte[] cookie, Long txnId) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "takeOp({0},{1})", new Object[]{ByteArrayWrapper.toUuid(cookie), txnId});
        }
        if (txnId != null) {
            this.pendingTxn(txnId).addTake(cookie);
        } else {
            this.entries.remove(new ByteArrayWrapper(cookie));
        }
    }

    void registerOp(Registration registration) {
        logger.log(Level.FINE, "registerOp({0})", registration);
        this.registrations.put(registration.getCookieAsWrapper(), registration);
    }

    void renewOp(byte[] cookie, long expiration) {
        ByteArrayWrapper baw;
        Resource resource;
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "renewOp({0},{1})", new Object[]{ByteArrayWrapper.toUuid(cookie), expiration});
        }
        if ((resource = (Resource)this.entries.get(baw = new ByteArrayWrapper(cookie))) == null && (resource = (Resource)this.registrations.get(baw)) == null) {
            Iterator i = this.pendingTxns.values().iterator();
            while (i.hasNext() && (resource = ((PendingTxn)i.next()).get(baw)) == null) {
            }
        }
        if (resource != null) {
            resource.setExpiration(expiration);
        }
    }

    void cancelOp(byte[] cookie) {
        block2: {
            ByteArrayWrapper baw;
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "cancelOp({0})", ByteArrayWrapper.toUuid(cookie));
            }
            if (this.entries.remove(baw = new ByteArrayWrapper(cookie)) != null || this.registrations.remove(baw) != null) break block2;
            Iterator i = this.pendingTxns.values().iterator();
            while (i.hasNext() && ((PendingTxn)i.next()).remove(baw) == null) {
            }
        }
    }

    void prepareOp(Long txnId, StoredObject transaction) {
        logger.log(Level.FINE, "prepareOp({0})", txnId);
        PendingTxn pt = this.pendingTxn(txnId);
        pt.prepare(transaction);
    }

    void commitOp(Long txnId) {
        logger.log(Level.FINE, "commitOp({0})", txnId);
        PendingTxn pt = this.pendingTxn(txnId);
        pt.commit(this);
        this.removePendingTxn(txnId);
    }

    void abortOp(Long txnId) {
        logger.log(Level.FINE, "abortOp({0})", txnId);
        this.removePendingTxn(txnId);
    }

    void uuidOp(byte[] uuid) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "uuidOp({0})", ByteArrayWrapper.toUuid(uuid));
        }
        this.topUuid = uuid;
    }

    private void consumeLogs(boolean all) {
        Iterator it;
        try {
            it = LogInputFile.logs(this.logFileBase, all);
        }
        catch (IOException e) {
            String msg = "couldn't open logs";
            InternalSpaceException ise = new InternalSpaceException("couldn't open logs", e);
            logger.log(Level.SEVERE, "couldn't open logs", ise);
            throw ise;
        }
        while (it.hasNext()) {
            LogInputFile log = (LogInputFile)it.next();
            logger.log(Level.FINE, "processing {0})", log);
            if (log == null) continue;
            try {
                String logFile = log.toString();
                if (this.lastLog == null || !this.lastLog.sameAs(logFile)) {
                    log.consume(this);
                }
                this.lastLog = new LastLog(logFile);
                ObjectOutputStream out = this.snapshotFile.next();
                out.writeInt(3);
                out.writeObject(this.sessionId);
                out.writeObject(this.joinState);
                out.writeObject(this.entries);
                out.writeObject(this.registrations);
                out.writeObject(this.pendingTxns);
                out.writeObject(this.topUuid);
                out.writeObject(this.lastLog);
                this.snapshotFile.commit();
            }
            catch (IOException e) {
                String msg = "error writing snapshot";
                InternalSpaceException ise = new InternalSpaceException("error writing snapshot", e);
                logger.log(Level.SEVERE, "error writing snapshot", ise);
                throw ise;
            }
            log.finished();
        }
    }

    private InternalSpaceException logAndThrowRecoveryException(String msg, Throwable nested) {
        InternalSpaceException e = new InternalSpaceException(msg, nested);
        logger.log(Level.SEVERE, msg, e);
        throw e;
    }

    private static class LastLog
    implements Serializable {
        private String logFile;
        private long timeStamp;

        LastLog(String path) {
            this.logFile = path;
            this.timeStamp = new File(this.logFile).lastModified();
        }

        boolean sameAs(String otherPath) {
            if (!this.logFile.equals(otherPath)) {
                return false;
            }
            return new File(otherPath).lastModified() == this.timeStamp;
        }
    }

    private class ConsumerThread
    extends Thread {
        private boolean more = false;
        private volatile boolean interrupted = false;

        ConsumerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.interrupted) {
                    ConsumerThread consumerThread = this;
                    synchronized (consumerThread) {
                        while (!this.more) {
                            this.wait();
                        }
                        this.more = false;
                    }
                    BackEnd.this.consumeLogs(false);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        private synchronized void update() {
            this.more = true;
            this.notify();
        }

        @Override
        public void interrupt() {
            this.interrupted = true;
            super.interrupt();
        }
    }
}

