/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;

class LogFile {
    protected File baseDir;
    protected String baseFile;
    static final String LOG_TYPE = "LogStore";
    protected static final int LOG_VERSION = 3;
    protected static final byte BOOT_OP = 1;
    protected static final byte JOINSTATE_OP = 11;
    protected static final byte WRITE_OP = 2;
    protected static final byte TAKE_OP = 3;
    protected static final byte REGISTER_OP = 4;
    protected static final byte RENEW_OP = 5;
    protected static final byte NOTIFIED_OP = 6;
    protected static final byte CANCEL_OP = 7;
    protected static final byte PREPARE_OP = 8;
    protected static final byte COMMIT_OP = 9;
    protected static final byte ABORT_OP = 10;
    protected static final byte UUID_OP = 12;
    protected static final byte BATCH_WRITE_OP = 13;
    protected static final byte BATCH_TAKE_OP = 14;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    protected LogFile(File baseDir, String baseFile) {
        this.baseDir = baseDir;
        this.baseFile = baseFile;
    }

    protected LogFile(String basePath) throws IOException {
        this.baseDir = new File(basePath);
        if (this.baseDir.isDirectory()) {
            this.baseFile = "";
        } else {
            this.baseFile = this.baseDir.getName();
            String pname = this.baseDir.getParent();
            if (pname == null) {
                pname = ".";
            }
            this.baseDir = new File(pname);
            if (this.baseFile.charAt(this.baseFile.length() - 1) != '.') {
                this.baseFile = this.baseFile + ".";
            }
        }
    }

    int existingLogs(Collection files) {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "scanning {0} for {1} baseFile", new Object[]{this.baseDir, this.baseFile});
        }
        String[] inDir = this.baseDir.list();
        TreeMap<Integer, File> found = new TreeMap<Integer, File>();
        int highest = -1;
        if (inDir == null) {
            return highest;
        }
        for (int f = 0; f < inDir.length; ++f) {
            int num;
            String name;
            block7: {
                name = inDir[f];
                logger.log(Level.FINE, "checking {0}", name);
                if (!name.startsWith(this.baseFile)) continue;
                try {
                    num = Integer.parseInt(name.substring(this.baseFile.length()));
                    if (num <= highest) break block7;
                    highest = num;
                }
                catch (NumberFormatException e) {
                    continue;
                }
            }
            found.put(num, new File(this.baseDir, name));
        }
        files.addAll(found.values());
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "returning {0} files", files.size());
            Iterator it = files.iterator();
            while (it.hasNext()) {
                logger.log(Level.FINE, it.next().toString());
            }
        }
        return highest;
    }

    void destroy() {
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "destroy");
        }
        ArrayList files = new ArrayList();
        this.existingLogs(files);
        for (int i = 0; i < files.size(); ++i) {
            File log = (File)files.get(i);
            try {
                if (log.delete()) continue;
                logger.log(Level.INFO, "Could not delete {0}", log);
                continue;
            }
            catch (SecurityException e) {
                if (log.delete()) continue;
                logger.log(Level.INFO, "SecurityException : Could not delete " + log, e);
            }
        }
    }
}

