/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.LogOps;
import com.sun.jini.outrigger.StorableObject;
import com.sun.jini.outrigger.StorableResource;
import com.sun.jini.outrigger.snaplogstore.BaseObject;
import com.sun.jini.outrigger.snaplogstore.LogFile;
import com.sun.jini.outrigger.snaplogstore.LogOutputStream;
import com.sun.jini.outrigger.snaplogstore.Registration;
import com.sun.jini.outrigger.snaplogstore.Resource;
import java.io.File;
import java.io.FileDescriptor;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.Observable;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.id.Uuid;
import net.jini.space.InternalSpaceException;

class LogOutputFile
extends LogFile
implements LogOps {
    private RandomAccessFile logFile = null;
    private FileDescriptor logFD;
    private ObjectOutputStream out;
    private int suffix;
    private int opCnt;
    private int maxOps;
    private Observable observable;
    private long logBytes = 0L;
    private final byte[] intBuf = new byte[4];
    private final byte[] zeroBuf = new byte[4];
    private long deferedUpdateLength = 0L;
    private long deferedPosition = 0L;
    private static final long intBytes = 4L;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    LogOutputFile(String basePath, int maxOps) throws IOException {
        super(basePath);
        ArrayList inDir = new ArrayList();
        this.suffix = this.existingLogs(inDir);
        this.maxOps = maxOps;
        this.nextPath();
    }

    Observable observable() {
        if (this.observable == null) {
            this.observable = new Observable(){

                @Override
                public void notifyObservers() {
                    this.setChanged();
                    super.notifyObservers();
                }

                @Override
                public void notifyObservers(Object arg) {
                    this.setChanged();
                    super.notifyObservers(arg);
                }
            };
        }
        return this.observable;
    }

    private void nextPath() throws IOException {
        boolean completed = false;
        if (this.logFile != null) {
            if (this.deferedUpdateLength != 0L) {
                this.logFD.sync();
                this.logFile.seek(this.deferedPosition);
                this.writeInt((int)this.deferedUpdateLength);
            }
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            completed = true;
        }
        ++this.suffix;
        this.logFile = new RandomAccessFile(this.baseDir.getPath() + File.separator + this.baseFile + this.suffix, "rw");
        this.logFD = this.logFile.getFD();
        this.out = new ObjectOutputStream(new LogOutputStream(this.logFile));
        this.writeInt(3);
        this.logBytes = this.logFile.getFilePointer();
        this.logFile.setLength(this.logBytes);
        this.logFile.write(this.zeroBuf);
        this.logFD.sync();
        this.deferedUpdateLength = 0L;
        this.opCnt = 0;
        if (this.observable != null && completed) {
            this.observable.notifyObservers();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() throws IOException {
        if (this.logFile != null) {
            try {
                this.out.close();
                this.logFile.close();
            }
            finally {
                this.logFile = null;
            }
        }
    }

    @Override
    void destroy() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.destroy();
    }

    @Override
    public synchronized void bootOp(long time, long sessionId) {
        try {
            this.out.writeByte(1);
            this.out.writeLong(time);
            this.out.writeLong(sessionId);
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void joinStateOp(StorableObject state) {
        try {
            this.out.writeByte(11);
            this.out.writeObject(new BaseObject(state));
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void writeOp(StorableResource entry, Long txnId) {
        try {
            this.out.writeByte(2);
            this.out.writeObject(new Resource(entry));
            this.out.writeObject(txnId);
            this.flush(txnId == null);
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void writeOp(StorableResource[] entries, Long txnId) {
        try {
            this.out.writeByte(13);
            this.out.writeObject(txnId);
            this.out.writeInt(entries.length);
            for (int i = 0; i < entries.length; ++i) {
                this.out.writeObject(new Resource(entries[i]));
            }
            this.flush(txnId == null, entries.length);
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void takeOp(Uuid cookie, Long txnId) {
        try {
            this.out.writeByte(3);
            cookie.write(this.out);
            this.out.writeObject(txnId);
            this.flush(txnId == null);
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void takeOp(Uuid[] cookies, Long txnId) {
        try {
            this.out.writeByte(14);
            this.out.writeObject(txnId);
            this.out.writeInt(cookies.length);
            for (int i = 0; i < cookies.length; ++i) {
                cookies[i].write(this.out);
            }
            this.flush(txnId == null, cookies.length);
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void registerOp(StorableResource registration, String type, StorableObject[] templates) {
        try {
            this.out.writeByte(4);
            this.out.writeObject(new Registration(registration, type, templates));
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void renewOp(Uuid cookie, long expiration) {
        try {
            this.out.writeByte(5);
            cookie.write(this.out);
            this.out.writeLong(expiration);
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void cancelOp(Uuid cookie, boolean expired) {
        try {
            this.out.writeByte(7);
            cookie.write(this.out);
            this.flush(!expired);
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void prepareOp(Long txnId, StorableObject transaction) {
        try {
            this.out.writeByte(8);
            this.out.writeObject(txnId);
            this.out.writeObject(new BaseObject(transaction));
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void commitOp(Long txnId) {
        try {
            this.out.writeByte(9);
            this.out.writeObject(txnId);
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void abortOp(Long txnId) {
        try {
            this.out.writeByte(10);
            this.out.writeObject(txnId);
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    @Override
    public synchronized void uuidOp(Uuid uuid) {
        try {
            this.out.writeByte(12);
            uuid.write(this.out);
            this.flush();
        }
        catch (IOException e) {
            this.failed(e);
        }
    }

    private void flush() throws IOException {
        this.flush(true);
    }

    private synchronized void flush(boolean forceToDisk) throws IOException {
        this.flush(forceToDisk, 1);
    }

    private synchronized void flush(boolean forceToDisk, int effectiveOpCount) throws IOException {
        assert (effectiveOpCount > 0);
        this.out.flush();
        if (forceToDisk) {
            this.logFD.sync();
        }
        long entryEnd = this.logFile.getFilePointer();
        long updateLen = entryEnd - this.logBytes - 4L;
        if (!forceToDisk) {
            if (this.deferedUpdateLength == 0L) {
                this.deferedUpdateLength = updateLen;
                this.deferedPosition = this.logBytes;
            } else {
                this.logFile.seek(this.logBytes);
                this.writeInt((int)updateLen);
            }
        } else {
            if (this.deferedUpdateLength != 0L) {
                this.logFile.seek(this.deferedPosition);
                this.writeInt((int)this.deferedUpdateLength);
                this.deferedUpdateLength = 0L;
            }
            this.logFile.seek(this.logBytes);
            this.writeInt((int)updateLen);
        }
        entryEnd = entryEnd + 3L & 0xFFFFFFFFFFFFFFFCL;
        this.logFile.seek(entryEnd);
        this.logFile.write(this.zeroBuf);
        this.logBytes = entryEnd;
        if (forceToDisk) {
            this.logFD.sync();
        }
        this.opCnt += effectiveOpCount;
        if (this.opCnt >= this.maxOps) {
            this.nextPath();
        } else {
            this.out.reset();
        }
    }

    private void writeInt(int val) throws IOException {
        this.intBuf[0] = (byte)(val >> 24);
        this.intBuf[1] = (byte)(val >> 16);
        this.intBuf[2] = (byte)(val >> 8);
        this.intBuf[3] = (byte)val;
        this.logFile.write(this.intBuf);
    }

    private void failed(Exception e) throws InternalSpaceException {
        logger.log(Level.SEVERE, "Unexpected I/O error while persisting Space data", e);
        System.exit(-5);
    }
}

