/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.config.Config;
import com.sun.jini.outrigger.LogOps;
import com.sun.jini.outrigger.Recover;
import com.sun.jini.outrigger.Store;
import com.sun.jini.outrigger.snaplogstore.BackEnd;
import com.sun.jini.outrigger.snaplogstore.LogOutputFile;
import com.sun.jini.system.FileSystem;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.config.Configuration;
import net.jini.config.ConfigurationException;
import net.jini.space.InternalSpaceException;

public class LogStore
implements Store {
    private LogOutputFile log;
    private final String path;
    private BackEnd be;
    private int maxOps;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    public LogStore(Configuration config) throws ConfigurationException {
        this.path = (String)Config.getNonNullEntry(config, "com.sun.jini.outrigger", "persistenceDirectory", String.class);
        logger.log(Level.CONFIG, "using directory {0}", this.path);
        FileSystem.ensureDir(this.path);
        this.be = new BackEnd(this.path);
        this.maxOps = Config.getIntEntry(config, "com.sun.jini.outrigger", "maxOps", 1000, 1, Integer.MAX_VALUE);
    }

    @Override
    public LogOps setupStore(Recover space) {
        try {
            this.be.setupStore(space);
            this.log = new LogOutputFile(new File(this.path, "LogStore").getAbsolutePath(), this.maxOps);
            this.log.observable().addObserver(this.be);
        }
        catch (IOException e) {
            String msg = "LogStore: log creation failed";
            InternalSpaceException ise = new InternalSpaceException("LogStore: log creation failed", e);
            logger.log(Level.SEVERE, "LogStore: log creation failed", ise);
            throw ise;
        }
        return this.log;
    }

    @Override
    public void destroy() throws IOException {
        this.be.destroy();
        this.log.destroy();
        new File(this.path).delete();
    }

    @Override
    public void close() throws IOException {
        this.be.close();
        this.log.close();
    }
}

