/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.StorableResource;
import com.sun.jini.outrigger.StoredResource;
import com.sun.jini.outrigger.snaplogstore.BaseObject;
import com.sun.jini.outrigger.snaplogstore.ByteArrayWrapper;
import java.io.IOException;
import java.util.Arrays;
import net.jini.id.Uuid;

class Resource
extends BaseObject
implements StoredResource {
    static final long serialVersionUID = -4248052947306243840L;
    private byte[] cookie;
    private long expiration;

    Resource(StorableResource resource) {
        super(resource);
        Uuid uuid = resource.getCookie();
        this.cookie = ByteArrayWrapper.toByteArray(uuid);
        this.expiration = resource.getExpiration();
    }

    ByteArrayWrapper getCookieAsWrapper() {
        return new ByteArrayWrapper(this.cookie);
    }

    void setExpiration(long newExpiration) {
        this.expiration = newExpiration;
    }

    @Override
    public void restore(StorableResource obj) throws IOException, ClassNotFoundException {
        super.restore(obj);
        obj.setExpiration(this.expiration);
    }

    public int hashCode() {
        return ByteArrayWrapper.hashFor(this.cookie);
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        return Arrays.equals(this.cookie, ((Resource)o).cookie);
    }
}

