/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.outrigger.snaplogstore;

import com.sun.jini.outrigger.snaplogstore.LogFile;
import com.sun.jini.outrigger.snaplogstore.LogOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.logging.Logger;
import net.jini.space.InternalSpaceException;

class SnapshotFile
extends LogFile {
    private RandomAccessFile snapshotFile = null;
    private String fileName = null;
    private String previousFilename = null;
    private ObjectOutputStream out;
    private int suffix;
    private static final Logger logger = Logger.getLogger("com.sun.jini.outrigger.store");

    SnapshotFile(String basePath, File[] recover) throws IOException {
        super(basePath);
        ArrayList snapshots = new ArrayList();
        this.suffix = this.existingLogs(snapshots);
        if (snapshots.size() > 2) {
            throw new InternalSpaceException("More than two snapshot files are present");
        }
        if (snapshots.size() == 2) {
            File file = (File)snapshots.get(1);
            file.delete();
            if (this.suffix == 1) {
                this.suffix = 0;
                recover[0] = null;
            } else {
                recover[0] = (File)snapshots.get(0);
                this.previousFilename = recover[0].getName();
            }
        } else if (snapshots.size() == 1) {
            File file = (File)snapshots.get(0);
            this.previousFilename = file.getName();
            recover[0] = this.suffix == 0 ? null : file;
        } else {
            this.next();
            this.commit();
            recover[0] = null;
        }
    }

    ObjectOutputStream next() throws IOException {
        ++this.suffix;
        this.fileName = this.baseFile + this.suffix;
        this.snapshotFile = new RandomAccessFile(this.baseDir.getPath() + File.separator + this.fileName, "rw");
        this.out = new ObjectOutputStream(new LogOutputStream(this.snapshotFile));
        return this.out;
    }

    void commit() throws IOException {
        if (this.snapshotFile != null) {
            try {
                this.close();
            }
            catch (IOException ignore) {
                // empty catch block
            }
        }
        if (this.previousFilename != null) {
            File file = new File(this.baseDir, this.previousFilename);
            file.delete();
        }
        this.previousFilename = this.fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void close() throws IOException {
        if (this.snapshotFile != null) {
            try {
                this.out.close();
                this.snapshotFile.close();
            }
            finally {
                this.snapshotFile = null;
            }
        }
    }

    @Override
    void destroy() {
        try {
            this.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        super.destroy();
    }
}

