/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.lang.reflect.Method;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationGroupID;
import java.util.Collections;
import net.jini.io.MarshalInputStream;
import net.jini.loader.RiverClassLoader;

class ActivationGroupInit {
    private ActivationGroupInit() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            if (System.getSecurityManager() == null) {
                System.setSecurityManager(new SecurityManager());
            }
            MarshalInputStream in = new MarshalInputStream(System.in, ActivationGroupInit.class.getClassLoader(), false, null, Collections.EMPTY_LIST);
            in.useCodebaseAnnotations();
            ActivationGroupID id = (ActivationGroupID)in.readObject();
            ActivationGroupDesc desc = (ActivationGroupDesc)in.readObject();
            long incarnation = in.readLong();
            Class<?> cl = RiverClassLoader.loadClass(desc.getLocation(), desc.getClassName());
            try {
                Method create = cl.getMethod("createGroup", ActivationGroupID.class, ActivationGroupDesc.class, Long.TYPE);
                create.invoke(null, id, desc, incarnation);
            }
            catch (NoSuchMethodException e) {
                ActivationGroup.createGroup((ActivationGroupID)id, (ActivationGroupDesc)desc, (long)incarnation);
            }
        }
        catch (Exception e) {
            System.err.println("Exception in starting ActivationGroupInit:");
            e.printStackTrace();
        }
        finally {
            try {
                System.in.close();
            }
            catch (Exception exception) {}
        }
    }
}

