/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.io.FilePermission;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.security.Permission;

public final class ExecOptionPermission
extends Permission {
    private static final long serialVersionUID = 5842294756823092756L;
    private transient String prefix;
    private transient boolean plain;
    private transient Permission fp;

    public ExecOptionPermission(String name) {
        super(name);
        if (name == null) {
            throw new NullPointerException("name cannot be null");
        }
        this.init(name);
    }

    private void init(String name) {
        this.prefix = name;
        this.plain = true;
        int last = name.length() - 1;
        if (last >= 0) {
            int mid;
            char c = name.charAt(last);
            if (c == '\"' && last > 0 && name.charAt(0) == '\"') {
                this.prefix = name.substring(1, last);
            } else if (c == '*') {
                this.prefix = name.substring(0, last);
                this.plain = false;
            } else if (c == '}' && (mid = name.lastIndexOf(123)) >= 0) {
                this.prefix = name.substring(0, mid);
                String fpname = name.substring(mid + 1, last);
                if (!fpname.equals("<<ALL FILES>>")) {
                    this.fp = new FilePermission(fpname, "read");
                }
                this.plain = false;
            }
        }
    }

    @Override
    public boolean implies(Permission p) {
        if (!(p instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission ep = (ExecOptionPermission)p;
        if (this.plain) {
            return ep.plain && this.prefix.equals(ep.prefix);
        }
        if (this.fp == null) {
            return ep.prefix.startsWith(this.prefix);
        }
        if (ep.plain) {
            return ep.prefix.startsWith(this.prefix) && this.fp.implies(new FilePermission(ep.prefix.substring(this.prefix.length()), "read"));
        }
        return this.prefix.equals(ep.prefix) && this.fp.implies(ep.fp);
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof ExecOptionPermission)) {
            return false;
        }
        ExecOptionPermission p = (ExecOptionPermission)obj;
        return this.prefix.equals(p.prefix) && this.plain == p.plain && (this.fp == null ? p.fp == null : this.fp.equals(p.fp));
    }

    @Override
    public int hashCode() {
        int h = this.prefix.hashCode();
        if (!this.plain) {
            h = this.fp != null ? (h += this.fp.hashCode()) : ++h;
        }
        return h;
    }

    @Override
    public String getActions() {
        return "";
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        if (this.getName() == null) {
            throw new InvalidObjectException("name cannot be null");
        }
        this.init(this.getName());
    }
}

