/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.Date;

class PipeWriter
implements Runnable {
    private final ByteArrayOutputStream bufOut;
    private int cLast;
    private final byte[] currSep;
    private final PrintWriter out;
    private final InputStream in;
    private final String execString;
    private final Object[] date = new Object[]{new Date()};
    private static final String lineSeparator = System.getProperty("line.separator");
    private static final int lineSeparatorLength = lineSeparator.length();
    private static final String format = "{0,date} {0,time}";
    private static final MessageFormat formatter = new MessageFormat("{0,date} {0,time}");

    private PipeWriter(InputStream in, OutputStream out, String name, String tag) {
        this.in = in;
        this.out = new PrintWriter(out);
        this.bufOut = new ByteArrayOutputStream();
        this.currSep = new byte[lineSeparatorLength];
        this.execString = ":" + name + ':' + tag + ':';
    }

    @Override
    public void run() {
        byte[] buf = new byte[256];
        try {
            int count;
            while ((count = this.in.read(buf)) != -1) {
                this.write(buf, 0, count);
            }
            String lastInBuffer = this.bufOut.toString();
            this.bufOut.reset();
            if (lastInBuffer.length() > 0) {
                this.out.println(this.createAnnotation() + lastInBuffer);
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void write(byte[] b, int off, int len) throws IOException {
        if (len < 0) {
            throw new ArrayIndexOutOfBoundsException(len);
        }
        for (int i = 0; i < len; ++i) {
            this.write(b[off + i]);
        }
    }

    private void write(byte b) throws IOException {
        int i = 0;
        for (i = 1; i < this.currSep.length; ++i) {
            this.currSep[i - 1] = this.currSep[i];
        }
        this.currSep[i - 1] = b;
        this.bufOut.write(b);
        if (this.cLast >= lineSeparatorLength - 1 && lineSeparator.equals(new String(this.currSep))) {
            this.cLast = 0;
            this.out.print(this.createAnnotation() + this.bufOut.toString());
            this.out.flush();
            this.bufOut.reset();
            if (this.out.checkError()) {
                throw new IOException("PipeWriter: IO Exception when writing to output stream.");
            }
        } else {
            ++this.cLast;
        }
    }

    private String createAnnotation() {
        StringBuffer text = new StringBuffer();
        ((Date)this.date[0]).setTime(System.currentTimeMillis());
        formatter.format(this.date, text, (FieldPosition)null);
        text.append(this.execString);
        return text.toString();
    }

    static void plugTogetherPair(String name, InputStream in, OutputStream out, InputStream in1, OutputStream out1) {
        Thread outThread = new Thread((Runnable)new PipeWriter(in, out, name, "out"), name + "-out");
        outThread.setDaemon(true);
        outThread.start();
        Thread errThread = new Thread((Runnable)new PipeWriter(in1, out1, name, "err"), name + "-err");
        errThread.setDaemon(true);
        errThread.start();
    }
}

