/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.ObjID;
import java.rmi.server.UnicastRemoteObject;
import net.jini.export.Exporter;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.transport.LiveRef;

public class SunJrmpExporter
implements Exporter {
    private final int id;
    private final int port;
    private WeakReference ref;
    private static final Method exportMethod;

    public SunJrmpExporter(int id, int port) {
        this.id = id;
        this.port = port;
    }

    @Override
    public Remote export(Remote impl) throws ExportException {
        if (this.ref != null) {
            throw new IllegalStateException("already used for export");
        }
        if (impl == null) {
            throw new NullPointerException();
        }
        this.ref = new WeakReference<Remote>(impl);
        UnicastServerRef uref = this.getServerRef(new LiveRef(new ObjID(this.id), this.port));
        try {
            Object[] args = new Object[]{impl, null, Boolean.TRUE};
            return (Remote)exportMethod.invoke((Object)uref, args);
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof ExportException) {
                throw (ExportException)t;
            }
            if (t instanceof RemoteException) {
                throw new ExportException("export failed", (Exception)t);
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw new AssertionError((Object)t);
        }
        catch (IllegalAccessException e) {
            throw (Error)new IllegalAccessError().initCause(e);
        }
    }

    UnicastServerRef getServerRef(LiveRef lref) {
        return new UnicastServerRef(lref);
    }

    @Override
    public boolean unexport(boolean force) {
        if (this.ref == null) {
            throw new IllegalStateException("no object exported through this exporter");
        }
        Remote impl = (Remote)this.ref.get();
        if (impl == null) {
            return true;
        }
        try {
            return UnicastRemoteObject.unexportObject(impl, force);
        }
        catch (NoSuchObjectException ex) {
            return true;
        }
    }

    static {
        try {
            Class[] paramTypes = new Class[]{Remote.class, Object.class, Boolean.TYPE};
            exportMethod = UnicastServerRef.class.getMethod("exportObject", paramTypes);
        }
        catch (NoSuchMethodException nsme) {
            throw (Error)new NoSuchMethodError().initCause(nsme);
        }
    }
}

