/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.phoenix;

import com.sun.jini.phoenix.DefaultGroupPolicy;
import com.sun.jini.phoenix.GroupPolicy;
import com.sun.jini.phoenix.LocalAccess;
import com.sun.jini.phoenix.SystemPermission;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.rmi.activation.ActivationGroupDesc;
import java.rmi.activation.ActivationSystem;
import java.rmi.server.ExportException;
import java.util.Collection;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.jeri.BasicILFactory;
import net.jini.jeri.BasicInvocationDispatcher;
import net.jini.jeri.InvocationDispatcher;
import net.jini.jeri.ServerCapabilities;

public class SystemAccessILFactory
extends BasicILFactory {
    private final GroupPolicy policy;
    private final boolean localAccessCheck;

    public SystemAccessILFactory() {
        this(new DefaultGroupPolicy(), null);
    }

    public SystemAccessILFactory(GroupPolicy policy, ClassLoader loader) {
        super(null, null, loader);
        this.policy = policy;
        this.localAccessCheck = true;
    }

    public SystemAccessILFactory(MethodConstraints serverConstraints) {
        this(serverConstraints, SystemPermission.class, new DefaultGroupPolicy(), null);
    }

    public SystemAccessILFactory(MethodConstraints serverConstraints, Class permClass, GroupPolicy policy, ClassLoader loader) {
        super(serverConstraints, permClass, loader);
        this.policy = policy;
        this.localAccessCheck = false;
    }

    @Override
    protected InvocationDispatcher createInvocationDispatcher(Collection methods, Remote impl, ServerCapabilities caps) throws ExportException {
        if (impl == null) {
            throw new NullPointerException("impl cannot be null");
        }
        if (!(impl instanceof ActivationSystem)) {
            throw new ExportException("cannot create dispatcher", new IllegalArgumentException("impl must be an ActivationSystem"));
        }
        return new SystemDispatcher(methods, impl, caps, this.getServerConstraints(), this.getPermissionClass(), this.policy, this.localAccessCheck, this.getClassLoader());
    }

    public static class SystemDispatcher
    extends BasicInvocationDispatcher {
        private final GroupPolicy policy;
        private final boolean localAccessCheck;

        public SystemDispatcher(Collection methods, Remote impl, ServerCapabilities serverCaps, MethodConstraints serverConstraints, Class permClass, GroupPolicy policy, boolean localAccessCheck, ClassLoader loader) throws ExportException {
            super(methods, serverCaps, serverConstraints, permClass, loader);
            if (impl == null) {
                throw new NullPointerException("impl is null");
            }
            if (!(impl instanceof ActivationSystem)) {
                throw new IllegalArgumentException("impl not an ActivationSystem instance");
            }
            this.policy = policy;
            this.localAccessCheck = localAccessCheck;
        }

        @Override
        protected void checkAccess(Remote impl, Method method, InvocationConstraints constraints, Collection context) {
            if (this.localAccessCheck) {
                LocalAccess.check();
            } else {
                super.checkAccess(impl, method, constraints, context);
            }
        }

        @Override
        protected Object invoke(Remote impl, Method method, Object[] args, Collection context) throws Throwable {
            String op;
            if (this.policy != null && ((op = method.getName()).equals("registerGroup") || op.equals("setActivationGroupDesc"))) {
                this.policy.checkGroup((ActivationGroupDesc)args[args.length - 1]);
            }
            return super.invoke(impl, method, args, context);
        }
    }
}

