/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.proxy;

import java.io.InvalidObjectException;
import java.lang.reflect.Method;
import net.jini.constraint.BasicMethodConstraints;
import net.jini.core.constraint.InvocationConstraints;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;

public class ConstrainableProxyUtil {
    private ConstrainableProxyUtil() {
        throw new AssertionError();
    }

    public static MethodConstraints translateConstraints(MethodConstraints methodConstraints, Method[] mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings has odd length");
        }
        if (methodConstraints == null) {
            return null;
        }
        int count = mappings.length / 2;
        BasicMethodConstraints.MethodDesc[] descs = new BasicMethodConstraints.MethodDesc[count];
        for (int i = mappings.length - 1; i >= 0; i -= 2) {
            Method from = mappings[i - 1];
            Method to = mappings[i];
            descs[--count] = new BasicMethodConstraints.MethodDesc(to.getName(), to.getParameterTypes(), methodConstraints.getConstraints(from));
        }
        return new BasicMethodConstraints(descs);
    }

    public static boolean equivalentConstraints(MethodConstraints methodConstraints1, MethodConstraints methodConstraints2, Method[] mappings) {
        if (mappings.length % 2 != 0) {
            throw new IllegalArgumentException("mappings has odd length");
        }
        if (methodConstraints1 == null && methodConstraints2 == null) {
            return true;
        }
        if (methodConstraints1 == null || methodConstraints2 == null) {
            return false;
        }
        int count = mappings.length / 2;
        for (int i = 0; i < mappings.length; i += 2) {
            InvocationConstraints c2;
            InvocationConstraints c1 = methodConstraints1.getConstraints(mappings[i]);
            if (c1.equals(c2 = methodConstraints2.getConstraints(mappings[i + 1]))) continue;
            return false;
        }
        return true;
    }

    public static void verifyConsistentConstraints(MethodConstraints methodConstraints, Object proxy, Method[] mappings) throws InvalidObjectException {
        if (!(proxy instanceof RemoteMethodControl)) {
            throw new InvalidObjectException("Proxy does not implement RemoteMethodControl");
        }
        MethodConstraints proxyMethodConstraints = ((RemoteMethodControl)proxy).getConstraints();
        if (!ConstrainableProxyUtil.equivalentConstraints(methodConstraints, proxyMethodConstraints, mappings)) {
            throw new InvalidObjectException("Inconsistent constraints on proxy");
        }
    }
}

