/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.action.GetBooleanAction;
import com.sun.jini.logging.Levels;
import com.sun.jini.proxy.MarshalledWrapper;
import com.sun.jini.reggie.ClassMapper;
import com.sun.jini.reggie.EntryRep;
import com.sun.jini.reggie.RegistrarProxy;
import com.sun.jini.reggie.ServiceType;
import com.sun.jini.reggie.ServiceTypeBase;
import java.io.IOException;
import java.io.Serializable;
import java.rmi.MarshalException;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteObject;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.lookup.ServiceID;
import net.jini.core.lookup.ServiceItem;
import net.jini.security.Security;

class Item
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 2L;
    private static final Logger logger;
    private static final boolean enableImplToStubReplacement;
    public ServiceID serviceID;
    public ServiceType serviceType;
    public String codebase;
    public MarshalledWrapper service;
    public EntryRep[] attributeSets;

    public Item(ServiceItem item) throws RemoteException {
        Object svc = item.service;
        if (enableImplToStubReplacement && svc instanceof Remote) {
            try {
                svc = RemoteObject.toStub((Remote)svc);
                if (logger.isLoggable(Level.FINER)) {
                    logger.log(Level.FINER, "replacing {0} with {1}", new Object[]{item.service, svc});
                }
            }
            catch (NoSuchObjectException e) {
                // empty catch block
            }
        }
        this.serviceID = item.serviceID;
        ServiceTypeBase stb = ClassMapper.toServiceTypeBase(svc.getClass());
        this.serviceType = stb.type;
        this.codebase = stb.codebase;
        try {
            this.service = new MarshalledWrapper(svc);
        }
        catch (IOException e) {
            throw new MarshalException("error marshalling arguments", e);
        }
        this.attributeSets = EntryRep.toEntryRep(item.attributeSets, true);
    }

    public ServiceItem get() {
        Object obj = null;
        try {
            obj = this.service.get();
        }
        catch (Throwable e) {
            RegistrarProxy.handleException(e);
        }
        return new ServiceItem(this.serviceID, obj, EntryRep.toEntry(this.attributeSets));
    }

    public Object clone() {
        try {
            Item item = (Item)super.clone();
            EntryRep[] attrSets = (EntryRep[])item.attributeSets.clone();
            int i = attrSets.length;
            while (--i >= 0) {
                attrSets[i] = (EntryRep)attrSets[i].clone();
            }
            item.attributeSets = attrSets;
            return item;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public static ServiceItem[] toServiceItem(ArrayList reps) {
        ServiceItem[] items = null;
        if (reps != null) {
            items = new ServiceItem[reps.size()];
            int i = items.length;
            while (--i >= 0) {
                items[i] = ((Item)reps.get(i)).get();
            }
        }
        return items;
    }

    static {
        Boolean b;
        logger = Logger.getLogger("com.sun.jini.reggie");
        try {
            b = (Boolean)Security.doPrivileged(new GetBooleanAction("com.sun.jini.reggie.enableImplToStubReplacement"));
        }
        catch (SecurityException e) {
            logger.log(Levels.HANDLED, "failed to read system property", e);
            b = Boolean.FALSE;
        }
        enableImplToStubReplacement = b;
    }
}

