/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.reggie;

import com.sun.jini.lease.AbstractLease;
import com.sun.jini.reggie.Registrar;
import com.sun.jini.reggie.RegistrarLeaseMap;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import net.jini.core.lease.Lease;
import net.jini.core.lease.LeaseMap;
import net.jini.core.lookup.ServiceID;
import net.jini.id.ReferentUuid;
import net.jini.id.ReferentUuids;
import net.jini.id.Uuid;

abstract class RegistrarLease
extends AbstractLease
implements ReferentUuid {
    private static final long serialVersionUID = 2L;
    final Registrar server;
    transient ServiceID registrarID;
    final Uuid leaseID;

    RegistrarLease(Registrar server, ServiceID registrarID, Uuid leaseID, long expiration) {
        super(expiration);
        this.server = server;
        this.registrarID = registrarID;
        this.leaseID = leaseID;
    }

    @Override
    public LeaseMap createLeaseMap(long duration) {
        return new RegistrarLeaseMap(this, duration);
    }

    @Override
    public boolean canBatch(Lease lease) {
        return lease instanceof RegistrarLease && this.registrarID.equals(((RegistrarLease)lease).registrarID);
    }

    @Override
    public Uuid getReferentUuid() {
        return this.leaseID;
    }

    public int hashCode() {
        return this.leaseID.hashCode();
    }

    public boolean equals(Object obj) {
        return ReferentUuids.compare(this, obj);
    }

    public String toString() {
        String className = this.getClass().getName();
        return className + "[registrar=" + this.registrarID + " " + this.server + ", lease=" + this.leaseID + ", " + this.getLeaseType() + "=" + this.getRegID() + "]";
    }

    Registrar getRegistrar() {
        return this.server;
    }

    ServiceID getRegistrarID() {
        return this.registrarID;
    }

    abstract Object getRegID();

    abstract String getLeaseType();

    void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        this.registrarID.writeBytes(out);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.registrarID = new ServiceID(in);
        if (this.server == null) {
            throw new InvalidObjectException("null server");
        }
        if (this.leaseID == null) {
            throw new InvalidObjectException("null leaseID");
        }
    }

    private void readObjectNoData() throws ObjectStreamException {
        throw new InvalidObjectException("no data");
    }
}

