/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.AggregatePolicyProvider;
import com.sun.jini.start.LoaderSplitPolicyProvider;
import com.sun.jini.start.SharedActivationPolicyPermission;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.rmi.MarshalException;
import java.rmi.MarshalledObject;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.ActivationSystem;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.cert.Certificate;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.export.ProxyAccessor;
import net.jini.id.Uuid;
import net.jini.id.UuidFactory;
import net.jini.loader.pref.PreferredClassLoader;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyFileProvider;

public class ActivateWrapper
implements Remote,
Serializable {
    static final Logger logger = Logger.getLogger("com.sun.jini.start.wrapper");
    private static AggregatePolicyProvider globalPolicy;
    private static Policy initialGlobalPolicy;
    private Object impl;
    private static final Class[] actTypes;
    private static String servicePolicyProvider;
    private static final Class[] policyTypes;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ActivateWrapper(ActivationID id, MarshalledObject data) throws Exception {
        try {
            logger.entering(ActivateWrapper.class.getName(), "ActivateWrapper", new Object[]{id, data});
            ActivateDesc desc = (ActivateDesc)data.get();
            logger.log(Level.FINEST, "ActivateDesc: {0}", desc);
            Thread t = Thread.currentThread();
            ClassLoader ccl = t.getContextClassLoader();
            logger.log(Level.FINEST, "Saved current context class loader: {0}", ccl);
            ExportClassLoader cl = null;
            try {
                cl = new ExportClassLoader(desc.importLocation, desc.exportLocation, ccl);
                logger.log(Level.FINEST, "Created ExportClassLoader: {0}", cl);
            }
            catch (Exception e) {
                logger.throwing(ActivateWrapper.class.getName(), "ActivateWrapper", e);
                throw e;
            }
            ActivateWrapper.checkPolicyPermission(desc.policy, desc.importLocation);
            Class<ActivateWrapper> e = ActivateWrapper.class;
            synchronized (ActivateWrapper.class) {
                if (globalPolicy == null) {
                    initialGlobalPolicy = Policy.getPolicy();
                    if (!(initialGlobalPolicy instanceof DynamicPolicy)) {
                        initialGlobalPolicy = new DynamicPolicyProvider(initialGlobalPolicy);
                    }
                    globalPolicy = new AggregatePolicyProvider(initialGlobalPolicy);
                    Policy.setPolicy(globalPolicy);
                    logger.log(Level.FINEST, "Global policy set: {0}", globalPolicy);
                }
                Policy service_policy = ActivateWrapper.getServicePolicyProvider(new PolicyFileProvider(desc.policy));
                Policy backstop_policy = ActivateWrapper.getServicePolicyProvider(initialGlobalPolicy);
                LoaderSplitPolicyProvider split_service_policy = new LoaderSplitPolicyProvider(cl, service_policy, backstop_policy);
                split_service_policy.grant(this.getClass(), null, new Permission[]{new AllPermission()});
                globalPolicy.setPolicy(cl, split_service_policy);
                logger.log(Level.FINEST, "Added policy to set: {0}", desc.policy);
                // ** MonitorExit[e] (shouldn't be in output)
                boolean initialize = false;
                Class<?> ac = Class.forName(desc.className, initialize, cl);
                logger.log(Level.FINEST, "Obtained implementation class: {0}", ac);
                t.setContextClassLoader(cl);
                try {
                    logger.log(Level.FINEST, "Set new context class loader: {0}", cl);
                    Constructor<?> constructor = ac.getDeclaredConstructor(actTypes);
                    logger.log(Level.FINEST, "Obtained implementation constructor: {0}", constructor);
                    constructor.setAccessible(true);
                    this.impl = constructor.newInstance(id, desc.data);
                    logger.log(Level.FINEST, "Obtained implementation instance: {0}", this.impl);
                }
                finally {
                    t.setContextClassLoader(ccl);
                    logger.log(Level.FINEST, "Context class loader reset to: {0}", ccl);
                }
            }
        }
        catch (Exception e) {
            logger.throwing(ActivateWrapper.class.getName(), "ActivateWrapper", e);
            throw e;
        }
        {
            logger.exiting(ActivateWrapper.class.getName(), "ActivateWrapper");
            return;
        }
    }

    private Object writeReplace() throws ObjectStreamException {
        Object impl_proxy = this.impl;
        if (this.impl instanceof ProxyAccessor) {
            impl_proxy = ((ProxyAccessor)this.impl).getProxy();
            logger.log(Level.FINEST, "Obtained implementation proxy: {0}", impl_proxy);
            if (impl_proxy == null) {
                throw new InvalidObjectException("Implementation's getProxy() returned null");
            }
        }
        return impl_proxy;
    }

    public static ActivationID register(ActivationGroupID gid, ActivateDesc desc, boolean restart, ActivationSystem sys) throws ActivationException, RemoteException {
        MarshalledObject<ActivateDesc> data;
        logger.entering(ActivateWrapper.class.getName(), "register", new Object[]{gid, desc, restart, sys});
        try {
            data = new MarshalledObject<ActivateDesc>(desc);
        }
        catch (Exception e) {
            MarshalException me = new MarshalException("marshalling ActivateDesc", e);
            logger.throwing(ActivateWrapper.class.getName(), "register", me);
            throw me;
        }
        ActivationDesc adesc = new ActivationDesc(gid, ActivateWrapper.class.getName(), null, data, restart);
        logger.log(Level.FINEST, "Registering descriptor with activation: {0}", adesc);
        ActivationID aid = sys.registerObject(adesc);
        logger.exiting(ActivateWrapper.class.getName(), "register", aid);
        return aid;
    }

    private static void checkPolicyPermission(String policy, URL[] urls) {
        logger.entering(ActivateWrapper.class.getName(), "checkPolicyPermission", new Object[]{policy, ActivateWrapper.urlsToPath(urls)});
        SharedActivationPolicyPermission perm = new SharedActivationPolicyPermission(policy);
        Certificate[] certs = null;
        CodeSource cs = null;
        ProtectionDomain pd = null;
        for (int i = 0; i < urls.length; ++i) {
            cs = new CodeSource(urls[i], certs);
            pd = new ProtectionDomain(cs, null, null, null);
            logger.log(Level.FINEST, "Checking protection domain: {0}", pd);
            if (pd.implies(perm)) continue;
            SecurityException se = new SecurityException("ProtectionDomain " + pd + " does not have required permission: " + perm);
            logger.throwing(ActivateWrapper.class.getName(), "checkPolicyPermission", se);
            throw se;
        }
        logger.exiting(ActivateWrapper.class.getName(), "checkPolicyPermission");
    }

    private static String urlsToPath(URL[] urls) {
        if (urls == null) {
            return null;
        }
        if (urls.length == 0) {
            return "";
        }
        if (urls.length == 1) {
            return urls[0].toExternalForm();
        }
        StringBuffer path = new StringBuffer(urls[0].toExternalForm());
        for (int i = 1; i < urls.length; ++i) {
            path.append(' ');
            path.append(urls[i].toExternalForm());
        }
        return path.toString();
    }

    static Policy getServicePolicyProvider(Policy service_policy) throws Exception {
        Policy servicePolicyWrapper = null;
        if (servicePolicyProvider != null) {
            Class<?> sp = Class.forName(servicePolicyProvider);
            logger.log(Level.FINEST, "Obtained custom service policy implementation class: {0}", sp);
            Constructor<?> constructor = sp.getConstructor(policyTypes);
            logger.log(Level.FINEST, "Obtained custom service policy implementation constructor: {0}", constructor);
            servicePolicyWrapper = (Policy)constructor.newInstance(service_policy);
            logger.log(Level.FINEST, "Obtained custom service policy implementation instance: {0}", servicePolicyWrapper);
        } else {
            servicePolicyWrapper = new DynamicPolicyProvider(service_policy);
            logger.log(Level.FINEST, "Using default service policy implementation instance: {0}", servicePolicyWrapper);
        }
        return servicePolicyWrapper;
    }

    static {
        actTypes = new Class[]{ActivationID.class, MarshalledObject.class};
        servicePolicyProvider = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Security.getProperty("com.sun.jini.start.servicePolicyProvider");
            }
        });
        policyTypes = new Class[]{Policy.class};
    }

    static class ExportClassLoader
    extends PreferredClassLoader {
        private final URL[] exportURLs;
        private final Uuid id = UuidFactory.generate();

        public ExportClassLoader(URL[] importURLs, URL[] exportURLs, ClassLoader parent) {
            super(importURLs, parent, ActivateWrapper.urlsToPath(exportURLs), false);
            this.exportURLs = exportURLs == null ? importURLs : exportURLs;
        }

        @Override
        public URL[] getURLs() {
            return (URL[])this.exportURLs.clone();
        }

        @Override
        public String toString() {
            URL[] urls = super.getURLs();
            return this.getClass().getName() + "[importURLs=" + (urls == null ? null : Arrays.asList(urls)) + "," + "exportURLs=" + (this.exportURLs == null ? null : Arrays.asList(this.exportURLs)) + "," + "parent=" + this.getParent() + "," + "id=" + this.id + "]";
        }
    }

    public static class ActivateDesc
    implements Serializable {
        private static final long serialVersionUID = 2L;
        public final String className;
        public final URL[] importLocation;
        public final URL[] exportLocation;
        public final String policy;
        public final MarshalledObject data;

        public ActivateDesc(String className, URL[] importLocation, URL[] exportLocation, String policy, MarshalledObject data) {
            this.className = className;
            this.importLocation = importLocation;
            this.exportLocation = exportLocation;
            this.policy = policy;
            this.data = data;
        }

        public String toString() {
            return "[className=" + this.className + "," + "importLocation=" + (this.importLocation == null ? null : Arrays.asList(this.importLocation)) + "," + "exportLocation=" + (this.exportLocation == null ? null : Arrays.asList(this.exportLocation)) + "," + "policy=" + this.policy + "," + "data=" + this.data + "]";
        }
    }
}

