/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import au.net.zeus.collection.RC;
import au.net.zeus.collection.Ref;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.SecurityPermission;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jini.security.SecurityContext;
import net.jini.security.policy.DynamicPolicy;
import net.jini.security.policy.PolicyInitializationException;
import net.jini.security.policy.SecurityContextSource;
import org.apache.river.api.security.AbstractPolicy;
import org.apache.river.api.security.PermissionGrant;
import org.apache.river.api.security.ScalableNestedPolicy;

public class AggregatePolicyProvider
extends AbstractPolicy
implements DynamicPolicy,
SecurityContextSource,
ScalableNestedPolicy {
    private static final String mainPolicyClassProperty = "com.sun.jini.start.AggregatePolicyProvider.mainPolicyClass";
    private static final String defaultMainPolicyClass = "net.jini.security.policy.DynamicPolicyProvider";
    private static final ConcurrentMap<Class, Boolean> trustGetCCL = RC.concurrentMap(new ConcurrentHashMap(), Ref.WEAK_IDENTITY, Ref.STRONG, 1000L, 0L);
    private static final ProtectionDomain myDomain = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

        @Override
        public ProtectionDomain run() {
            return AggregatePolicyProvider.class.getProtectionDomain();
        }
    });
    private final Map<ClassLoader, Policy> subPolicies = new WeakHashMap<ClassLoader, Policy>();
    private final ConcurrentMap<ClassLoader, Policy> subPolicyChildClassLoaderCache = RC.concurrentMap(new ConcurrentHashMap(), Ref.WEAK_IDENTITY, Ref.STRONG, 1000L, 0L);
    private final Lock lock = new ReentrantLock();
    private volatile Policy mainPolicy;

    public AggregatePolicyProvider() throws PolicyInitializationException {
        String cname = Security.getProperty(mainPolicyClassProperty);
        if (cname == null) {
            cname = defaultMainPolicyClass;
        }
        try {
            this.mainPolicy = (Policy)Class.forName(cname).newInstance();
        }
        catch (SecurityException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PolicyInitializationException("unable to construct main policy", e);
        }
        this.ensureDependenciesResolved();
    }

    public AggregatePolicyProvider(Policy mainPolicy) {
        if (mainPolicy == null) {
            throw new NullPointerException();
        }
        this.mainPolicy = mainPolicy;
        this.ensureDependenciesResolved();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource source) {
        return this.getCurrentSubPolicy().getPermissions(source);
    }

    @Override
    public PermissionCollection getPermissions(ProtectionDomain domain) {
        if (domain == myDomain) {
            Permissions pc = new Permissions();
            ((PermissionCollection)pc).add(new AllPermission());
            return pc;
        }
        return this.getCurrentSubPolicy().getPermissions(domain);
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        return domain == myDomain || this.getCurrentSubPolicy().implies(domain, permission);
    }

    @Override
    public void refresh() {
        this.getCurrentSubPolicy().refresh();
    }

    @Override
    public Collection<PermissionGrant> getPermissionGrants(ProtectionDomain domain) {
        Policy p = this.getCurrentSubPolicy();
        if (p instanceof ScalableNestedPolicy) {
            return ((ScalableNestedPolicy)((Object)p)).getPermissionGrants(domain);
        }
        LinkedList<PermissionGrant> c = new LinkedList<PermissionGrant>();
        c.add(this.extractGrantFromPolicy(p, domain));
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPolicy(ClassLoader loader, Policy subPolicy) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new SecurityPermission("setPolicy"));
        }
        this.lock.lock();
        try {
            if (loader != null) {
                if (subPolicy != null) {
                    this.subPolicies.put(loader, subPolicy);
                } else {
                    this.subPolicies.remove(loader);
                }
            } else {
                if (subPolicy == null) {
                    throw new NullPointerException();
                }
                this.mainPolicy = subPolicy;
            }
            this.subPolicyChildClassLoaderCache.clear();
            this.subPolicyChildClassLoaderCache.putAll(this.subPolicies);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public boolean grantSupported() {
        Policy p = this.getCurrentSubPolicy();
        return p instanceof DynamicPolicy && ((DynamicPolicy)((Object)p)).grantSupported();
    }

    @Override
    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        Policy p = this.getCurrentSubPolicy();
        if (!(p instanceof DynamicPolicy)) {
            throw new UnsupportedOperationException("grants not supported");
        }
        ((DynamicPolicy)((Object)p)).grant(cl, principals, permissions);
    }

    @Override
    public Permission[] getGrants(Class cl, Principal[] principals) {
        Policy p = this.getCurrentSubPolicy();
        if (p instanceof DynamicPolicy) {
            return ((DynamicPolicy)((Object)p)).getGrants(cl, principals);
        }
        throw new UnsupportedOperationException("grants not supported");
    }

    @Override
    public SecurityContext getContext() {
        Policy p = this.getCurrentSubPolicy();
        SecurityContext sc = p instanceof SecurityContextSource ? ((SecurityContextSource)((Object)p)).getContext() : new DefaultSecurityContext();
        return new AggregateSecurityContext(sc);
    }

    private void ensureDependenciesResolved() {
        ClassLoader ldr = this.getClass().getClassLoader();
        if (ldr == null) {
            ldr = ClassLoader.getSystemClassLoader();
        }
        AggregatePolicyProvider.trustGetContextClassLoader0(Thread.class);
        AggregatePolicyProvider.getContextClassLoader();
        this.lookupSubPolicy(ldr);
    }

    private Policy getCurrentSubPolicy() {
        ClassLoader ccl;
        Thread t = Thread.currentThread();
        boolean trust = AggregatePolicyProvider.trustGetContextClassLoader(t);
        ClassLoader classLoader = ccl = trust ? AggregatePolicyProvider.getContextClassLoader() : null;
        if (ccl == null) {
            return this.mainPolicy;
        }
        Policy policy = (Policy)this.subPolicyChildClassLoaderCache.get(ccl);
        if (policy != null) {
            return policy;
        }
        return this.lookupSubPolicy(ccl);
    }

    private Policy lookupSubPolicy(final ClassLoader ldr) {
        return AccessController.doPrivileged(new PrivilegedAction<Policy>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Policy run() {
                Policy p = null;
                AggregatePolicyProvider.this.lock.lock();
                try {
                    Policy exists;
                    for (ClassLoader l = ldr; l != null && (p = (Policy)AggregatePolicyProvider.this.subPolicies.get(l)) == null; l = l.getParent()) {
                    }
                    if (p == null) {
                        p = AggregatePolicyProvider.this.mainPolicy;
                    }
                    if ((exists = AggregatePolicyProvider.this.subPolicyChildClassLoaderCache.putIfAbsent(ldr, p)) != null && p != exists) {
                        throw new IllegalStateException("Policy Mutation occured");
                    }
                }
                finally {
                    AggregatePolicyProvider.this.lock.unlock();
                }
                return p;
            }
        });
    }

    static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    private static boolean trustGetContextClassLoader(Thread t) {
        Class<?> cl = t.getClass();
        if (cl == Thread.class) {
            return true;
        }
        Boolean b = (Boolean)trustGetCCL.get(cl);
        if (b == null) {
            b = AggregatePolicyProvider.trustGetContextClassLoader0(cl);
            trustGetCCL.putIfAbsent(cl, b);
        }
        return b;
    }

    private static Boolean trustGetContextClassLoader0(final Class cl) {
        return AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                try {
                    Method m = cl.getMethod("getContextClassLoader", new Class[0]);
                    return m.getDeclaringClass() == Thread.class;
                }
                catch (NoSuchMethodException ex) {
                    throw new InternalError("Thread.getContextClassLoader() not found");
                }
            }
        });
    }

    private static class AggregateSecurityContext
    implements SecurityContext {
        private final ClassLoader ccl;
        private final SecurityContext sc;
        private final int hashCode;

        AggregateSecurityContext(SecurityContext sc) {
            if (sc == null) {
                throw new NullPointerException();
            }
            this.sc = sc;
            this.ccl = AggregatePolicyProvider.getContextClassLoader();
            int hash = 3;
            hash = 61 * hash + (this.ccl != null ? this.ccl.hashCode() : 0);
            this.hashCode = hash = 61 * hash + (this.sc != null ? this.sc.hashCode() : 0);
        }

        @Override
        public <T> PrivilegedAction<T> wrap(PrivilegedAction<T> a) {
            final PrivilegedAction<T> wa = this.sc.wrap(a);
            return new PrivilegedAction<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T run() {
                    Object t;
                    ClassLoader sccl = AggregateSecurityContext.this.setCCL(AggregateSecurityContext.this.ccl, false);
                    try {
                        t = wa.run();
                    }
                    catch (Throwable throwable) {
                        AggregateSecurityContext.this.setCCL(sccl, sccl != AggregateSecurityContext.this.ccl);
                        throw throwable;
                    }
                    AggregateSecurityContext.this.setCCL(sccl, sccl != AggregateSecurityContext.this.ccl);
                    return t;
                }
            };
        }

        @Override
        public <T> PrivilegedExceptionAction<T> wrap(PrivilegedExceptionAction<T> a) {
            final PrivilegedExceptionAction<T> wa = this.sc.wrap(a);
            return new PrivilegedExceptionAction<T>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public T run() throws Exception {
                    Object t;
                    ClassLoader sccl = AggregateSecurityContext.this.setCCL(AggregateSecurityContext.this.ccl, false);
                    try {
                        t = wa.run();
                    }
                    catch (Throwable throwable) {
                        AggregateSecurityContext.this.setCCL(sccl, sccl != AggregateSecurityContext.this.ccl);
                        throw throwable;
                    }
                    AggregateSecurityContext.this.setCCL(sccl, sccl != AggregateSecurityContext.this.ccl);
                    return t;
                }
            };
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.sc.getAccessControlContext();
        }

        private ClassLoader setCCL(final ClassLoader ldr, final boolean force) {
            return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                @Override
                public ClassLoader run() {
                    Thread t = Thread.currentThread();
                    ClassLoader old = null;
                    if (force || ldr != (old = t.getContextClassLoader())) {
                        t.setContextClassLoader(ldr);
                    }
                    return old;
                }
            });
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AggregateSecurityContext)) {
                return false;
            }
            AggregateSecurityContext that = (AggregateSecurityContext)o;
            if (this.sc.equals(that.sc)) {
                if (this.ccl == that.ccl) {
                    return true;
                }
                if (this.ccl != null && this.ccl.equals(that.ccl)) {
                    return true;
                }
            }
            return false;
        }
    }

    private static class DefaultSecurityContext
    implements SecurityContext {
        private final AccessControlContext acc = AccessController.getContext();
        private final int hashCode;

        DefaultSecurityContext() {
            int hash = 5;
            this.hashCode = hash = 47 * hash + (this.acc != null ? this.acc.hashCode() : 0);
        }

        @Override
        public <T> PrivilegedAction<T> wrap(PrivilegedAction<T> a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public <T> PrivilegedExceptionAction<T> wrap(PrivilegedExceptionAction<T> a) {
            if (a == null) {
                throw new NullPointerException();
            }
            return a;
        }

        @Override
        public AccessControlContext getAccessControlContext() {
            return this.acc;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object o) {
            if (!(o instanceof DefaultSecurityContext)) {
                return false;
            }
            SecurityContext that = (SecurityContext)o;
            return this.getAccessControlContext().equals(that.getAccessControlContext());
        }
    }
}

