/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.start;

import com.sun.jini.start.SharedGroupBackEnd;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.core.constraint.MethodConstraints;
import net.jini.core.constraint.RemoteMethodControl;
import net.jini.security.TrustVerifier;
import net.jini.security.proxytrust.TrustEquivalence;

final class ProxyVerifier
implements TrustVerifier,
Serializable {
    private static final long serialVersionUID = 1L;
    protected static final String START_PROXY = "com.sun.jini.start.proxy";
    private static final Logger logger = Logger.getLogger("com.sun.jini.start.proxy");
    private final RemoteMethodControl serverProxy;

    ProxyVerifier(SharedGroupBackEnd serverProxy) {
        if (!(serverProxy instanceof RemoteMethodControl)) {
            throw new UnsupportedOperationException("No verifier available for non-secure service");
        }
        if (!(serverProxy instanceof TrustEquivalence)) {
            throw new UnsupportedOperationException("Verifier requires service proxy to implement TrustEquivalence");
        }
        this.serverProxy = (RemoteMethodControl)((Object)serverProxy);
    }

    @Override
    public boolean isTrustedObject(Object obj, TrustVerifier.Context ctx) throws RemoteException {
        logger.entering(ProxyVerifier.class.getName(), "isTrustedObject", new Object[]{obj, ctx});
        if (obj == null || ctx == null) {
            throw new NullPointerException("Arguments must not be null");
        }
        if (!(obj instanceof SharedGroupBackEnd)) {
            logger.log(Level.FINEST, "Object {0} is not a supported type", obj);
            return false;
        }
        RemoteMethodControl otherServerProxy = (RemoteMethodControl)obj;
        MethodConstraints mc = otherServerProxy.getConstraints();
        TrustEquivalence trusted = (TrustEquivalence)((Object)this.serverProxy.setConstraints(mc));
        boolean result = trusted.checkTrustEquivalence(otherServerProxy);
        logger.exiting(ProxyVerifier.class.getName(), "isTrustedObject", result);
        return result;
    }
}

