/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.FileNotFoundException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import net.jini.url.httpmd.HttpmdUtil;

public class ComputeDigest {
    private static ResourceBundle resources;
    private static boolean resinit;

    private ComputeDigest() {
    }

    public static void main(String[] args) {
        if (args.length < 1 || args.length > 2) {
            ComputeDigest.print("computedigest.usage", null);
            System.exit(1);
        }
        String algorithm = args.length > 1 ? args[1] : "SHA-1";
        try {
            URL url = new URL(new URL("file:"), args[0]);
            System.out.println(HttpmdUtil.computeDigest(url, algorithm));
            return;
        }
        catch (FileNotFoundException e) {
            ComputeDigest.print("computedigest.notfound", args[0]);
        }
        catch (NoSuchAlgorithmException e) {
            ComputeDigest.print("computedigest.badalg", algorithm);
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        System.exit(1);
    }

    private static synchronized String getString(String key) {
        try {
            if (!resinit) {
                resources = ResourceBundle.getBundle("com.sun.jini.tool.resources.computedigest");
                resinit = true;
            }
            return resources.getString(key);
        }
        catch (MissingResourceException e) {
            e.printStackTrace();
            System.err.println("Unable to find a required resource.");
            System.exit(1);
            return null;
        }
    }

    private static void print(String key, String val) {
        String fmt = ComputeDigest.getString(key);
        if (fmt == null) {
            fmt = "no text found: \"" + key + "\" {0}";
        }
        System.err.println(MessageFormat.format(fmt, val));
    }

    static {
        resinit = false;
    }
}

