/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jini.tool;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.Permission;
import java.security.Policy;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jini.security.policy.DynamicPolicyProvider;
import net.jini.security.policy.PolicyInitializationException;

public class DebugDynamicPolicyProvider
extends DynamicPolicyProvider {
    private static final Logger logger = Logger.getLogger("net.jini.security.policy");
    private static boolean grantAll = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return Boolean.valueOf(Security.getProperty("com.sun.jini.tool.DebugDynamicPolicyProvider.grantAll"));
        }
    });
    private static final Set requests = new HashSet();
    private static final CodeSource emptyCS = new CodeSource(null, (Certificate[])null);

    public DebugDynamicPolicyProvider() throws PolicyInitializationException {
    }

    public DebugDynamicPolicyProvider(Policy basePolicy) {
        super(basePolicy);
    }

    @Override
    public void grant(Class cl, Principal[] principals, Permission[] permissions) {
        try {
            super.grant(cl, principals, permissions);
            if (permissions == null || permissions.length == 0 || !logger.isLoggable(Level.FINER)) {
                return;
            }
            Request req = new Request(cl, principals, permissions);
            if (cl == null) {
                logger.log(Level.FINER, "Granting permissions for all classes:\n{0}", req.toString());
            } else {
                logger.log(Level.FINER, "Granting permissions for {0}:\n{1}", new Object[]{cl, req.toString()});
            }
        }
        catch (SecurityException e) {
            if (logger.isLoggable(Level.FINE)) {
                logger.log(Level.FINE, "Granting permissions failed", e);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean implies(ProtectionDomain pd, Permission perm) {
        boolean result;
        boolean implies = super.implies(pd, perm);
        boolean bl = result = implies ? true : grantAll;
        if (!(logger.isLoggable(Level.FINER) || !implies && logger.isLoggable(Level.WARNING))) {
            return result;
        }
        Request request = new Request(pd, perm);
        Set set = requests;
        synchronized (set) {
            if (requests.contains(request)) {
                return result;
            }
            requests.add(request);
        }
        String stackTrace = null;
        if (logger.isLoggable(Level.FINEST) || !implies && logger.isLoggable(Level.FINE)) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            new Exception("Stack trace:").printStackTrace(pw);
            pw.close();
            stackTrace = sw.toString();
        }
        if (implies) {
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "Permission granted:\n{0}\n{1}", new Object[]{request.toString(), stackTrace});
            } else {
                logger.log(Level.FINER, "Permission granted:\n{0}", request.toString());
            }
        } else if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.WARNING, grantAll ? "Permission not granted by base policy:\n{0}\n{1}" : "Permission not granted:\n{0}\n{1}", new Object[]{request.toString(), stackTrace});
        } else {
            logger.log(Level.WARNING, grantAll ? "Permission not granted by base policy:\n{0}" : "Permission not granted:\n{0}", request.toString());
        }
        return result;
    }

    private static String getCertName(Certificate cert) {
        if (cert instanceof X509Certificate) {
            return ((X509Certificate)cert).getSubjectDN().getName();
        }
        return cert.toString();
    }

    private static String quoteString(String s) {
        if (s == null) {
            return "";
        }
        int len = s.length();
        StringBuffer buf = new StringBuffer(len + 2);
        buf.append('\"');
        int off = 0;
        while (off < len) {
            int quote = s.indexOf(34, off);
            int slash = s.indexOf(92, off);
            if (quote >= 0 && (slash < 0 || slash > quote)) {
                buf.append(s.substring(off, quote));
                buf.append("\\\"");
                off = quote + 1;
                continue;
            }
            if (slash >= 0) {
                buf.append(s.substring(off, slash));
                buf.append("\\\\");
                off = slash + 1;
                continue;
            }
            buf.append(s.substring(off));
            break;
        }
        buf.append('\"');
        return buf.toString();
    }

    private static class Request {
        final CodeSource codeSource;
        final Certificate[] certs;
        final Principal[] principals;
        final Permission[] perms;

        Request(ProtectionDomain pd, Permission perm) {
            this.codeSource = pd.getCodeSource();
            this.certs = this.codeSource == null ? null : this.codeSource.getCertificates();
            this.principals = pd.getPrincipals();
            this.perms = new Permission[]{perm};
        }

        Request(final Class cl, Principal[] principals, Permission[] perms) {
            this.codeSource = cl == null ? emptyCS : (CodeSource)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getProtectionDomain().getCodeSource();
                }
            });
            this.certs = null;
            this.principals = principals;
            this.perms = perms;
        }

        public boolean equals(Object o) {
            if (o instanceof Request) {
                Request other = (Request)o;
                return (this.codeSource == null ? other.codeSource == null : Request.equals(this.codeSource.getLocation(), other.codeSource.getLocation())) && Request.equals(this.principals, other.principals) && Request.equals(this.perms, other.perms);
            }
            return false;
        }

        private static boolean equals(Object x, Object y) {
            return x == null ? y == null : x.equals(y);
        }

        private static boolean equals(Object[] x, Object[] y) {
            if (x == null) {
                return y == null;
            }
            if (y == null) {
                return false;
            }
            return Arrays.equals(x, y);
        }

        public int hashCode() {
            return Request.hash(this.codeSource == null ? null : this.codeSource.getLocation()) ^ Request.hash(this.certs) ^ Request.hash(this.principals) ^ Request.hash(this.perms);
        }

        private static int hash(Object obj) {
            return obj == null ? 0 : obj.hashCode();
        }

        private static int hash(Object[] array) {
            int result = 0;
            if (array != null) {
                int i = array.length;
                while (--i >= 0) {
                    result ^= Request.hash(array[i]);
                }
            }
            return result;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("grant\n");
            if (this.codeSource == null) {
                buf.append("    /* bootstrap codebase */\n");
            } else {
                URL location = this.codeSource.getLocation();
                if (location != null) {
                    buf.append("    codeBase ");
                    buf.append(DebugDynamicPolicyProvider.quoteString(location.toString()));
                    buf.append('\n');
                }
                if (this.certs != null) {
                    for (int i = 0; i < this.certs.length; ++i) {
                        buf.append("    signedby ");
                        buf.append(DebugDynamicPolicyProvider.quoteString(DebugDynamicPolicyProvider.getCertName(this.certs[i])));
                        buf.append('\n');
                    }
                }
            }
            if (this.principals != null) {
                for (int i = 0; i < this.principals.length; ++i) {
                    buf.append("    principal ");
                    buf.append(this.principals[i].getClass().getName());
                    buf.append(' ');
                    buf.append(DebugDynamicPolicyProvider.quoteString(this.principals[i].getName()));
                    buf.append('\n');
                }
            }
            buf.append("{\n");
            for (int i = 0; i < this.perms.length; ++i) {
                Permission perm = this.perms[i];
                buf.append("    permission ");
                buf.append(perm.getClass().getName());
                buf.append('\n');
                buf.append("        ");
                buf.append(DebugDynamicPolicyProvider.quoteString(perm.getName()));
                String actions = perm.getActions();
                if (actions != null && actions.length() != 0) {
                    buf.append(",\n");
                    buf.append("        ");
                    buf.append(DebugDynamicPolicyProvider.quoteString(perm.getActions()));
                }
                buf.append(";\n");
            }
            buf.append("};");
            return buf.toString();
        }
    }
}

